/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ComponentReference;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.MissingComponentExceptionImpl;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaStructure;
import com.saxonica.ee.schema.Unique;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.type.MissingComponentException;

public class IdentityConstraintReference
extends SchemaStructure
implements ComponentReference {
    private StructuredQName targetQName;
    private boolean dangling;
    private IdentityConstraint target;
    private int expectedKind;

    public IdentityConstraintReference() {
    }

    public IdentityConstraintReference(StructuredQName targetQName, int kind, EnterpriseConfiguration config, SourceLocator locator) {
        this.setConfiguration(config);
        this.targetQName = targetQName;
        this.expectedKind = kind;
        if (locator != null) {
            this.setLocator(locator);
        }
    }

    public int getExpectedKindOfConstraint() {
        return this.expectedKind;
    }

    @Override
    public boolean isResolved() {
        return this.target != null;
    }

    @Override
    public boolean isDangling() {
        return this.dangling;
    }

    public void setTarget(IdentityConstraint target) {
        this.target = target;
        this.targetQName = target.getConstraintName();
        if (target instanceof Key) {
            this.expectedKind = 599;
        } else if (target instanceof Unique) {
            this.expectedKind = 625;
        } else if (target instanceof KeyRef) {
            this.expectedKind = 600;
        }
    }

    @Override
    public StructuredQName getTargetComponentName() {
        return this.targetQName;
    }

    @Override
    public int getSymbolSpace() {
        return 807;
    }

    @Override
    public IdentityConstraint getTarget() throws MissingComponentException {
        if (this.target == null) {
            throw new MissingComponentExceptionImpl(this);
        }
        return this.target;
    }

    @Override
    public void tryToResolve(SchemaCompiler compiler) {
        if (!this.dangling) {
            if (this.target == null) {
                this.target = compiler.getPreparedSchema().getIdentityConstraint(this.getTargetComponentName());
            }
            if (this.target == null) {
                this.target = this.getConfiguration().getSuperSchema().getIdentityConstraint(this.getTargetComponentName());
            }
            if (this.target == null) {
                this.dangling = true;
            }
        }
    }
}

