/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.AttributeDecl;
import com.saxonica.ee.schema.AttributeGroupDecl;
import com.saxonica.ee.schema.AttributeUse;
import com.saxonica.ee.schema.AttributeWildcard;
import com.saxonica.ee.schema.ChoiceModelGroup;
import com.saxonica.ee.schema.ComponentWithValueConstraint;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ElementParticle;
import com.saxonica.ee.schema.ElementWildcard;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.IdentityConstraint;
import com.saxonica.ee.schema.IdentityConstraintReference;
import com.saxonica.ee.schema.IdentityField;
import com.saxonica.ee.schema.IdentitySelector;
import com.saxonica.ee.schema.Key;
import com.saxonica.ee.schema.KeyRef;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Notation;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.PreprocessFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SequenceModelGroup;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.TypeAlternative;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.Unique;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.UserListType;
import com.saxonica.ee.schema.UserSchemaComponent;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.UserUnionType;
import com.saxonica.ee.schema.ValueConstraint;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.DeterminizedState;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.FiniteStateMachine;
import com.saxonica.ee.schema.sdoc.SelectionParser;
import com.saxonica.ee.schema.sdoc.XSDAssert;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Stack;
import java.util.StringTokenizer;
import javax.xml.transform.Source;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.CheckSumFilter;
import net.sf.saxon.event.NamespaceReducer;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.event.ProxyReceiver;
import net.sf.saxon.event.Sender;
import net.sf.saxon.event.Sink;
import net.sf.saxon.expr.instruct.SavedNamespaceContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.om.AtomicArray;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamePool;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.sxpath.IndependentContext;
import net.sf.saxon.sxpath.XPathEvaluator;
import net.sf.saxon.sxpath.XPathExpression;
import net.sf.saxon.sxpath.XPathVariable;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.AttributeCollectionImpl;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.NotationValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.Whitespace;

public class SchemaModelLoader
extends ProxyReceiver {
    private final EnterpriseConfiguration config;
    private final PreparedSchema schema;
    private SchemaCompiler compiler;
    private final HashMap<String, SchemaComponent> components = new HashMap(100);
    private final HashSet<SchemaComponent> anonComponents = new HashSet(100);
    private final List<Fixup> fixups = new ArrayList<Fixup>();
    private final Stack<SCMNodeHandler> handlerStack = new Stack();
    private NamespaceResolver namespaceResolver;
    private NodeName elementName;
    private final AttributeCollectionImpl attributes;
    private final List<PendingEdge> pendingEdges = new ArrayList<PendingEdge>();
    private String dmk = null;
    private static final int FIXUP_ELEMENT_TYPE = 1;
    private static final int FIXUP_ELEMENT_SUBSTITUTION_GROUP = 2;
    private static final int FIXUP_ATTRIBUTE_TYPE = 11;
    private static final int FIXUP_ALTERNATIVE_TYPE = 12;
    private static final int FIXUP_COMPLEX_TYPE_BASE_TYPE = 21;
    private static final int FIXUP_COMPLEX_TYPE_SIMPLE_TYPE = 22;
    private static final int FIXUP_COMPLEX_TYPE_OPEN_CONTENT_SUFFIX = 23;
    private static final int FIXUP_COMPLEX_TYPE_OPEN_CONTENT_INTERLEAVE = 24;
    private static final int FIXUP_SIMPLE_TYPE_ITEM_TYPE = 31;
    private static final int FIXUP_SIMPLE_TYPE_MEMBER_TYPE = 32;
    private static final int FIXUP_SIMPLE_TYPE_BASE_TYPE = 33;
    private static final int FIXUP_ATTRIBUTE_USE_DECLARATION = 41;
    private static final int FIXUP_ATTRIBUTE_WILDCARD_REF = 42;
    private static final int FIXUP_ELEMENT_PARTICLE_REF = 51;
    private static final int FIXUP_ELEMENT_WILDCARD_REF = 52;
    private static final int FIXUP_MODEL_GROUP_PARTICLE_REF = 61;
    private static final int FIXUP_KEYREF_KEY = 62;
    private static final int FIXUP_IDENTITY_CONSTRAINT_REF = 63;

    public SchemaModelLoader(Configuration config) {
        super(new Sink(config.makePipelineConfiguration()));
        this.getPipelineConfiguration().getParseOptions().setSchemaValidationMode(4);
        this.config = (EnterpriseConfiguration)config;
        this.schema = new PreparedSchema((EnterpriseConfiguration)config);
        this.attributes = new AttributeCollectionImpl(config);
    }

    public PreparedSchema load(Source source) throws XPathException {
        PipelineConfiguration pipe = this.config.makePipelineConfiguration();
        pipe.getParseOptions().setSchemaValidationMode(4);
        pipe.setHostLanguage(52);
        NamespaceReducer reducer = new NamespaceReducer(this);
        this.namespaceResolver = reducer;
        this.compiler = this.config.newSchemaCompiler();
        CheckSumFilter filter = new CheckSumFilter(reducer);
        filter.setCheckExistingChecksum(true);
        Sender.send(source, filter, null);
        if (!filter.isChecksumCorrect() && (filter.isChecksumFound() || this.dmk != null)) {
            throw new XPathException("Invalid checksum in compiled schema file");
        }
        try {
            for (Fixup fixup : this.fixups) {
                fixup.apply();
            }
            for (PendingEdge pe : this.pendingEdges) {
                Edge edge;
                Term term;
                DeterminizedState start = (DeterminizedState)pe.machine.getState(pe.fromState);
                DeterminizedState end = (DeterminizedState)pe.machine.getState(pe.toState);
                if (pe.termId.equals("##afterMax")) {
                    term = Edge.MaxOccursTerm.getInstance();
                    edge = new Edge();
                    edge.setTerm(term);
                    edge.setTargetState(end);
                    start.setMaxTransition(edge);
                    continue;
                }
                term = (Term)((Object)this.components.get(pe.termId));
                if (term == null) {
                    throw new SchemaException("Unresolved reference to term " + pe.termId);
                }
                edge = new Edge();
                edge.setTargetState(end);
                edge.setTerm(term);
                if (term instanceof ElementDecl) {
                    start.addSpecificTransition(edge, this.compiler);
                    continue;
                }
                start.addWildcardTransition(this.compiler, edge);
            }
            this.compiler.setPreparedSchema(this.schema);
            for (SchemaComponent o : this.components.values()) {
                if (!(o instanceof ElementDecl) || !((ElementDecl)o).isGlobal()) continue;
                ((ElementDecl)o).fixupSubstitutionGroup(this.compiler);
            }
            for (SchemaComponent o : this.components.values()) {
                if (!(o instanceof UserSchemaComponent)) continue;
                ((UserSchemaComponent)o).elaborate(this.compiler);
            }
            for (SchemaComponent o : this.anonComponents) {
                if (!(o instanceof UserSchemaComponent)) continue;
                ((UserSchemaComponent)o).elaborate(this.compiler);
            }
        }
        catch (SchemaException err) {
            throw new XPathException(err);
        }
        return this.schema;
    }

    @Override
    public void startElement(NodeName nameCode, SchemaType typeCode, Location location, int properties) throws XPathException {
        this.elementName = nameCode;
        this.attributes.clear();
        if (this.handlerStack.isEmpty()) {
            this.handlerStack.push(new SchemaHandler());
        } else {
            SCMNodeHandler next = this.handlerStack.peek().handleChildElement(this.elementName.getLocalPart());
            if (next == null) {
                throw new XPathException("No handler defined for element " + this.elementName.getLocalPart() + " in " + this.handlerStack.peek().getClass().getName());
            }
            this.handlerStack.push(next);
        }
    }

    @Override
    public void startContent() throws XPathException {
        try {
            this.handlerStack.peek().processElementStart(this.elementName.getLocalPart(), this.attributes);
        }
        catch (SchemaException e) {
            throw new XPathException(e);
        }
    }

    @Override
    public void attribute(NodeName nameCode, SimpleType typeCode, CharSequence value, Location locationId, int properties) {
        this.attributes.addAttribute(nameCode, typeCode, value.toString(), locationId, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (!Whitespace.isWhite(chars)) {
            throw new XPathException("Character content not allowed in SCM document");
        }
    }

    @Override
    public void endElement() throws XPathException {
        SCMNodeHandler handler = this.handlerStack.pop();
        handler.processElementEnd();
    }

    private static boolean toBoolean(String s) {
        if (s == null) {
            return false;
        }
        return (s = s.trim()).equals("1") || s.equals("true");
    }

    public int parseFinalOrBlock(String attrName, String finalValue, int allowed) throws SchemaException {
        if (finalValue == null) {
            return 0;
        }
        if (Whitespace.trim(finalValue).equals("#all")) {
            return allowed;
        }
        int result = 0;
        StringTokenizer tokenizer = new StringTokenizer(finalValue, " \t\n\r", false);
        while (tokenizer.hasMoreTokens()) {
            int v;
            String token;
            switch (token = tokenizer.nextToken()) {
                case "union": {
                    v = 4;
                    break;
                }
                case "list": {
                    v = 8;
                    break;
                }
                case "restriction": {
                    v = 1;
                    break;
                }
                case "extension": {
                    v = 2;
                    break;
                }
                case "substitution": {
                    v = 16;
                    break;
                }
                default: {
                    String err = "Invalid " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4);
                    throw new SchemaException(err);
                }
            }
            if ((v & ~allowed) != 0) {
                String err = "The " + Err.wrap(attrName, 2) + " value " + Err.wrap(token, 4) + " is not allowed here";
                throw new SchemaException(err);
            }
            result |= v;
        }
        return result;
    }

    private TypeReference makeTypeReference(String targetId) {
        if (targetId.startsWith("#")) {
            SchemaType builtInType = BuiltInType.getSchemaTypeByLocalName(targetId.substring(1));
            TypeReference ref = new TypeReference(builtInType.getFingerprint(), this.config, null);
            ref.setTarget(builtInType);
            return ref;
        }
        SchemaType userType = (SchemaType)this.components.get(targetId);
        int fp = userType.getFingerprint();
        TypeReference ref = new TypeReference(fp, this.config, null);
        ref.setTarget(userType);
        return ref;
    }

    private class Fixup {
        private final Object source;
        private final String targetId;
        private final int property;

        public Fixup(Object source, String targetId, int property) {
            this.source = source;
            this.targetId = targetId;
            this.property = property;
        }

        public void apply() {
            switch (this.property) {
                case 1: {
                    ((ElementDecl)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 2: {
                    ElementDecl head = (ElementDecl)SchemaModelLoader.this.components.get(this.targetId);
                    ((ElementDecl)this.source).addSubstitutionGroupHead(head.getComponentName());
                    break;
                }
                case 12: {
                    ((TypeAlternative)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 11: {
                    ((AttributeDecl)this.source).setTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 21: {
                    ((UserComplexType)this.source).setBaseTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 22: {
                    ((UserComplexType)this.source).setSimpleContentTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 23: {
                    Wildcard wildcard = (Wildcard)SchemaModelLoader.this.components.get(this.targetId);
                    ((UserComplexType)this.source).setOpenContentWildcard(wildcard, "suffix", true);
                    FiniteStateMachine fsm = ((UserComplexType)this.source).getFiniteStateMachine();
                    if (fsm == null) break;
                    fsm.setOpenContentWildcard(wildcard, false);
                    break;
                }
                case 24: {
                    Wildcard wildcard = (Wildcard)SchemaModelLoader.this.components.get(this.targetId);
                    ((UserComplexType)this.source).setOpenContentWildcard(wildcard, "interleave", true);
                    FiniteStateMachine fsm = ((UserComplexType)this.source).getFiniteStateMachine();
                    if (fsm == null) break;
                    fsm.setOpenContentWildcard(wildcard, true);
                    break;
                }
                case 31: {
                    ((UserListType)this.source).setItemTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 32: {
                    ((UserUnionType)this.source).addMemberTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 33: {
                    ((UserSimpleType)this.source).setBaseTypeReference(SchemaModelLoader.this.makeTypeReference(this.targetId));
                    break;
                }
                case 41: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((AttributeUse)this.source).setTarget(target);
                    ((AttributeUse)this.source).setTargetComponentName(((AttributeDecl)target).getComponentName());
                    break;
                }
                case 42: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((AttributeWildcard)this.source).setWildcard((Wildcard)target);
                    break;
                }
                case 51: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ElementParticle)this.source).setTarget(target);
                    ((ElementParticle)this.source).setTargetComponentName(((ElementDecl)target).getComponentName());
                    break;
                }
                case 52: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ElementWildcard)this.source).setWildcard((Wildcard)target);
                    break;
                }
                case 61: {
                    SchemaComponent target = (SchemaComponent)SchemaModelLoader.this.components.get(this.targetId);
                    ((ModelGroupParticle)this.source).setTarget(target);
                    ((ModelGroupParticle)this.source).setTargetComponentName(((ModelGroupDefinition)target).getModelGroupName());
                    break;
                }
                case 62: {
                    IdentityConstraint target = (IdentityConstraint)SchemaModelLoader.this.components.get(this.targetId);
                    ((KeyRef)this.source).setTargetKey(target);
                    ((KeyRef)this.source).setTargetComponentName(target.getConstraintName());
                    break;
                }
                case 63: {
                    IdentityConstraint target = (IdentityConstraint)SchemaModelLoader.this.components.get(this.targetId);
                    ((IdentityConstraintReference)this.source).setTarget(target);
                    break;
                }
            }
        }
    }

    private static class PendingEdge {
        public FiniteStateMachine machine;
        public int fromState;
        public int toState;
        public String termId;

        private PendingEdge() {
        }
    }

    private class FiniteStateMachineEdgeHandler
    implements SCMNodeHandler {
        private final FiniteStateMachineHandler fsm;
        private final DeterminizedState state;

        public FiniteStateMachineEdgeHandler(FiniteStateMachineHandler fsm, DeterminizedState state) {
            this.fsm = fsm;
            this.state = state;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String term = attributes.getValue("", "term");
            int targetState = Integer.parseInt(attributes.getValue("", "to"));
            PendingEdge pe = new PendingEdge();
            pe.machine = this.fsm.getFiniteStateMachine();
            pe.fromState = this.state.getStateNumber();
            pe.toState = targetState;
            pe.termId = term;
            SchemaModelLoader.this.pendingEdges.add(pe);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class FiniteStateMachineStateHandler
    implements SCMNodeHandler {
        private final FiniteStateMachineHandler fsmHandler;
        private DeterminizedState state;

        public FiniteStateMachineStateHandler(FiniteStateMachineHandler fsmHandler) {
            this.fsmHandler = fsmHandler;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("edge")) {
                return new FiniteStateMachineEdgeHandler(this.fsmHandler, this.state);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String afterMax;
            String stateNumber = attributes.getValue("", "nr");
            FiniteStateMachine fsm = this.fsmHandler.getFiniteStateMachine();
            this.state = stateNumber.equals("0") ? (DeterminizedState)fsm.getInitialState() : new DeterminizedState(fsm);
            String isFinal = attributes.getValue("", "final");
            this.state.setFinalState(SchemaModelLoader.toBoolean(isFinal));
            String min = attributes.getValue("", "minOccurs");
            String max = attributes.getValue("", "maxOccurs");
            if (min != null && max != null) {
                this.state.setLimits(Integer.parseInt(min), max.equals("unbounded") ? -1 : Integer.parseInt(max));
            }
            if ((afterMax = attributes.getValue("", "afterMax")) != null) {
                PendingEdge leavingEdge = new PendingEdge();
                leavingEdge.machine = fsm;
                leavingEdge.termId = "##afterMax";
                leavingEdge.fromState = Integer.parseInt(stateNumber);
                leavingEdge.toState = Integer.parseInt(afterMax);
                SchemaModelLoader.this.pendingEdges.add(leavingEdge);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class FiniteStateMachineHandler
    implements SCMNodeHandler {
        private final FiniteStateMachine fsm;

        public FiniteStateMachineHandler(UserComplexType complexType) {
            this.fsm = new FiniteStateMachine(complexType, true);
            complexType.setFiniteStateMachine(this.fsm);
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("state")) {
                return new FiniteStateMachineStateHandler(this);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
        }

        public FiniteStateMachine getFiniteStateMachine() {
            return this.fsm;
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class WildcardHandler
    implements SCMNodeHandler {
        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String constraint;
            Wildcard wildcard = new Wildcard();
            wildcard.setConfiguration((EnterpriseConfiguration)SchemaModelLoader.this.getConfiguration());
            String id = attributes.getValue("", "id");
            if (id != null) {
                SchemaModelLoader.this.components.put(id, wildcard);
            }
            String processContents = attributes.getValue("", "processContents");
            wildcard.setProcessContents(processContents);
            switch (constraint = attributes.getValue("", "constraint")) {
                case "any": {
                    break;
                }
                case "not": {
                    String ns;
                    String namespaces = attributes.getValue("", "namespaces");
                    StringTokenizer st = new StringTokenizer(namespaces, " \t\n\r");
                    while (st.hasMoreTokens()) {
                        ns = st.nextToken();
                        wildcard.addDisallowedNamespace(ns.equals("##local") ? "" : ns);
                    }
                    break;
                }
                case "enumeration": {
                    String ns;
                    wildcard.setNoNamespacesAllowed();
                    String namespaces = attributes.getValue("", "namespaces");
                    StringTokenizer st = new StringTokenizer(namespaces, " \t\n\r");
                    while (st.hasMoreTokens()) {
                        ns = st.nextToken();
                        wildcard.addAllowedNamespace(ns.equals("##local") ? "" : ns);
                    }
                    break;
                }
                default: {
                    throw new SchemaException("Unknown wildcard constraint " + constraint);
                }
            }
            String disallowedQNames = attributes.getValue("", "notQName");
            if (disallowedQNames != null) {
                NamePool pool = SchemaModelLoader.this.getNamePool();
                StringTokenizer st = new StringTokenizer(disallowedQNames, " \r\t\n");
                while (st.hasMoreTokens()) {
                    String token = st.nextToken();
                    if ("##defined".equals(token)) {
                        wildcard.setDisallowDefinedNames(true);
                        continue;
                    }
                    if ("##definedSibling".equals(token)) {
                        wildcard.setDisallowDefinedSiblings(true);
                        continue;
                    }
                    int nc = pool.allocateClarkName(token);
                    wildcard.addDisallowedQName(nc & 0xFFFFF);
                }
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ItemHandler
    implements SCMNodeHandler {
        private final ValueConstraintHandler container;

        public ItemHandler(ValueConstraintHandler container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            AtomicValue typedValue;
            block5: {
                String type = attributes.getValue("", "type");
                BuiltInAtomicType t = (BuiltInAtomicType)SchemaModelLoader.this.config.getSchemaType(new StructuredQName("", "http://www.w3.org/2001/XMLSchema", type.substring(1)));
                String value = attributes.getValue("", "value");
                String namespace = attributes.getValue("", "namespace");
                try {
                    if (namespace == null) {
                        typedValue = t.getTypedValue(value, null, SchemaModelLoader.this.config.getConversionRules()).head();
                        break block5;
                    }
                    String[] parts = NameChecker.getQNameParts(value);
                    if (t.equals(BuiltInAtomicType.QNAME)) {
                        typedValue = new QNameValue(parts[0], namespace, parts[1]);
                        break block5;
                    }
                    if (t.equals(BuiltInAtomicType.NOTATION)) {
                        typedValue = new NotationValue(parts[0], namespace, parts[1]);
                        break block5;
                    }
                    throw new AssertionError((Object)("Unknown namespace-sensitive type " + type));
                }
                catch (QNameException | XPathException e) {
                    throw new SchemaException(e);
                }
            }
            this.container.appendAtomicValue(typedValue);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ValueConstraintHandler
    implements SCMNodeHandler {
        private final SchemaComponent container;
        private final ArrayList<AtomicValue> atomicValues = new ArrayList(4);
        private String lexicalForm;
        private String variety;

        public ValueConstraintHandler(SchemaComponent container, String variety) {
            this.container = container;
            this.variety = variety;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("item")) {
                return new ItemHandler(this);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            this.lexicalForm = attributes.getValue("", "lexicalForm");
        }

        @Override
        public void processElementEnd() {
            AtomicSequence v = this.atomicValues.size() == 1 ? (AtomicSequence)this.atomicValues.get(0) : new AtomicArray(this.atomicValues);
            if (this.container instanceof ComponentWithValueConstraint) {
                ValueConstraint.Variety var = this.variety.equals("fixed") ? ValueConstraint.Variety.FIXED : ValueConstraint.Variety.DEFAULT;
                ValueConstraint vc = new ValueConstraint(var, this.lexicalForm);
                vc.setValue(v);
                ((ComponentWithValueConstraint)((Object)this.container)).setValueConstraint(vc);
            }
        }

        public void appendAtomicValue(AtomicValue item) {
            this.atomicValues.add(item);
        }
    }

    private class AttributeWildcardHandler
    implements SCMNodeHandler {
        private final SchemaComponent container;

        public AttributeWildcardHandler(SchemaComponent container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            AttributeWildcard awc = new AttributeWildcard((EnterpriseConfiguration)SchemaModelLoader.this.getConfiguration());
            if (this.container instanceof AttributeGroupDecl) {
                ((AttributeGroupDecl)this.container).setAnyAttribute(awc);
            } else if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).setNonInheritedAnyAttribute(awc);
            } else {
                throw new IllegalArgumentException(this.container.getClass().getName());
            }
            String ref = attributes.getValue("", "ref");
            SchemaModelLoader.this.fixups.add(new Fixup(awc, ref, 42));
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class OpenContentHandler
    implements SCMNodeHandler {
        private final UserComplexType container;

        public OpenContentHandler(UserComplexType container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String mode = attributes.getValue("", "mode");
            String wildcardRef = attributes.getValue("", "wildcard");
            if (mode.equals("suffix")) {
                SchemaModelLoader.this.fixups.add(new Fixup(this.container, wildcardRef, 23));
            } else {
                SchemaModelLoader.this.fixups.add(new Fixup(this.container, wildcardRef, 24));
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class AssertionHandler
    implements SCMNodeHandler {
        private final Object container;

        public AssertionHandler(Object container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            XPathExpression condition;
            String xpathText = attributes.getValue("", "test");
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            XPathEvaluator evaluator = this.container instanceof UserComplexType ? new XSDAssert.CustomizedXPath(SchemaModelLoader.this.config) : new XPathEvaluator(SchemaModelLoader.this.config);
            IndependentContext env = (IndependentContext)evaluator.getStaticContext();
            env.setNamespaceResolver(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver));
            env.setBaseURI(xmlBase);
            env.setDefaultElementNamespace(defaultNamespace);
            env.getPackageData().setLocalLicenseId(SchemaModelLoader.this.schema.getLocalLicenseId());
            env.setSchemaAware(true);
            boolean isSimple = this.container instanceof UserSimpleType || this.container instanceof UserComplexType && ((UserComplexType)this.container).isSimpleContent();
            XPathVariable valueVariable = null;
            if (isSimple || this.container instanceof PreprocessFacet || xpathText.contains("$value")) {
                valueVariable = env.declareVariable("", "value");
            }
            try {
                condition = evaluator.createExpression(xpathText);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            Assertion assertion = new Assertion(SchemaModelLoader.this.config, condition, valueVariable, new HashMap<StructuredQName, XPathVariable>(), xpathText);
            assertion.setStaticContext(env);
            if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).addAssertion(assertion);
            } else if (this.container instanceof UserSimpleType) {
                UserSimpleType ust = (UserSimpleType)this.container;
                AssertionFacet facet = new AssertionFacet(assertion);
                ust.addFacet(facet);
            } else if (this.container instanceof PreprocessFacet) {
                PreprocessFacet ppf = (PreprocessFacet)this.container;
                if (ppf.getAction() == null) {
                    ppf.setAction(assertion);
                } else {
                    ppf.setReverseAction(assertion);
                }
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ModelGroupHandler
    implements SCMNodeHandler {
        private final ModelGroupParticle referrer;
        protected ModelGroup group;

        public ModelGroupHandler() {
            this.referrer = null;
        }

        public ModelGroupHandler(ModelGroupParticle referrer) {
            this.referrer = referrer;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "elementParticle": {
                    return new ParticleHandler(this.group);
                }
                case "elementWildcard": {
                    return new ParticleHandler(this.group);
                }
                case "modelGroupParticle": {
                    return new ParticleHandler(this.group);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            switch (localName) {
                case "sequence": {
                    this.group = new SequenceModelGroup();
                    break;
                }
                case "choice": {
                    this.group = new ChoiceModelGroup();
                    break;
                }
                case "all": {
                    this.group = new AllModelGroup();
                    break;
                }
                default: {
                    throw new SchemaException("Unknown kind of model group " + localName);
                }
            }
            if (this.referrer != null) {
                this.referrer.setTarget(this.group);
            }
            SchemaModelLoader.this.anonComponents.add(this.group);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ParticleHandler
    implements SCMNodeHandler {
        private final SchemaComponent container;
        private Particle particle;

        public ParticleHandler(SchemaComponent container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "sequence": {
                    return new ModelGroupHandler((ModelGroupParticle)this.particle);
                }
                case "choice": {
                    return new ModelGroupHandler((ModelGroupParticle)this.particle);
                }
                case "all": {
                    return new ModelGroupHandler((ModelGroupParticle)this.particle);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            switch (localName) {
                case "elementParticle": {
                    this.particle = new ElementParticle(SchemaModelLoader.this.config, null);
                    break;
                }
                case "elementWildcard": {
                    this.particle = new ElementWildcard(SchemaModelLoader.this.config);
                    break;
                }
                case "modelGroupParticle": {
                    this.particle = new ModelGroupParticle(SchemaModelLoader.this.config, null);
                    break;
                }
                default: {
                    throw new SchemaException("Unknown kind of particle " + localName);
                }
            }
            String minOccursAtt = attributes.getValue("", "minOccurs");
            int minOccurs = 1;
            if (minOccursAtt != null) {
                minOccurs = Integer.parseInt(minOccursAtt.trim());
            }
            this.particle.setMinOccurs(minOccurs);
            String maxOccursAtt = attributes.getValue("", "maxOccurs");
            int maxOccurs = -1;
            if (maxOccursAtt != null) {
                maxOccurs = (maxOccursAtt = maxOccursAtt.trim()).equals("unbounded") ? -1 : Integer.parseInt(maxOccursAtt);
            }
            this.particle.setMaxOccurs(maxOccurs);
            if (this.particle instanceof ElementParticle) {
                String ref = attributes.getValue("", "ref");
                SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 51));
            } else if (this.particle instanceof ModelGroupParticle) {
                String ref = attributes.getValue("", "ref");
                if (ref != null) {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 61));
                }
            } else if (this.particle instanceof ElementWildcard) {
                String ref = attributes.getValue("", "ref");
                SchemaModelLoader.this.fixups.add(new Fixup(this.particle, ref, 52));
            } else {
                throw new IllegalStateException("Unknown particle " + this.particle.getClass().getName());
            }
            if (this.container instanceof ModelGroup) {
                ((ModelGroup)this.container).addParticle(this.particle);
            } else if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).setParticle(this.particle);
            } else {
                throw new IllegalArgumentException(this.container.getClass().getName());
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class PreprocessHandler
    implements SCMNodeHandler {
        private final UserSimpleType simpleType;
        private final PreprocessFacet facet;

        public PreprocessHandler(UserSimpleType simpleType) {
            this.simpleType = simpleType;
            this.facet = new PreprocessFacet();
            simpleType.addFacet(this.facet);
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("assertion")) {
                return new AssertionHandler(this.facet);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String fixed = attributes.getValue("", "fixed");
            if (fixed != null) {
                this.facet.setFixed(SchemaModelLoader.toBoolean(fixed));
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class FacetHandler
    implements SCMNodeHandler {
        private final UserSimpleType simpleType;

        public FacetHandler(UserSimpleType simpleType) {
            this.simpleType = simpleType;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("assertion")) {
                return new AssertionHandler(this.simpleType);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            if (!localName.equals("assert")) {
                String value = attributes.getValue("", "value");
                boolean namespaceSensitive = SchemaModelLoader.toBoolean(attributes.getValue("", "namespaceSensitive"));
                SavedNamespaceContext resolver = null;
                if (namespaceSensitive) {
                    resolver = new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver);
                }
                Facet facet = Facet.makeFacet(localName, value, SchemaModelLoader.this.config, resolver, SchemaModelLoader.this.compiler);
                String fixed = attributes.getValue("", "fixed");
                if (fixed != null) {
                    facet.setFixed(SchemaModelLoader.toBoolean(fixed));
                }
                if (facet instanceof PatternFacet) {
                    ((PatternFacet)facet).setDoNotMerge(true);
                    String flags = attributes.getValue("", "flags");
                    if (flags != null) {
                        ((PatternFacet)facet).setFlags(flags);
                    }
                    ((PatternFacet)facet).compile(null);
                }
                this.simpleType.addFacet(facet);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class AttributeUseHandler
    implements SCMNodeHandler {
        private final SchemaComponent container;
        private AttributeUse attributeUse;

        public AttributeUseHandler(SchemaComponent container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("fixed") || localName.equals("default")) {
                return new ValueConstraintHandler(this.attributeUse, localName);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            boolean required = SchemaModelLoader.toBoolean(attributes.getValue("", "required"));
            boolean isInheritable = SchemaModelLoader.toBoolean(attributes.getValue("", "inheritable"));
            String ref = attributes.getValue("", "ref");
            String defaultValue = attributes.getValue("", "default");
            this.attributeUse = new AttributeUse(SchemaModelLoader.this.config);
            this.attributeUse.setInheritable(isInheritable ? 1 : 0);
            if (this.container instanceof UserComplexType) {
                ((UserComplexType)this.container).addNonInheritedAttributeUse(this.attributeUse);
            } else {
                ((AttributeGroupDecl)this.container).addAttributeUse(this.attributeUse);
            }
            this.attributeUse.setUse(required ? (short)5 : 3);
            if (defaultValue != null) {
                ValueConstraint vc = new ValueConstraint(ValueConstraint.Variety.DEFAULT, defaultValue);
                this.attributeUse.setValueConstraint(vc);
            }
            SchemaModelLoader.this.fixups.add(new Fixup(this.attributeUse, ref, 41));
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ModelGroupDefinitionHandler
    extends ModelGroupHandler {
        private ModelGroupDefinitionHandler() {
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            StructuredQName modelGroupName = new StructuredQName("", namespace, name);
            ModelGroupDefinition mgd = new ModelGroupDefinition(SchemaModelLoader.this.config, null);
            mgd.setModelGroupName(modelGroupName);
            SchemaModelLoader.this.components.put(id, mgd);
            SchemaModelLoader.this.schema.addGroup(mgd);
            this.group = mgd;
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class NotationHandler
    implements SCMNodeHandler {
        private NotationHandler() {
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            Notation notation = new Notation(SchemaModelLoader.this.config, null);
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            StructuredQName nameCode = name == null ? new StructuredQName("anon", "http://ns.saxonica.com/anonymous-type", id) : new StructuredQName("", namespace, name);
            notation.setNotationName(nameCode);
            String systemId = attributes.getValue("", "systemId");
            notation.setNotationSystemId(systemId);
            String publicId = attributes.getValue("", "publicId");
            notation.setNotationPublicId(publicId);
            SchemaModelLoader.this.components.put(id, notation);
            SchemaModelLoader.this.schema.addNotation(notation);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class AttributeGroupHandler
    implements SCMNodeHandler {
        final AttributeGroupDecl group;

        public AttributeGroupHandler() {
            this.group = new AttributeGroupDecl(SchemaModelLoader.this.config);
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "attributeUse": {
                    return new AttributeUseHandler(this.group);
                }
                case "attributeWildcard": {
                    return new AttributeWildcardHandler(this.group);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            StructuredQName nameCode = null;
            if (name != null) {
                nameCode = new StructuredQName("", namespace, name);
            }
            SchemaModelLoader.this.components.put(id, this.group);
            this.group.setAttributeGroupName(nameCode);
            SchemaModelLoader.this.schema.addAttributeGroup(this.group);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class SimpleTypeHandler
    implements SCMNodeHandler {
        private UserSimpleType simpleType;

        private SimpleTypeHandler() {
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (Facet.isFacetName(localName, SchemaModelLoader.this.getConfiguration().getXsdVersion()) || localName.equals("assert")) {
                return new FacetHandler(this.simpleType);
            }
            if (localName.equals("preprocess")) {
                return new PreprocessHandler(this.simpleType);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            int fp;
            int fingerprint;
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            if (name == null) {
                fingerprint = SchemaModelLoader.this.config.getNamePool().allocateFingerprint("http://ns.saxonica.com/anonymous-type", id);
                name = id;
                namespace = "http://ns.saxonica.com/anonymous-type";
            } else {
                fingerprint = SchemaModelLoader.this.config.getNamePool().allocateFingerprint(namespace, name);
            }
            String base = attributes.getValue("", "base");
            String variety = attributes.getValue("", "variety");
            String itemType = attributes.getValue("", "itemType");
            String memberTypes = attributes.getValue("", "memberTypes");
            if ("atomic".equals(variety)) {
                this.simpleType = new UserAtomicType(SchemaModelLoader.this.config);
            } else if ("list".equals(variety)) {
                this.simpleType = new UserListType(SchemaModelLoader.this.config);
            } else if ("union".equals(variety)) {
                this.simpleType = new UserUnionType(SchemaModelLoader.this.config);
            } else {
                throw new SchemaException("Unknown simple type variety: " + variety);
            }
            SchemaModelLoader.this.components.put(id, this.simpleType);
            this.simpleType.setTypeName(new StructuredQName("", namespace, name), fingerprint);
            if (base != null) {
                if (base.startsWith("#")) {
                    fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", base.substring(1));
                    this.simpleType.setBaseTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, base, 33));
                }
            }
            if (itemType != null) {
                if (itemType.startsWith("#")) {
                    fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", itemType.substring(1));
                    ((UserListType)this.simpleType).setItemTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, itemType, 31));
                }
            }
            if (memberTypes != null) {
                StringTokenizer st = new StringTokenizer(memberTypes, " \t\n\r");
                while (st.hasMoreTokens()) {
                    String memberType = st.nextToken();
                    if (memberType.startsWith("#")) {
                        int fp2 = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", memberType.substring(1));
                        ((UserUnionType)this.simpleType).addMemberTypeReference(new TypeReference(fp2, SchemaModelLoader.this.config, null));
                        continue;
                    }
                    SchemaModelLoader.this.fixups.add(new Fixup(this.simpleType, memberType, 32));
                }
            }
            if (name == null) {
                SchemaModelLoader.this.schema.addAnonymousType(this.simpleType);
            } else {
                SchemaModelLoader.this.schema.addType(this.simpleType);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ComplexTypeHandler
    implements SCMNodeHandler {
        UserComplexType complexType;

        private ComplexTypeHandler() {
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "openContent": {
                    return new OpenContentHandler(this.complexType);
                }
                case "attributeUse": {
                    return new AttributeUseHandler(this.complexType);
                }
                case "attributeWildcard": {
                    return new AttributeWildcardHandler(this.complexType);
                }
                case "modelGroup": {
                    return new ParticleHandler(this.complexType);
                }
                case "elementParticle": {
                    return new ParticleHandler(this.complexType);
                }
                case "elementWildcard": {
                    return new ParticleHandler(this.complexType);
                }
                case "modelGroupParticle": {
                    return new ParticleHandler(this.complexType);
                }
                case "finiteStateMachine": {
                    return new FiniteStateMachineHandler(this.complexType);
                }
                case "assertion": {
                    return new AssertionHandler(this.complexType);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            int fp;
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            if (name == null) {
                fp = SchemaModelLoader.this.config.getNamePool().allocateFingerprint("http://ns.saxonica.com/anonymous-type", id);
                name = id;
                namespace = "http://ns.saxonica.com/anonymous-type";
            } else {
                fp = SchemaModelLoader.this.config.getNamePool().allocateFingerprint(namespace, name);
            }
            String base = attributes.getValue("", "base");
            String variety = attributes.getValue("", "variety");
            boolean isAbstract = SchemaModelLoader.toBoolean(attributes.getValue("", "abstract"));
            String derivation = attributes.getValue("", "derivationMethod");
            String simpleType = attributes.getValue("", "simpleType");
            this.complexType = new UserComplexType(SchemaModelLoader.this.config, null);
            this.complexType.setEmptyCombinedAttributeGroup();
            SchemaModelLoader.this.components.put(id, this.complexType);
            this.complexType.setTypeName(new StructuredQName("", namespace, name), fp);
            if (base != null) {
                if (base.startsWith("#")) {
                    int basefp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", base.substring(1));
                    this.complexType.setBaseTypeReference(new TypeReference(basefp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.complexType, base, 21));
                }
            }
            int varietyCode = 2;
            switch (variety) {
                case "mixed": {
                    varietyCode = 3;
                    break;
                }
                case "empty": {
                    varietyCode = 0;
                    break;
                }
                case "element-only": {
                    varietyCode = 2;
                    break;
                }
                case "simple": {
                    varietyCode = 1;
                }
            }
            this.complexType.setVariety(varietyCode);
            this.complexType.setAbstract(isAbstract);
            this.complexType.setDerivationMethodName(derivation);
            if (simpleType != null) {
                if (simpleType.startsWith("#")) {
                    int typefp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", simpleType.substring(1));
                    this.complexType.setSimpleContentTypeReference(new TypeReference(typefp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.complexType, simpleType, 22));
                }
            }
            if (name == null) {
                SchemaModelLoader.this.schema.addAnonymousType(this.complexType);
            } else {
                SchemaModelLoader.this.schema.addType(this.complexType);
            }
            String blockAtt = attributes.getValue("", "block");
            int blockSet = SchemaModelLoader.this.parseFinalOrBlock("block", blockAtt, 3);
            this.complexType.setBlock(blockSet);
            String finalAtt = attributes.getValue("", "final");
            int finalSet = SchemaModelLoader.this.parseFinalOrBlock("final", finalAtt, 3);
            this.complexType.setFinalProhibitions(finalSet);
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class AttributeHandler
    implements SCMNodeHandler {
        private AttributeDecl attributeDecl;

        private AttributeHandler() {
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            if (localName.equals("fixed") || localName.equals("default")) {
                return new ValueConstraintHandler(this.attributeDecl, localName);
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            StructuredQName attributeName = null;
            if (name != null) {
                attributeName = new StructuredQName("", namespace, name);
            }
            boolean isGlobal = SchemaModelLoader.toBoolean(attributes.getValue("", "global"));
            boolean isInheritable = SchemaModelLoader.toBoolean(attributes.getValue("", "inheritable"));
            String type = attributes.getValue("", "type");
            String defaultValue = attributes.getValue("", "default");
            this.attributeDecl = new AttributeDecl(SchemaModelLoader.this.config, isGlobal);
            SchemaModelLoader.this.components.put(id, this.attributeDecl);
            this.attributeDecl.setAttributeName(attributeName, SchemaModelLoader.this.config.getNamePool().allocateFingerprint(namespace, name));
            this.attributeDecl.setInheritable(isInheritable);
            if (defaultValue != null) {
                ValueConstraint vc = new ValueConstraint(ValueConstraint.Variety.DEFAULT, defaultValue);
                this.attributeDecl.setValueConstraint(vc);
            }
            if (type != null) {
                if (type.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                    this.attributeDecl.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.attributeDecl, type, 11));
                }
            }
            if (isGlobal) {
                SchemaModelLoader.this.schema.addAttributeDecl(this.attributeDecl);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    public class SelectorHandler
    implements SCMNodeHandler {
        private final IdentityConstraint identityConstraint;

        public SelectorHandler(IdentityConstraint identityConstraint) {
            this.identityConstraint = identityConstraint;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            Pattern selector;
            String xpath = attributes.getValue("", "xpath");
            boolean isField = localName.equals("field");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            IndependentContext env = new IndependentContext(SchemaModelLoader.this.config);
            env.setNamespaceResolver(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver));
            env.setDefaultElementNamespace(defaultNamespace);
            try {
                selector = new SelectionParser().parseSelector(xpath, env, isField);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            if (isField) {
                IdentityField idf = new IdentityField(xpath);
                idf.setSelection(selector);
                idf.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver));
                idf.setXPathDefaultNamespace(defaultNamespace);
                this.identityConstraint.addField(idf);
            } else {
                IdentitySelector ids = new IdentitySelector(xpath);
                ids.setSelection(selector);
                ids.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver));
                ids.setXPathDefaultNamespace(defaultNamespace);
                this.identityConstraint.setSelector(ids);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    public class IdentityConstraintHandler
    implements SCMNodeHandler {
        private IdentityConstraint identityConstraint;

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "selector": {
                    return new SelectorHandler(this.identityConstraint);
                }
                case "field": {
                    return new SelectorHandler(this.identityConstraint);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            IdentityConstraint ic;
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            String key = attributes.getValue("", "key");
            StructuredQName nameCode = new StructuredQName("", namespace, name);
            switch (localName) {
                case "unique": {
                    ic = new Unique();
                    SchemaModelLoader.this.components.put(id, ic);
                    break;
                }
                case "key": {
                    ic = new Key();
                    SchemaModelLoader.this.components.put(id, ic);
                    break;
                }
                case "keyref": {
                    ic = new KeyRef();
                    SchemaModelLoader.this.components.put(id, ic);
                    SchemaModelLoader.this.fixups.add(new Fixup(ic, key, 62));
                    break;
                }
                default: {
                    throw new AssertionError((Object)("unknown IdentityConstraint " + localName));
                }
            }
            ic.setConfiguration(SchemaModelLoader.this.config);
            ic.setConstraintName(nameCode);
            this.identityConstraint = ic;
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class IdentityConstraintReferenceHandler
    implements SCMNodeHandler {
        private final ElementDecl container;
        private IdentityConstraintReference constraintRef;

        public IdentityConstraintReferenceHandler(ElementDecl container) {
            this.container = container;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String ref = attributes.getValue("", "ref");
            this.constraintRef = new IdentityConstraintReference();
            this.container.addIdentityConstraint(this.constraintRef);
            SchemaModelLoader.this.fixups.add(new Fixup(this.constraintRef, ref, 63));
        }

        @Override
        public void processElementEnd() {
        }
    }

    public class AlternativeTypeHandler
    implements SCMNodeHandler {
        private final ElementDecl elementDecl;

        public AlternativeTypeHandler(ElementDecl decl) {
            this.elementDecl = decl;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            XPathExpression condition;
            String xpathText = attributes.getValue("", "test");
            String xmlBase = attributes.getValue("http://www.w3.org/XML/1998/namespace", "base");
            String defaultNamespace = attributes.getValue("", "defaultNamespace");
            String type = attributes.getValue("", "type");
            XPathEvaluator evaluator = new XPathEvaluator(SchemaModelLoader.this.config);
            IndependentContext env = (IndependentContext)evaluator.getStaticContext();
            env.setNamespaceResolver(SchemaModelLoader.this.namespaceResolver);
            env.setDefaultElementNamespace(defaultNamespace);
            env.setBaseURI(xmlBase);
            try {
                condition = evaluator.createExpression(xpathText);
            }
            catch (XPathException err) {
                throw new SchemaException(err);
            }
            TypeAlternative alt = new TypeAlternative(SchemaModelLoader.this.config, condition, xpathText);
            alt.setBaseURI(xmlBase);
            alt.setDefaultElementNamespace(defaultNamespace);
            alt.setNamespaceContext(new SavedNamespaceContext(SchemaModelLoader.this.namespaceResolver));
            alt.setParameters(new HashMap<StructuredQName, XPathVariable>());
            if (type.startsWith("#")) {
                int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                alt.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
            } else {
                SchemaModelLoader.this.fixups.add(new Fixup(alt, type, 12));
            }
            this.elementDecl.addTypeAlternative(alt);
        }

        @Override
        public void processElementEnd() {
        }
    }

    public class SubstitutionGroupAffiliationHandler
    implements SCMNodeHandler {
        private final ElementDecl elementDecl;

        public SubstitutionGroupAffiliationHandler(ElementDecl decl) {
            this.elementDecl = decl;
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) {
            String head = attributes.getValue("", "ref");
            if (head != null) {
                SchemaModelLoader.this.fixups.add(new Fixup(this.elementDecl, head, 2));
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class ElementHandler
    implements SCMNodeHandler {
        private ElementDecl elementDecl;

        private ElementHandler() {
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "identityConstraint": {
                    return new IdentityConstraintReferenceHandler(this.elementDecl);
                }
                case "substitutionGroupAffiliation": {
                    return new SubstitutionGroupAffiliationHandler(this.elementDecl);
                }
                case "alternativeType": {
                    return new AlternativeTypeHandler(this.elementDecl);
                }
                case "fixed": 
                case "default": {
                    return new ValueConstraintHandler(this.elementDecl, localName);
                }
            }
            return null;
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String id = attributes.getValue("", "id");
            String name = attributes.getValue("", "name");
            String namespace = attributes.getValue("", "targetNamespace");
            boolean isGlobal = SchemaModelLoader.toBoolean(attributes.getValue("", "global"));
            boolean isNillable = SchemaModelLoader.toBoolean(attributes.getValue("", "nillable"));
            boolean isAbstract = SchemaModelLoader.toBoolean(attributes.getValue("", "abstract"));
            String type = attributes.getValue("", "type");
            String finalAtt = attributes.getValue("", "final");
            String defaultValue = attributes.getValue("", "default");
            int finalSet = SchemaModelLoader.this.parseFinalOrBlock("final", finalAtt, 19);
            String blockAtt = attributes.getValue("", "block");
            int blockSet = SchemaModelLoader.this.parseFinalOrBlock("block", blockAtt, 19);
            this.elementDecl = new ElementDecl(SchemaModelLoader.this.config, isGlobal, null);
            this.elementDecl.setGeneratedId(id);
            SchemaModelLoader.this.components.put(id, this.elementDecl);
            this.elementDecl.setElementName(new StructuredQName("", namespace, name));
            this.elementDecl.setAbstract(isAbstract);
            this.elementDecl.setNillable(isNillable);
            this.elementDecl.setBlock(blockSet);
            this.elementDecl.setFinalProhibitions(finalSet);
            if (defaultValue != null) {
                ValueConstraint vc = new ValueConstraint(ValueConstraint.Variety.DEFAULT, defaultValue);
                this.elementDecl.setValueConstraint(vc);
            }
            if (type != null) {
                if (type.startsWith("#")) {
                    int fp = SchemaModelLoader.this.config.getNamePool().getFingerprint("http://www.w3.org/2001/XMLSchema", type.substring(1));
                    this.elementDecl.setTypeReference(new TypeReference(fp, SchemaModelLoader.this.config, null));
                } else {
                    SchemaModelLoader.this.fixups.add(new Fixup(this.elementDecl, type, 1));
                }
            }
            if (isGlobal) {
                SchemaModelLoader.this.schema.addElementDecl(this.elementDecl);
            }
        }

        @Override
        public void processElementEnd() {
        }
    }

    private class SchemaHandler
    implements SCMNodeHandler {
        private SchemaHandler() {
        }

        @Override
        public void processElementStart(String localName, AttributeCollection attributes) throws SchemaException {
            String xsdVersion = attributes.getValue("", "xsdVersion");
            if (xsdVersion != null && xsdVersion.compareTo(SchemaModelLoader.this.config.getConfigurationProperty(Feature.XSD_VERSION)) > 0) {
                throw new SchemaException("Imported schema component model requires XSD version " + xsdVersion);
            }
            SchemaModelLoader.this.dmk = attributes.getValue("", "dmk");
            if (SchemaModelLoader.this.dmk != null) {
                SchemaModelLoader.this.schema.setLocalLicenseId(SchemaModelLoader.this.config.registerLocalLicense(SchemaModelLoader.this.dmk));
            }
        }

        @Override
        public SCMNodeHandler handleChildElement(String localName) {
            switch (localName) {
                case "element": {
                    return new ElementHandler();
                }
                case "attribute": {
                    return new AttributeHandler();
                }
                case "complexType": {
                    return new ComplexTypeHandler();
                }
                case "simpleType": {
                    return new SimpleTypeHandler();
                }
                case "attributeGroup": {
                    return new AttributeGroupHandler();
                }
                case "modelGroupDefinition": {
                    return new ModelGroupDefinitionHandler();
                }
                case "notation": {
                    return new NotationHandler();
                }
                case "wildcard": {
                    return new WildcardHandler();
                }
                case "unique": {
                    return new IdentityConstraintHandler();
                }
                case "key": {
                    return new IdentityConstraintHandler();
                }
                case "keyref": {
                    return new IdentityConstraintHandler();
                }
            }
            return null;
        }

        @Override
        public void processElementEnd() {
        }
    }

    private static interface SCMNodeHandler {
        public void processElementStart(String var1, AttributeCollection var2) throws SchemaException;

        public SCMNodeHandler handleChildElement(String var1);

        public void processElementEnd();
    }
}

