/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.PreparedSchema;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SingleNamespaceSchema;
import com.saxonica.ee.schema.sdoc.AnnotationParent;
import com.saxonica.ee.schema.sdoc.SchemaDocument;
import com.saxonica.ee.schema.sdoc.SchemaReader;
import com.saxonica.ee.schema.sdoc.XMLNamespaceSchema;
import com.saxonica.ee.schema.sdoc.XSDSchema;
import com.saxonica.ee.schema.sdoc.XSINamespaceSchema;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.xml.transform.Source;
import javax.xml.transform.sax.SAXSource;
import net.sf.saxon.event.PipelineConfiguration;
import net.sf.saxon.functions.ResolveURI;
import net.sf.saxon.lib.Feature;
import net.sf.saxon.lib.SchemaURIResolver;
import net.sf.saxon.lib.StandardEntityResolver;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaException;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XSDImport
extends AnnotationParent {
    private PreparedSchema importedSchema;

    @Override
    public void prepareAttributes() throws SchemaException {
        int errors;
        SchemaDocument importee;
        String message;
        int status;
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "namespace", "schemaLocation"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String schemaLocation = atts.getValue("", "schemaLocation");
        String namespace = atts.getValue("", "namespace");
        if (schemaLocation == null && namespace == null) {
            return;
        }
        XSDSchema thisSchemaDocument = this.getXSDSchema();
        EnterpriseConfiguration config = (EnterpriseConfiguration)this.getConfiguration();
        SchemaCompiler manager = thisSchemaDocument.getSchemaCompiler();
        if (namespace == null) {
            namespace = "";
        }
        String documentBase = this.getBaseURI();
        Source source = null;
        if (schemaLocation != null) {
            try {
                source = SchemaReader.getSource(documentBase, schemaLocation, manager.getPipelineConfiguration(), namespace);
            }
            catch (SchemaException e) {
                this.error("xs:import failed: " + e.getMessage());
                return;
            }
        }
        if (namespace.equals(thisSchemaDocument.getTargetNamespace())) {
            this.error("The namespace attribute in the xs:import element cannot be the same as the targetNamespace of the containing schema");
            return;
        }
        if (source != null) {
            if (manager.isBeingRead(source.getSystemId())) {
                return;
            }
            XSDSchema existing = manager.getExistingSchemaDocument(source.getSystemId(), namespace);
            if (existing != null) {
                this.importedSchema = existing.getSchema();
                return;
            }
        } else {
            try {
                String location = ResolveURI.makeAbsolute(schemaLocation, documentBase).toString();
                XSDSchema existing = manager.getExistingSchemaDocument(location, namespace);
                if (existing != null) {
                    this.importedSchema = existing.getSchema();
                    return;
                }
            }
            catch (URISyntaxException location) {
                // empty catch block
            }
        }
        if ((status = config.getNamespaceStatus(namespace)) == 2) {
            if (source == null || !manager.isBeingRead(source.getSystemId()) && !config.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS)) {
                if (schemaLocation != null) {
                    message = "The schema document at " + schemaLocation + " is not being read because schema components for this namespace are already being processed";
                    if (!namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                        message = message + ". To force the schema document to be read, set --multipleSchemaImports:on";
                    }
                    this.warning(message);
                }
                return;
            }
        } else {
            if (status == 4) {
                return;
            }
            if (status == 3 && !config.getBooleanProperty(Feature.MULTIPLE_SCHEMA_IMPORTS)) {
                if (schemaLocation != null) {
                    message = "The schema document at " + schemaLocation + " is not being read because schema components for this namespace are already available";
                    if (!namespace.equals("http://www.w3.org/XML/1998/namespace")) {
                        message = message + ". To force the schema document to be read, set --multipleSchemaImports:on";
                    }
                    this.warning(message);
                }
                return;
            }
        }
        if (namespace.equals("http://www.w3.org/XML/1998/namespace") && (schemaLocation == null || schemaLocation.equals("http://www.w3.org/2001/xml.xsd") || schemaLocation.equals("http://www.w3.org/2001/03/xml.xsd"))) {
            if (status != 3) {
                this.importedSchema = XMLNamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
            }
            return;
        }
        if (schemaLocation == null) {
            if (namespace.equals("http://www.w3.org/2001/XMLSchema-instance")) {
                this.importedSchema = XSINamespaceSchema.buildSchema(config);
                config.addSchema(this.importedSchema);
                return;
            }
            if (namespace.equals("http://www.w3.org/2005/xpath-functions")) {
                if (!config.isSchemaAvailable("http://www.w3.org/2005/xpath-functions")) {
                    try {
                        InputSource is = StandardEntityResolver.getInstance().resolveEntity(null, "http://www.w3.org/2005/xpath-functions.xsd");
                        if (config.isTiming()) {
                            config.getLogger().info("Loading schema from resources for: http://www.w3.org/2005/xpath-functions");
                        }
                        source = new SAXSource(is);
                    }
                    catch (SAXException e) {
                        throw new SchemaException(e);
                    }
                    catch (IOException e) {
                        throw new SchemaException(e);
                    }
                }
            } else {
                PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
                SchemaURIResolver resolver = pipe.getSchemaURIResolver();
                if (resolver != null) {
                    try {
                        Source[] sources = resolver.resolve(namespace, this.getBaseURI(), new String[0]);
                        if (sources == null || sources.length == 0) {
                            this.warning("Cannot locate a schema document for namespace " + namespace);
                            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), namespace);
                            return;
                        }
                        if (sources.length > 1) {
                            this.error("SchemaURIResolver returned more than one schema document");
                        } else {
                            source = sources[0];
                        }
                    }
                    catch (XPathException err) {
                        throw new SchemaException(err);
                    }
                }
            }
        }
        try {
            PipelineConfiguration pipe = this.getSchemaNodeFactory().getPipelineConfiguration();
            SchemaCompiler compiler = this.getSchemaNodeFactory().getSchemaCompiler();
            importee = SchemaReader.read(source, compiler, pipe, null);
            XSDSchema s = importee.getXSDSchema();
            errors = importee.getXSDSchema().getErrorCount();
            this.importedSchema = s.getSchema();
        }
        catch (SchemaException e) {
            Throwable cause = e.getException();
            if (cause instanceof IOException) {
                this.warning("Imported schema document " + schemaLocation + " cannot be located: " + cause.getClass().getName() + " (" + cause.getMessage() + ")");
            } else {
                this.error("Failed to process imported schema document: " + e.getMessage());
            }
            this.importedSchema = new SingleNamespaceSchema((EnterpriseConfiguration)this.getConfiguration(), namespace);
            boolean errors2 = false;
            return;
        }
        boolean valid = errors == 0;
        config.removeSchema(namespace);
        if (!valid) {
            throw new SchemaException("Imported schema is invalid");
        }
        String importedNamespace = importee.getTargetNamespace();
        if (thisSchemaDocument.getTargetNamespace().equals(importedNamespace)) {
            this.error("The targetNamespace of the imported schema must not be the same as the targetNamespace of the importing schema");
            return;
        }
        if (!namespace.equals(importedNamespace)) {
            this.error("The namespace attribute in xs:import differs from the targetNamespace of the imported schema");
            return;
        }
        config.addSchema(this.importedSchema);
    }

    public PreparedSchema getImportedSchema() {
        return this.importedSchema;
    }

    public String getTargetNamespace() {
        String uri = this.getAttributeList().getValue("", "namespace");
        if (uri == null) {
            return "";
        }
        return uri;
    }
}

