/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import java.util.StringTokenizer;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.tree.iter.AxisIterator;
import net.sf.saxon.tree.linked.NodeImpl;
import net.sf.saxon.type.SchemaException;

public class XSDUnion
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition;
    private int numberOfMemberTypes = 0;

    @Override
    public void prepareAttributes() throws SchemaException {
        this.typeDefinition = this.getContainingSimpleType();
        AttributeCollection atts = this.getAttributeList();
        String[] allowed = new String[]{"id", "memberTypes"};
        this.allowAttributes(atts, allowed);
        this.processId();
        this.typeDefinition.setDerivationMethodName("union");
        String memberTypes = atts.getValue("", "memberTypes");
        this.processMemberTypes(memberTypes);
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        boolean foundAnnotation = false;
        boolean foundSimpleType = false;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            int fp = child.getFingerprint();
            if (fp == 578) {
                if (foundAnnotation) {
                    this.duplicateElement("annotation");
                }
                if (foundSimpleType) {
                    this.mustBeFirstElement("annotation");
                }
                foundAnnotation = true;
                continue;
            }
            if (fp == 621) {
                foundSimpleType = true;
                ++this.numberOfMemberTypes;
                continue;
            }
            this.illegalElement(child);
        }
        if (this.numberOfMemberTypes == 0) {
            String err = "A union type must have at least one member type";
            this.error(err);
        }
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        NodeImpl child;
        AxisIterator iter = this.iterateAxis((byte)3);
        while ((child = (NodeImpl)iter.next()) != null) {
            if (child.getFingerprint() != 621) continue;
            SimpleTypeDefinition memberType = ((XSDSimpleType)child).getSimpleTypeDefinition();
            int fp = ((XSDSimpleType)child).getSimpleTypeDefinition().getFingerprint();
            TypeReference ref = new TypeReference(fp, compiler.getConfiguration(), (SchemaElement)child);
            ref.setTarget(memberType);
            this.typeDefinition.addMemberType(ref);
        }
    }

    private void processMemberTypes(String memberTypes) throws SchemaException {
        if (memberTypes == null || memberTypes.isEmpty()) {
            return;
        }
        StringTokenizer st = new StringTokenizer(memberTypes, " \t\n\r", false);
        while (st.hasMoreTokens()) {
            int fp;
            String typeName = st.nextToken();
            try {
                fp = this.getFingerprint(typeName, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            if (fp == 634 || fp == 633) {
                if (this.getConfiguration().getXsdVersion() == 10) {
                    this.warning("Type " + typeName + " is recognized by Saxon but is not interoperable");
                }
            } else if (fp == 573 || fp == 632 || fp == 631 || fp == 630) {
                if (this.getConfiguration().getXsdVersion() == 10) {
                    this.warning("In XSD 1.1, type " + typeName + " cannot be used as a member type of a union");
                } else {
                    this.error("In XSD 1.1, type " + typeName + " cannot be used as a member type of a union");
                }
            }
            TypeReference ref = new TypeReference(fp, this.typeDefinition.getConfiguration(), this);
            this.typeDefinition.addMemberType(ref);
            ++this.numberOfMemberTypes;
        }
    }
}

