/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.axiom;

import java.util.HashMap;
import java.util.Iterator;
import net.sf.saxon.Configuration;
import net.sf.saxon.om.GenericTreeInfo;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.option.axiom.AxiomDocumentNodeWrapper;
import net.sf.saxon.option.axiom.AxiomElementNodeWrapper;
import net.sf.saxon.option.axiom.AxiomLeafNodeWrapper;
import net.sf.saxon.option.axiom.AxiomParentNodeWrapper;
import net.sf.saxon.tree.iter.AxisIterator;
import org.apache.axiom.om.OMAttribute;
import org.apache.axiom.om.OMDocument;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;

public class AxiomDocument
extends GenericTreeInfo {
    private HashMap<String, NodeInfo> idIndex;

    public AxiomDocument(OMDocument root, String baseURI, Configuration config) {
        super(config);
        this.setSystemId(baseURI);
    }

    public NodeInfo wrap(OMNode node) {
        return AxiomDocument.makeWrapper(node, this, null, -1);
    }

    protected static NodeInfo makeWrapper(OMNode node, AxiomDocument docWrapper, AxiomParentNodeWrapper parent, int index) {
        if (node instanceof OMDocument) {
            return docWrapper.getRootNode();
        }
        if (node instanceof OMElement) {
            return new AxiomElementNodeWrapper((OMElement)node, docWrapper, parent, index);
        }
        return new AxiomLeafNodeWrapper(node, docWrapper, parent, index);
    }

    @Override
    public NodeInfo selectID(String id, boolean getParent) {
        if (this.idIndex == null) {
            this.idIndex = new HashMap(50);
            AxiomDocumentNodeWrapper doc = (AxiomDocumentNodeWrapper)this.getRootNode();
            OMDocument omDoc = (OMDocument)doc.node;
            this.buildIDIndex(omDoc.getOMDocumentElement());
        }
        return this.idIndex.get(id);
    }

    private void buildIDIndex(OMElement elem) {
        Iterator kids = elem.getChildElements();
        while (kids.hasNext()) {
            this.buildIDIndex((OMElement)kids.next());
        }
        Iterator atts = elem.getAllAttributes();
        while (atts.hasNext()) {
            String val;
            OMAttribute att = (OMAttribute)atts.next();
            if (!"ID".equals(att.getAttributeType()) && (!"id".equals(att.getLocalName()) || !"http://www.w3.org/XML/1998/namespace".equals(att.getNamespaceURI())) || this.idIndex.get(val = att.getAttributeValue()) != null) continue;
            this.idIndex.put(val, this.wrap((OMNode)elem));
        }
    }

    protected static class PrecedingSiblingIterator
    implements AxisIterator {
        private OMNode start;
        private OMNode currentOMNode;
        private AxiomParentNodeWrapper commonParent;
        private AxiomDocument docWrapper;

        public PrecedingSiblingIterator(OMNode start, AxiomParentNodeWrapper commonParent, AxiomDocument docWrapper) {
            this.start = start;
            this.currentOMNode = start;
            this.commonParent = commonParent;
            this.docWrapper = docWrapper;
        }

        @Override
        public NodeInfo next() {
            if (this.currentOMNode == null) {
                return null;
            }
            this.currentOMNode = this.currentOMNode.getPreviousOMSibling();
            if (this.currentOMNode == null) {
                return null;
            }
            return AxiomDocument.makeWrapper(this.currentOMNode, this.docWrapper, this.commonParent, -1);
        }
    }

    protected static class FollowingSiblingIterator
    implements AxisIterator {
        private OMNode start;
        private OMNode currentOMNode;
        private AxiomParentNodeWrapper commonParent;
        private AxiomDocument docWrapper;

        public FollowingSiblingIterator(OMNode start, AxiomParentNodeWrapper commonParent, AxiomDocument docWrapper) {
            this.start = start;
            this.currentOMNode = start;
            this.commonParent = commonParent;
            this.docWrapper = docWrapper;
        }

        @Override
        public NodeInfo next() {
            if (this.currentOMNode == null) {
                return null;
            }
            this.currentOMNode = this.currentOMNode.getNextOMSibling();
            if (this.currentOMNode == null) {
                return null;
            }
            return AxiomDocument.makeWrapper(this.currentOMNode, this.docWrapper, this.commonParent, -1);
        }
    }
}

