/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.cmd;

import java.util.LinkedList;
import marmot.core.Sequence;
import marmot.core.Token;
import marmot.morph.MorphModel;
import marmot.morph.MorphOptions;
import marmot.morph.Word;
import marmot.morph.io.SentenceReader;

public class Stats {
    public static void main(String[] args2) {
        boolean has_test_file;
        MorphOptions options = new MorphOptions();
        options.setPropertiesFromStrings(args2);
        int train_tokens = 0;
        LinkedList<Sequence> train_sentences = new LinkedList<Sequence>();
        for (Sequence sequence : new SentenceReader(options.getTrainFile())) {
            train_sentences.add(sequence);
            train_tokens += sequence.size();
        }
        MorphModel model = new MorphModel();
        model.init(options, train_sentences);
        System.out.println("Train sentences: " + train_sentences.size());
        System.out.println("Train tokens: " + train_tokens);
        System.out.println("Pos tags: " + (model.getTagTables().get(0).size() - 1));
        System.out.println("Morph tags: " + (model.getTagTables().get(1).size() - 1));
        boolean bl = has_test_file = options.getTestFile().length() > 0;
        if (has_test_file) {
            int test_tokens = 0;
            int oov_test_tokens = 0;
            LinkedList<Sequence> test_sentences = new LinkedList<Sequence>();
            for (Sequence sequence : new SentenceReader(options.getTestFile())) {
                test_sentences.add(sequence);
                for (Token token2 : sequence) {
                    Word word = (Word)token2;
                    model.addIndexes(word, false);
                    if (word.getWordFormIndex() >= 0) continue;
                    ++oov_test_tokens;
                }
                test_tokens += sequence.size();
            }
            System.out.println("OOV rate: " + (double)oov_test_tokens * 100.0 / (double)test_tokens);
        }
    }
}

