/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToPushCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.Configuration;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.AttributeCreator;
import net.sf.saxon.expr.instruct.DummyNamespaceResolver;
import net.sf.saxon.expr.instruct.FixedAttribute;
import net.sf.saxon.expr.instruct.ValidatingInstruction;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.Orphan;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Whitespace;

public class FixedAttributeCompiler
extends ToPushCompiler {
    @Override
    public void compileToPush(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        FixedAttribute instr = (FixedAttribute)expression;
        Expression select = instr.getSelect();
        FixedAttributeCompiler.visitLineNumber(compiler, ga, expression);
        NodeName nodeName = instr.evaluateNodeName(null);
        int opt = instr.getOptions();
        Location locationId = instr.getLocation();
        compiler.generateGetReceiver();
        FixedAttributeCompiler.allocateStatic(compiler, nodeName);
        SimpleType schemaType = instr.getSchemaType();
        if (schemaType != null) {
            FixedAttributeCompiler.allocateStatic(compiler, instr.getSchemaType());
        } else {
            ga.getStaticField(BuiltInAtomicType.class, "UNTYPED_ATOMIC", BuiltInAtomicType.class);
        }
        compiler.compileToPrimitive(select, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        FixedAttributeCompiler.generateAttributeValidationPushCode(compiler, instr, nodeName, -1);
        if (nodeName.getFingerprint() == 388) {
            ga.invokeStaticMethod(Whitespace.class, "collapseWhitespace", CharSequence.class);
        }
        FixedAttributeCompiler.allocateStatic(compiler, locationId);
        ga.push(opt);
        ga.invokeInstanceMethod(Receiver.class, "attribute", NodeName.class, SimpleType.class, CharSequence.class, Location.class, Integer.TYPE);
    }

    protected static void generateAttributeValidationPushCode(CompilerService compiler, ValidatingInstruction instr, NodeName nodeName, int nodeNameVar) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        if (instr.getSchemaType() != null) {
            ga.dup();
            FixedAttributeCompiler.allocateStatic(compiler, instr.getSchemaType());
            ga.swap();
            FixedAttributeCompiler.allocateStatic(compiler, DummyNamespaceResolver.getInstance());
            FixedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules());
            ga.invokeInstanceMethod(SimpleType.class, "validateContent", CharSequence.class, NamespaceResolver.class, ConversionRules.class);
            LabelInfo valFail = methodInfo.newLabel("valFail");
            LabelInfo valSuccess = methodInfo.newLabel("valSuccess");
            ga.ifNonNull(valFail.label());
            ga.goTo(valSuccess.label());
            methodInfo.placeLabel(valFail);
            compiler.generateDynamicError("Invalid attribute", "XTTE1540", ((Expression)((Object)instr)).getLocation(), true);
            methodInfo.placeLabel(valSuccess);
            ga.showMessage(compiler, "Attribute validation succeeded");
        } else if (instr.getValidationAction() == 1 || instr.getValidationAction() == 2) {
            ga.dup();
            FixedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration());
            ga.swap();
            if (nodeName == null) {
                ga.loadLocal(nodeNameVar);
            } else {
                FixedAttributeCompiler.allocateStatic(compiler, nodeName);
            }
            ga.invokeInstanceMethod(NodeName.class, "getStructuredQName", new Class[0]);
            ga.swap();
            ga.push(instr.getValidationAction());
            LabelInfo L0 = methodInfo.newLabel("L0");
            LabelInfo L1 = methodInfo.newLabel("L1");
            LabelInfo L2 = methodInfo.newLabel("L2");
            ga.visitTryCatchBlock(L0, L1, L2, "net/sf/saxon/type/ValidationException");
            methodInfo.placeLabel(L0);
            ga.invokeInstanceMethod(Configuration.class, "validateAttribute", StructuredQName.class, CharSequence.class, Integer.TYPE);
            methodInfo.placeLabel(L1);
            ga.dupX2();
            ga.pop();
            ga.swap();
            ga.pop();
            LabelInfo end = methodInfo.newLabel("end");
            ga.goTo(end);
            methodInfo.placeLabel(L2);
            ga.invokeStaticMethod(XPathException.class, "makeXPathException", Exception.class);
            ga.dup();
            ga.push(instr.getValidationAction() == 1 ? "XTTE1510" : "XTTE1515");
            ga.invokeInstanceMethod(XPathException.class, "maybeSetErrorCode", String.class);
            ga.dup();
            FixedAttributeCompiler.allocateStatic(compiler, ((Expression)((Object)instr)).getLocation());
            ga.invokeInstanceMethod(XPathException.class, "maybeSetLocation", Location.class);
            ga.dup();
            ga.push(true);
            ga.invokeInstanceMethod(XPathException.class, "setIsTypeError", Boolean.TYPE);
            ga.throwException();
            methodInfo.placeLabel(end);
        }
    }

    private void pushNodeName(CompilerService compiler, Expression expression) throws CannotCompileException {
        FixedAttributeCompiler.allocateStatic(compiler, ((FixedAttribute)expression).getAttributeName());
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getConfiguration", new Class[0]);
        int configVar = methodInfo.allocateLocal(Configuration.class);
        ga.storeLocal(configVar);
        FixedAttribute instr = (FixedAttribute)expression;
        Expression expr = instr.getSelect();
        ga.newInstance(Orphan.class);
        ga.dup();
        FixedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration());
        ga.invokeConstructor(Orphan.class, Configuration.class);
        ga.dup();
        ga.push(2);
        ga.invokeInstanceMethod(Orphan.class, "setNodeKind", Short.TYPE);
        ga.dup();
        this.pushNodeName(compiler, expression);
        ga.invokeInstanceMethod(Orphan.class, "setNodeName", NodeName.class);
        ga.dup();
        compiler.compileToPrimitive(expr, CharSequence.class, OnEmpty.RETURN_EMPTY_STRING);
        ga.invokeInstanceMethod(Orphan.class, "setStringValue", CharSequence.class);
        FixedAttributeCompiler.validateOrphanAttribute(compiler, instr);
    }

    static void validateOrphanAttribute(CompilerService compiler, AttributeCreator instr) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        if (instr.getSchemaType() != null) {
            if (instr.getSchemaType().isNamespaceSensitive()) {
                compiler.generateDynamicError("Cannot validate a parentless attribute whose content is namespace-sensitive", "XTTE1545", instr.getLocation(), true);
            } else {
                ga.dup();
                ga.invokeInstanceMethod(NodeInfo.class, "getStringValueCS", new Class[0]);
                FixedAttributeCompiler.allocateStatic(compiler, instr.getSchemaType());
                ga.swap();
                FixedAttributeCompiler.allocateStatic(compiler, DummyNamespaceResolver.getInstance());
                FixedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration().getConversionRules());
                ga.invokeInstanceMethod(SimpleType.class, "validateContent", CharSequence.class, NamespaceResolver.class, ConversionRules.class);
                LabelInfo valFail = methodInfo.newLabel("valFail");
                LabelInfo valSuccess = methodInfo.newLabel("valSuccess");
                ga.ifNonNull(valFail.label());
                ga.goTo(valSuccess.label());
                methodInfo.placeLabel(valFail);
                compiler.generateDynamicError("Invalid attribute", "XTTE1540", instr.getLocation(), true);
                methodInfo.placeLabel(valSuccess);
                ga.showMessage(compiler, "Attribute validation succeeded");
                ga.dup();
                FixedAttributeCompiler.allocateStatic(compiler, instr.getSchemaType());
                ga.invokeInstanceMethod(Orphan.class, "setTypeAnnotation", SchemaType.class);
            }
        } else if (instr.getValidationAction() == 1 || instr.getValidationAction() == 2) {
            ga.dup();
            ga.dup();
            FixedAttributeCompiler.allocateStatic(compiler, compiler.getConfiguration());
            ga.swap();
            ga.dup();
            ga.invokeInstanceMethod(NodeInfo.class, "getNameCode", new Class[0]);
            ga.swap();
            ga.invokeInstanceMethod(NodeInfo.class, "getStringValueCS", new Class[0]);
            ga.push(instr.getValidationAction());
            ga.invokeInstanceMethod(Configuration.class, "validateAttribute", Integer.TYPE, CharSequence.class, Integer.TYPE);
            ga.invokeInstanceMethod(Orphan.class, "setTypeAnnotation", SchemaType.class);
        } else {
            ga.dup();
            if (instr.getSchemaType() != null) {
                FixedAttributeCompiler.allocateStatic(compiler, instr.getSchemaType());
            } else {
                ga.pushNull();
            }
            ga.invokeInstanceMethod(Orphan.class, "setTypeAnnotation", SchemaType.class);
        }
    }
}

