/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.xtupdate;

import com.saxonica.ee.update.ReplaceNodeExpression;
import com.saxonica.ee.xtupdate.SaxonUpdate;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;

public class SaxonReplace
extends StyleElement {
    private Expression select;

    @Override
    public boolean isInstruction() {
        return true;
    }

    @Override
    public boolean mayContainSequenceConstructor() {
        return true;
    }

    @Override
    public void prepareAttributes() throws XPathException {
        String selectAtt = null;
        Object contentAtt = null;
        AttributeCollection atts = this.getAttributeList();
        for (int a = 0; a < atts.getLength(); ++a) {
            String f = atts.getQName(a);
            if (f.equals("select")) {
                selectAtt = atts.getValue(a);
                this.select = this.makeExpression(selectAtt, a);
                continue;
            }
            this.checkUnknownAttribute(atts.getNodeName(a));
        }
        if (selectAtt == null) {
            this.select = new ContextItemExpression();
            this.select.setLocation(this.allocateLocation());
        }
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.getConfiguration().checkLicensedFeature(2, "saxon:replace", this.getPackageData().getLocalLicenseId());
        this.select = this.typeCheck("select", this.select);
        SaxonUpdate.checkContainment(this);
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        Expression content = this.compileSequenceConstructor(exec, decl, false);
        return new ReplaceNodeExpression(this.select, content, 3);
    }
}

