/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.XPathContextMinor;
import net.sf.saxon.om.FocusIterator;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class BufferingFilterExpressionFeed
extends ItemFeed {
    Expression filter;
    XPathContext localContext;
    private final List<Item> inputValue = new ArrayList<Item>(4);

    public BufferingFilterExpressionFeed(Expression expr, ItemFeed result, XPathContext context) {
        super(expr, result, context);
        this.filter = ((FilterExpression)expr).getActionExpression();
        this.localContext = context;
    }

    @Override
    public void append(Item item) throws XPathException {
        this.inputValue.add(item);
    }

    @Override
    public void close() throws XPathException {
        GroundedValue extent = SequenceExtent.makeSequenceExtent(this.inputValue);
        XPathContextMinor c2 = this.localContext.newMinorContext();
        FocusIterator iter = c2.trackFocus(extent.iterate());
        FilterIterator filterIter = new FilterIterator(iter, this.filter, c2);
        Outputter out = this.getNextOutputter();
        BufferingFilterExpressionFeed.processItems(filterIter, out);
        out.close();
    }
}

