/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.DeleteAction;
import com.saxonica.ee.update.PendingUpdateListImpl;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceType;

public class DeleteExpression
extends BasicUpdatingExpression {
    private final Operand operand;

    public DeleteExpression(Expression target) {
        this.operand = new Operand(this, target, OperandRole.INSPECT);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.operand);
    }

    public Expression getTargetExp() {
        return this.operand.getChildExpression();
    }

    public void setTargetExp(Expression targetExp) {
        this.operand.setChildExpression(targetExp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        Supplier<RoleDiagnostic> roleSupplier = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "delete", 0);
            role0.setErrorCode("XUTY0007");
            return role0;
        };
        this.setTargetExp(visitor.getConfiguration().getTypeChecker(false).staticTypeCheck(this.getTargetExp(), SequenceType.NODE_SEQUENCE, roleSupplier, visitor));
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        DeleteExpression d2 = new DeleteExpression(this.getTargetExp().copy(rebindings));
        ExpressionTool.copyLocationInfo(this, d2);
        return d2;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("delete", this);
        this.getTargetExp().export(out);
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "delete";
    }

    @Override
    public Elaborator getElaborator() {
        return new DeleteExpressionElaborator();
    }

    private static class DeleteExpressionElaborator
    extends UpdateElaborator {
        private DeleteExpressionElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            DeleteExpression expr = (DeleteExpression)this.getExpression();
            PullEvaluator targetPull = expr.getTargetExp().makeElaborator().elaborateForPull();
            return (context, pul) -> {
                try {
                    NodeInfo node;
                    SequenceIterator iter = targetPull.iterate(context);
                    while ((node = (NodeInfo)iter.next()) != null) {
                        if (!node.getTreeInfo().isMutable()) {
                            throw new XPathException("Node to be deleted is not an updatable node", "SXUP0081").withLocation(expr.getLocation());
                        }
                        if (node.getParent() == null) continue;
                        try {
                            DeleteAction action = new DeleteAction(node);
                            action.setOriginator(expr);
                            ((PendingUpdateListImpl)pul).add(action);
                        }
                        catch (XPathException e) {
                            throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                            return;
                        }
                    }
                }
                catch (UncheckedXPathException e) {
                    throw e.getXPathException();
                }
            };
        }
    }
}

