/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.ml;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.ml.model.AbstractModelWriter;
import opennlp.tools.ml.model.ComparablePredicate;
import opennlp.tools.ml.model.Context;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractMLModelWriter
extends AbstractModelWriter {
    private static final Logger logger = LoggerFactory.getLogger(AbstractMLModelWriter.class);
    protected Context[] PARAMS;
    protected String[] OUTCOME_LABELS;
    protected String[] PRED_LABELS;
    protected int numOutcomes;

    protected abstract ComparablePredicate[] sortValues();

    protected List<List<ComparablePredicate>> computeOutcomePatterns(ComparablePredicate[] sorted2) {
        ComparablePredicate cp = sorted2[0];
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
        for (ComparablePredicate predicate : sorted2) {
            if (cp.compareTo(predicate) == 0) {
                newGroup.add(predicate);
                continue;
            }
            cp = predicate;
            outcomePatterns.add(newGroup);
            newGroup = new ArrayList();
            newGroup.add(predicate);
        }
        outcomePatterns.add(newGroup);
        logger.info("{} outcome patterns", (Object)outcomePatterns.size());
        return outcomePatterns;
    }

    protected List<List<ComparablePredicate>> compressOutcomes(ComparablePredicate[] sorted2) {
        ArrayList<List<ComparablePredicate>> outcomePatterns = new ArrayList<List<ComparablePredicate>>();
        if (sorted2.length > 0) {
            ComparablePredicate cp = sorted2[0];
            ArrayList<ComparablePredicate> newGroup = new ArrayList<ComparablePredicate>();
            for (ComparablePredicate comparablePredicate : sorted2) {
                if (cp.compareTo(comparablePredicate) == 0) {
                    newGroup.add(comparablePredicate);
                    continue;
                }
                cp = comparablePredicate;
                outcomePatterns.add(newGroup);
                newGroup = new ArrayList();
                newGroup.add(comparablePredicate);
            }
            outcomePatterns.add(newGroup);
        }
        return outcomePatterns;
    }

    @Override
    public void persist() throws IOException {
        this.writeInt(this.OUTCOME_LABELS.length);
        for (String label : this.OUTCOME_LABELS) {
            this.writeUTF(label);
        }
        ComparablePredicate[] sorted2 = this.sortValues();
        List<List<ComparablePredicate>> compressed = this.computeOutcomePatterns(sorted2);
        this.writeInt(compressed.size());
        for (List<ComparablePredicate> a : compressed) {
            this.writeUTF(a.size() + a.get(0).toString());
        }
        this.writeInt(sorted2.length);
        for (ComparablePredicate s2 : sorted2) {
            this.writeUTF(s2.name);
        }
        for (ComparablePredicate comparablePredicate : sorted2) {
            for (int j = 0; j < comparablePredicate.params.length; ++j) {
                this.writeDouble(comparablePredicate.params[j]);
            }
        }
        this.close();
    }
}

