/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.sentdetect;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import opennlp.tools.dictionary.Dictionary;
import opennlp.tools.ml.EventTrainer;
import opennlp.tools.ml.TrainerFactory;
import opennlp.tools.ml.model.MaxentModel;
import opennlp.tools.sentdetect.EndOfSentenceScanner;
import opennlp.tools.sentdetect.SDContextGenerator;
import opennlp.tools.sentdetect.SDEventStream;
import opennlp.tools.sentdetect.SentenceDetector;
import opennlp.tools.sentdetect.SentenceDetectorFactory;
import opennlp.tools.sentdetect.SentenceModel;
import opennlp.tools.sentdetect.SentenceSample;
import opennlp.tools.sentdetect.lang.Factory;
import opennlp.tools.util.DownloadUtil;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.Span;
import opennlp.tools.util.StringList;
import opennlp.tools.util.StringUtil;
import opennlp.tools.util.TrainingParameters;

public class SentenceDetectorME
implements SentenceDetector {
    public static final String SPLIT = "s";
    public static final String NO_SPLIT = "n";
    private final MaxentModel model;
    private final SDContextGenerator cgen;
    private final EndOfSentenceScanner scanner;
    private final List<Double> sentProbs = new ArrayList<Double>();
    private final Dictionary abbDict;
    protected final boolean useTokenEnd;

    public SentenceDetectorME(String language) throws IOException {
        this(DownloadUtil.downloadModel(language, DownloadUtil.ModelType.SENTENCE_DETECTOR, SentenceModel.class));
    }

    public SentenceDetectorME(SentenceModel model) {
        SentenceDetectorFactory sdFactory = model.getFactory();
        this.model = model.getMaxentModel();
        this.cgen = sdFactory.getSDContextGenerator();
        this.scanner = sdFactory.getEndOfSentenceScanner();
        this.abbDict = model.getAbbreviations();
        this.useTokenEnd = sdFactory.isUseTokenEnd();
    }

    public SentenceDetectorME(SentenceModel model, Factory factory) {
        this.model = model.getMaxentModel();
        char[] customEOSCharacters = model.getEosCharacters();
        if (customEOSCharacters == null) {
            this.cgen = factory.createSentenceContextGenerator(model.getLanguage(), SentenceDetectorME.getAbbreviations(model.getAbbreviations()));
            this.scanner = factory.createEndOfSentenceScanner(model.getLanguage());
        } else {
            this.cgen = factory.createSentenceContextGenerator(SentenceDetectorME.getAbbreviations(model.getAbbreviations()), customEOSCharacters);
            this.scanner = factory.createEndOfSentenceScanner(customEOSCharacters);
        }
        this.abbDict = model.getAbbreviations();
        this.useTokenEnd = model.useTokenEnd();
    }

    private static Set<String> getAbbreviations(Dictionary abbreviations) {
        if (abbreviations == null) {
            return Collections.emptySet();
        }
        return abbreviations.asStringSet();
    }

    @Override
    public String[] sentDetect(CharSequence s2) {
        String[] sentences;
        Span[] spans = this.sentPosDetect(s2);
        if (spans.length != 0) {
            sentences = new String[spans.length];
            for (int si = 0; si < spans.length; ++si) {
                sentences[si] = spans[si].getCoveredText(s2).toString();
            }
        } else {
            sentences = new String[]{};
        }
        return sentences;
    }

    private int getFirstWS(CharSequence s2, int pos) {
        while (pos < s2.length() && !StringUtil.isWhitespace(s2.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    private int getFirstNonWS(CharSequence s2, int pos) {
        while (pos < s2.length() && StringUtil.isWhitespace(s2.charAt(pos))) {
            ++pos;
        }
        return pos;
    }

    @Override
    public Span[] sentPosDetect(CharSequence s2) {
        Span span;
        this.sentProbs.clear();
        List<Integer> enders = this.scanner.getPositions(s2);
        ArrayList<Integer> positions = new ArrayList<Integer>(enders.size());
        int end = enders.size();
        int index = 0;
        for (int i = 0; i < end; ++i) {
            double[] probs;
            String bestOutcome;
            int cint = enders.get(i);
            int fws = this.getFirstWS(s2, cint + 1);
            if (i + 1 < end && enders.get(i + 1) < fws || positions.size() > 0 && cint < (Integer)positions.get(positions.size() - 1) || !(bestOutcome = this.model.getBestOutcome(probs = this.model.eval(this.cgen.getContext(s2, cint)))).equals(SPLIT) || !this.isAcceptableBreak(s2, index, cint)) continue;
            if (index != cint) {
                if (this.useTokenEnd) {
                    positions.add(this.getFirstNonWS(s2, this.getFirstWS(s2, cint + 1)));
                } else {
                    positions.add(this.getFirstNonWS(s2, cint + 1));
                }
                this.sentProbs.add(probs[this.model.getIndex(bestOutcome)]);
            }
            index = cint + 1;
        }
        int[] starts = new int[positions.size()];
        for (int i = 0; i < starts.length; ++i) {
            starts[i] = (Integer)positions.get(i);
        }
        if (starts.length == 0) {
            int start;
            int end2 = s2.length();
            for (start = 0; start < s2.length() && StringUtil.isWhitespace(s2.charAt(start)); ++start) {
            }
            while (end2 > 0 && StringUtil.isWhitespace(s2.charAt(end2 - 1))) {
                --end2;
            }
            if (end2 - start > 0) {
                this.sentProbs.add(1.0);
                return new Span[]{new Span(start, end2)};
            }
            return new Span[0];
        }
        boolean leftover = starts[starts.length - 1] != s2.length();
        Span[] spans = new Span[leftover ? starts.length + 1 : starts.length];
        for (int si = 0; si < starts.length; ++si) {
            int start = si == 0 ? 0 : starts[si - 1];
            Span span2 = new Span(start, starts[si]).trim(s2);
            if (span2.length() > 0) {
                spans[si] = span2;
                continue;
            }
            this.sentProbs.remove(si);
        }
        if (leftover && (span = new Span(starts[starts.length - 1], s2.length()).trim(s2)).length() > 0) {
            spans[spans.length - 1] = span;
            this.sentProbs.add(1.0);
        }
        for (int i = 0; i < spans.length; ++i) {
            double prob = this.sentProbs.get(i);
            spans[i] = new Span(spans[i], prob);
        }
        return spans;
    }

    public double[] getSentenceProbabilities() {
        double[] sentProbArray = new double[this.sentProbs.size()];
        for (int i = 0; i < sentProbArray.length; ++i) {
            sentProbArray[i] = this.sentProbs.get(i);
        }
        return sentProbArray;
    }

    protected boolean isAcceptableBreak(CharSequence s2, int fromIndex, int candidateIndex) {
        if (this.abbDict == null) {
            return true;
        }
        for (StringList abb : this.abbDict) {
            String token = abb.getToken(0);
            int tokenLength = token.length();
            int tokenPosition = s2.toString().indexOf(token, fromIndex);
            if (tokenPosition + tokenLength < candidateIndex || tokenPosition > candidateIndex) continue;
            return false;
        }
        return true;
    }

    public static SentenceModel train(String languageCode, ObjectStream<SentenceSample> samples, SentenceDetectorFactory sdFactory, TrainingParameters mlParams) throws IOException {
        HashMap<String, String> manifestInfoEntries = new HashMap<String, String>();
        SDEventStream eventStream = new SDEventStream(samples, sdFactory.getSDContextGenerator(), sdFactory.getEndOfSentenceScanner());
        EventTrainer trainer = TrainerFactory.getEventTrainer(mlParams, manifestInfoEntries);
        MaxentModel sentModel = trainer.train(eventStream);
        return new SentenceModel(languageCode, sentModel, manifestInfoEntries, sdFactory);
    }
}

