/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.PatternWatch;
import com.saxonica.ee.stream.watch.Terminator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.QuitParsingException;
import net.sf.saxon.trans.XPathException;

public class Trigger
extends PatternWatch {
    private final ItemFeed action;
    private final XPathContext selectionContext;
    private boolean matchCurrentGroup = false;

    public Trigger(Pattern selection, ItemFeed action, XPathContext selectionContext) {
        this.action = action;
        this.selectionContext = selectionContext;
        this.setSelection(selection);
    }

    @Override
    public boolean matchesNode(FleetingNode node, XPathContext context) throws XPathException {
        return super.matchesNode(node, this.selectionContext);
    }

    public ItemFeed getAction() {
        return this.action;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        FleetingParentNode anchor = this.getAnchorNode();
        if (anchor != null && anchor.getNodeKind() == 9) {
            terminator = new Terminator(){

                @Override
                public void terminate() throws QuitParsingException {
                    throw new QuitParsingException(false);
                }
            };
        }
        this.action.open(terminator);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        return this.action.startSelectedParentNode(node, locationId);
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        this.action.endSelectedParentNode(locationId);
    }

    @Override
    public void processItem(Item item) throws XPathException {
        this.action.append(item);
    }

    @Override
    public void close() throws XPathException {
        this.action.close();
    }

    public boolean isMatchCurrentGroup() {
        return this.matchCurrentGroup;
    }

    @Override
    public void setSelection(Pattern selection) {
        super.setSelection(selection);
        if (selection.matchesCurrentGroup()) {
            this.setMatchCurrentGroup(true);
        }
    }

    public void setMatchCurrentGroup(boolean matchCurrentGroup) {
        this.matchCurrentGroup = matchCurrentGroup;
    }
}

