/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline;

import java.io.IOException;
import java.util.Map;
import opennlp.tools.cmdline.ArgumentParser;
import opennlp.tools.cmdline.ObjectStreamFactory;
import opennlp.tools.cmdline.StreamFactoryRegistry;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.cmdline.TypedCmdLineTool;
import opennlp.tools.util.ObjectStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractConverterTool<T, P>
extends TypedCmdLineTool<T, P> {
    private static final Logger logger = LoggerFactory.getLogger(AbstractConverterTool.class);

    protected AbstractConverterTool(Class<T> sampleType) {
        super(sampleType);
    }

    @Override
    public String getShortDescription() {
        Map factories = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder help = new StringBuilder();
        if (2 == factories.keySet().size()) {
            for (String format : factories.keySet()) {
                if ("opennlp".equals(format)) continue;
                help.append(format);
            }
            return "Converts " + String.valueOf(help) + " data format to native OpenNLP format";
        }
        if (2 < factories.keySet().size()) {
            for (String format : factories.keySet()) {
                if ("opennlp".equals(format)) continue;
                help.append(format).append(",");
            }
            return "Converts external data formats (" + help.substring(0, help.length() - 1) + ") to native OpenNLP format";
        }
        throw new AssertionError((Object)"There should be more than 1 factory registered for converter tool");
    }

    private String createHelpString(String format, String usage) {
        return "Usage: opennlp " + this.getName() + " " + format + " " + usage;
    }

    @Override
    public String getHelp() {
        Map factories = StreamFactoryRegistry.getFactories(this.type);
        StringBuilder help = new StringBuilder("help|");
        for (String formatName : factories.keySet()) {
            if ("opennlp".equals(formatName)) continue;
            help.append(formatName).append("|");
        }
        return this.createHelpString(help.substring(0, help.length() - 1), "[help|options...]");
    }

    @Override
    public String getHelp(String format) {
        return this.getHelp();
    }

    @Override
    public void run(String format, String[] args) {
        if (0 == args.length) {
            logger.info(this.getHelp());
        } else {
            String errorMessage;
            format = args[0];
            ObjectStreamFactory streamFactory = this.getStreamFactory(format);
            String[] formatArgs = new String[args.length - 1];
            System.arraycopy(args, 1, formatArgs, 0, formatArgs.length);
            String helpString = this.createHelpString(format, ArgumentParser.createUsage(streamFactory.getParameters()));
            if (0 == formatArgs.length || 1 == formatArgs.length && "help".equals(formatArgs[0])) {
                logger.info(helpString);
                System.exit(0);
            }
            if (null != (errorMessage = ArgumentParser.validateArgumentsLoudly(formatArgs, streamFactory.getParameters()))) {
                throw new TerminateToolException(1, errorMessage + "\n" + helpString);
            }
            try (ObjectStream sampleStream = streamFactory.create(formatArgs);){
                Object sample2;
                while ((sample2 = sampleStream.read()) != null) {
                    logger.info(sample2.toString());
                }
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "IO error while converting data : " + e.getMessage(), e);
            }
        }
    }
}

