/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.update;

import com.saxonica.ee.update.BasicUpdatingExpression;
import com.saxonica.ee.update.PendingUpdateListImpl;
import com.saxonica.ee.update.RenameAction;
import java.util.function.Supplier;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.Operand;
import net.sf.saxon.expr.OperandRole;
import net.sf.saxon.expr.elab.Elaborator;
import net.sf.saxon.expr.elab.ItemEvaluator;
import net.sf.saxon.expr.elab.UpdateElaborator;
import net.sf.saxon.expr.elab.UpdateEvaluator;
import net.sf.saxon.expr.parser.ContextItemStaticInfo;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.expr.parser.ExpressionVisitor;
import net.sf.saxon.expr.parser.RebindingMap;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.expr.parser.TypeChecker;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceResolver;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.QNameException;
import net.sf.saxon.trace.ExpressionPresenter;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.Affinity;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.QNameValue;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.StringValue;

public class RenameExpression
extends BasicUpdatingExpression {
    private final NamespaceResolver nsContext;
    private final NamespaceUri defaultNamespace;
    private final Operand nameOp;
    private final Operand targetOp;
    private final boolean inheritNamespaces;

    public RenameExpression(Expression target, Expression name, NamespaceResolver nsContext, NamespaceUri defaultNamespace, boolean inherit) {
        this.nameOp = new Operand(this, name, OperandRole.SINGLE_ATOMIC);
        this.targetOp = new Operand(this, target, OperandRole.INSPECT);
        this.nsContext = nsContext;
        this.defaultNamespace = defaultNamespace == null ? NamespaceUri.NULL : defaultNamespace;
        this.inheritNamespaces = inherit;
    }

    public Expression getTargetExp() {
        return this.targetOp.getChildExpression();
    }

    public void setTargetExp(Expression targetExpression) {
        this.targetOp.setChildExpression(targetExpression);
    }

    public Expression getNameExp() {
        return this.nameOp.getChildExpression();
    }

    public void setNameExp(Expression nameExpression) {
        this.nameOp.setChildExpression(nameExpression);
    }

    @Override
    public Iterable<Operand> operands() {
        return this.operandList(this.targetOp, this.nameOp);
    }

    @Override
    public Expression typeCheck(ExpressionVisitor visitor, ContextItemStaticInfo contextInfo) throws XPathException {
        this.typeCheckChildren(visitor, contextInfo);
        TypeChecker tc = visitor.getConfiguration().getTypeChecker(false);
        Supplier<RoleDiagnostic> roleSupplier0 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "insert", 1);
            role0.setErrorCode("XUDY0027");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.NON_EMPTY_SEQUENCE, roleSupplier0, visitor));
        Supplier<RoleDiagnostic> roleSUpplier1 = () -> {
            RoleDiagnostic role0 = new RoleDiagnostic(10, "rename", 0);
            role0.setErrorCode("XUTY0012");
            return role0;
        };
        this.setTargetExp(tc.staticTypeCheck(this.getTargetExp(), SequenceType.OPTIONAL_NODE, roleSUpplier1, visitor));
        Supplier<RoleDiagnostic> roleSUpplier2 = () -> {
            RoleDiagnostic role1 = new RoleDiagnostic(10, "rename", 1);
            role1.setErrorCode("XPTY0004");
            return role1;
        };
        this.setNameExp(tc.staticTypeCheck(this.getNameExp(), SequenceType.SINGLE_ATOMIC, roleSUpplier2, visitor));
        TypeHierarchy th = visitor.getConfiguration().getTypeHierarchy();
        ItemType supplied = this.getNameExp().getItemType();
        if (th.relationship(supplied, BuiltInAtomicType.STRING) == Affinity.DISJOINT && th.relationship(supplied, BuiltInAtomicType.UNTYPED_ATOMIC) == Affinity.DISJOINT && th.relationship(supplied, BuiltInAtomicType.QNAME) == Affinity.DISJOINT) {
            throw new XPathException("The new name must be a string, QName, or untypedAtomic").withErrorCode("XPTY0004").asTypeError().withLocation(this.getLocation());
        }
        return this;
    }

    @Override
    public Expression copy(RebindingMap rebindings) {
        RenameExpression exp = new RenameExpression(this.getTargetExp().copy(rebindings), this.getNameExp().copy(rebindings), this.nsContext, this.defaultNamespace, this.inheritNamespaces);
        ExpressionTool.copyLocationInfo(this, exp);
        return exp;
    }

    @Override
    public void export(ExpressionPresenter out) throws XPathException {
        out.startElement("rename", this);
        if (this.inheritNamespaces) {
            out.emitAttribute("flags", "i");
        }
        this.getTargetExp().export(out);
        this.getNameExp().export(out);
        out.endElement();
    }

    @Override
    public String getExpressionName() {
        return "rename";
    }

    @Override
    public Elaborator getElaborator() {
        return new RenameExpressionElaborator();
    }

    private static class RenameExpressionElaborator
    extends UpdateElaborator {
        private RenameExpressionElaborator() {
        }

        @Override
        public UpdateEvaluator elaborateForUpdate() {
            RenameExpression expr = (RenameExpression)this.getExpression();
            ItemEvaluator targetEval = expr.getTargetExp().makeElaborator().elaborateForItem();
            ItemEvaluator nameEval = expr.getNameExp().makeElaborator().elaborateForItem();
            return (context, pul) -> {
                NamespaceMap nr;
                NamespaceUri existingURI;
                NamespaceUri uri;
                String localName;
                String prefix;
                NodeInfo node = (NodeInfo)targetEval.eval(context);
                int nodeKind = node.getNodeKind();
                if (nodeKind != 1 && nodeKind != 2 && nodeKind != 7) {
                    throw new XPathException("Node to be renamed is not an element, attribute, or processing-instruction", "XUTY0012").withLocation(expr.getLocation());
                }
                if (!node.getTreeInfo().isMutable()) {
                    throw new XPathException("Node to be renamed is not updatable", "SXUP0081").withLocation(expr.getLocation());
                }
                AtomicValue nameValue = (AtomicValue)nameEval.eval(context);
                if (nameValue instanceof StringValue) {
                    String rawName = nameValue.getStringValue();
                    try {
                        String[] parts = NameChecker.getQNameParts(rawName);
                        prefix = parts[0];
                        localName = parts[1];
                    }
                    catch (QNameException err11) {
                        throw new XPathException("Invalid node name. " + err11.getMessage(), "XQDY0074", expr.getLocation()).withXPathContext(context);
                    }
                    if (prefix.isEmpty()) {
                        uri = nodeKind == 1 ? expr.defaultNamespace : NamespaceUri.NULL;
                    } else {
                        uri = expr.nsContext.getURIForPrefix(prefix, true);
                        if (uri == null) {
                            throw new XPathException("Undeclared prefix in new node name: " + prefix, "XQDY0074", expr.getLocation()).withXPathContext(context);
                        }
                    }
                } else if (nameValue instanceof QNameValue) {
                    localName = ((QNameValue)nameValue).getLocalName();
                    uri = ((QNameValue)nameValue).getNamespaceURI();
                    prefix = ((QNameValue)nameValue).getPrefix();
                } else {
                    throw new XPathException("Computed element name has incorrect type").withErrorCode("XPTY0004").asTypeError().withXPathContext(context).withLocation(expr.getLocation());
                }
                if (uri.isEmpty()) {
                    prefix = "";
                }
                if (prefix.equals("xmlns")) {
                    prefix = "x-xmlns";
                }
                if (nodeKind == 7) {
                    if (prefix.length() > 0 || !uri.isEmpty()) {
                        throw new XPathException("Processing instruction cannot be in a namespace").withErrorCode("XUDY0025").asTypeError().withXPathContext(context).withLocation(expr.getLocation());
                    }
                    if (localName.equalsIgnoreCase("xml")) {
                        throw new XPathException("Processing instruction cannot be named 'xml'").withErrorCode("XQDY0064").withXPathContext(context).withLocation(expr.getLocation());
                    }
                }
                FingerprintedQName name = new FingerprintedQName(prefix, uri, localName);
                NodeInfo targetNode = node;
                if (nodeKind == 2) {
                    targetNode = node.getParent();
                } else if (nodeKind == 7) {
                    targetNode = null;
                }
                if (!(targetNode == null || nodeKind != 1 && prefix.length() == 0 || (existingURI = (nr = targetNode.getAllNamespaces()).getURIForPrefix(prefix, true)) == null || existingURI.isEmpty() || existingURI.equals(uri))) {
                    throw new XPathException("New name conflicts with existing namespace binding").withErrorCode("XUDY0023").asTypeError().withXPathContext(context).withLocation(expr.getLocation());
                }
                try {
                    RenameAction action = new RenameAction(node, name, expr.inheritNamespaces);
                    action.setOriginator(expr);
                    ((PendingUpdateListImpl)pul).add(action);
                }
                catch (XPathException e) {
                    throw e.maybeWithLocation(expr.getLocation()).maybeWithContext(context);
                }
            };
        }
    }
}

