/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.wrap;

import de.ids_mannheim.korap.query.wrap.SpanQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanRegexQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanSimpleQueryWrapper;
import de.ids_mannheim.korap.query.wrap.SpanWildcardQueryWrapper;
import de.ids_mannheim.korap.util.QueryException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.search.spans.SpanOrQuery;
import org.apache.lucene.search.spans.SpanQuery;

public class SpanAlterQueryWrapper
extends SpanQueryWrapper {
    private String field;
    private List<SpanQueryWrapper> alternatives;

    public SpanAlterQueryWrapper(String field) {
        this.field = field;
        this.alternatives = new ArrayList<SpanQueryWrapper>();
    }

    public SpanAlterQueryWrapper(String field, SpanQueryWrapper query) {
        this.field = field;
        this.alternatives = new ArrayList<SpanQueryWrapper>();
        this.maybeUnsorted = query.maybeUnsorted();
        this.alternatives.add(query);
    }

    public SpanAlterQueryWrapper(String field, String ... terms) {
        this.field = field;
        this.alternatives = new ArrayList<SpanQueryWrapper>();
        for (String term : terms) {
            this.isNull = false;
            this.alternatives.add(new SpanSimpleQueryWrapper(this.field, term));
        }
    }

    public SpanAlterQueryWrapper setNegative(Boolean neg) {
        this.isNegative = neg;
        return this;
    }

    public SpanAlterQueryWrapper or(String term) {
        SpanSimpleQueryWrapper sqw = new SpanSimpleQueryWrapper(this.field, term);
        return this.or(sqw);
    }

    public SpanAlterQueryWrapper or(SpanQueryWrapper term) {
        if (term.isNull()) {
            return this;
        }
        if (term.isNegative()) {
            this.isNegative = true;
        }
        if (term.isOptional()) {
            this.isOptional = true;
        }
        this.alternatives.add(term);
        if (term.maybeUnsorted()) {
            this.maybeUnsorted = true;
        }
        this.isNull = false;
        return this;
    }

    public SpanAlterQueryWrapper or(SpanRegexQueryWrapper term) {
        this.alternatives.add(term);
        this.isNull = false;
        return this;
    }

    public SpanAlterQueryWrapper or(SpanWildcardQueryWrapper wc) {
        this.alternatives.add(wc);
        this.isNull = false;
        return this;
    }

    @Override
    public boolean isExtendedToTheRight() {
        if (this.alternatives.size() == 0) {
            return this.alternatives.get(0).isExtendedToTheRight();
        }
        Iterator<SpanQueryWrapper> clause = this.alternatives.iterator();
        while (clause.hasNext()) {
            if (!clause.next().isExtendedToTheRight()) continue;
            return true;
        }
        return false;
    }

    @Override
    public SpanQuery toFragmentQuery() throws QueryException {
        if (this.isNull || this.alternatives.size() == 0) {
            return null;
        }
        if (this.alternatives.size() == 1) {
            return this.alternatives.get(0).retrieveNode(this.retrieveNode).toFragmentQuery();
        }
        Iterator<SpanQueryWrapper> clause = this.alternatives.iterator();
        SpanOrQuery soquery = new SpanOrQuery(clause.next().retrieveNode(this.retrieveNode).toFragmentQuery());
        while (clause.hasNext()) {
            soquery.addClause(clause.next().retrieveNode(this.retrieveNode).toFragmentQuery());
        }
        return soquery;
    }
}

