/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.index;

import de.ids_mannheim.korap.response.Match;
import java.nio.ByteBuffer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TermInfo
implements Comparable<TermInfo> {
    private static final Logger log = LoggerFactory.getLogger(Match.class);
    public static final boolean DEBUG = false;
    private String foundry;
    private String layer;
    private String value;
    private String term;
    private String type;
    private String annotation;
    private int pos = 0;
    private ByteBuffer payload;
    private boolean analyzed = false;
    private int startChar = -1;
    private int endChar = -1;
    private int startPos = -1;
    private int endPos = -1;
    private int targetStartPos = -1;
    private int targetEndPos = -1;
    private byte depth = 0;
    private Pattern prefixRegex = Pattern.compile("(?:([^/]+)/)?([^:/]+)(?::(.+?))?");
    private Matcher matcher;

    public TermInfo(String term, int pos, ByteBuffer payload) {
        this.term = term;
        this.startPos = pos;
        this.endPos = pos;
        this.payload = payload;
    }

    public TermInfo analyze() {
        if (this.analyzed) {
            return this;
        }
        int ttype = 0;
        String tterm = this.term;
        int lastPos = this.payload.position();
        this.payload.rewind();
        switch (tterm.charAt(0)) {
            case '<': {
                if (tterm.charAt(1) == '>') {
                    this.type = "span";
                    tterm = tterm.substring(3);
                    ttype = 2;
                    break;
                }
                this.type = "relTarget";
                tterm = tterm.substring(2);
                ttype = 3;
                break;
            }
            case '>': {
                this.type = "relSrc";
                tterm = tterm.substring(2);
                ttype = 3;
                break;
            }
            case '_': {
                this.type = "pos";
                ttype = 1;
                tterm = tterm.substring(1);
                break;
            }
            case '@': {
                this.type = "attr";
                ttype = 4;
                tterm = tterm.substring(2);
                break;
            }
            case '~': {
                this.type = "mark";
                ttype = 5;
                tterm = tterm.substring(2);
                break;
            }
            default: {
                this.type = "term";
            }
        }
        byte pti = 0;
        if (ttype != 1) {
            pti = this.payload.get();
            this.matcher = this.prefixRegex.matcher(tterm);
            if (this.matcher.matches() && this.matcher.groupCount() == 3) {
                this.annotation = tterm;
                this.foundry = this.matcher.group(1) != null ? this.matcher.group(1) : "base";
                this.layer = this.matcher.group(2);
                this.value = this.matcher.group(3);
            }
        } else if (ttype == 5) {
            pti = this.payload.get();
            this.value = tterm;
            this.startChar = this.payload.getInt();
            this.endChar = this.payload.getInt();
        } else {
            this.value = tterm;
            this.startChar = this.payload.getInt();
            this.endChar = this.payload.getInt();
        }
        if (ttype == 2) {
            this.startChar = this.payload.getInt();
            this.endChar = this.payload.getInt();
            if (this.startChar == this.endChar) {
                this.type = "empty";
            }
        }
        if (ttype > 1 && ttype != 4) {
            if (this.type.equals("relTarget")) {
                this.endPos = this.startPos;
                this.startPos = this.payload.getInt() - 1;
            } else if (pti == 32) {
                this.targetStartPos = this.payload.getInt();
            } else if (pti == 33) {
                this.payload.getInt();
                this.payload.getInt();
                this.endPos = this.startPos;
                this.targetStartPos = this.payload.getInt();
                this.targetEndPos = this.payload.getInt();
            } else if (pti == 34) {
                this.payload.getInt();
                this.endPos = this.payload.getInt();
                this.targetStartPos = this.payload.getInt();
            } else if (pti == 35) {
                this.payload.getInt();
                this.payload.getInt();
                this.payload.getInt();
                this.payload.getInt();
                this.endPos = this.payload.getInt();
                this.targetStartPos = this.payload.getInt();
                this.targetEndPos = this.payload.getInt();
            } else {
                this.endPos = this.payload.getInt() - 1;
            }
        }
        if (ttype == 2 && this.payload.position() < lastPos) {
            this.depth = this.payload.get();
        }
        this.analyzed = true;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public int getStartChar() {
        return this.startChar;
    }

    public void setStartChar(int pos) {
        this.startChar = pos;
    }

    public int getEndChar() {
        return this.endChar;
    }

    public void setEndChar(int pos) {
        this.endChar = pos;
    }

    public int getStartPos() {
        return this.startPos;
    }

    public int getEndPos() {
        return this.endPos;
    }

    public int getTargetStartPos() {
        return this.targetStartPos;
    }

    public int getTargetEndPos() {
        return this.targetEndPos;
    }

    public byte getDepth() {
        return this.depth;
    }

    public String getFoundry() {
        return this.foundry;
    }

    public String getLayer() {
        return this.layer;
    }

    public String getValue() {
        return this.value;
    }

    public String getAnnotation() {
        return this.annotation;
    }

    public String toString() {
        this.analyze();
        StringBuffer sb = new StringBuffer();
        sb.append('<').append(this.getType()).append('>');
        sb.append(this.getFoundry()).append('/').append(this.getLayer());
        if (this.getValue() != null) {
            sb.append(':').append(this.getValue());
        }
        if (this.getDepth() != 0) {
            sb.append('(').append(this.getDepth()).append(')');
        }
        sb.append('[').append(this.getStartPos());
        sb.append('-').append(this.getEndPos()).append(']');
        sb.append('[').append(this.getStartChar());
        sb.append('-').append(this.getEndChar()).append(']');
        return sb.toString();
    }

    @Override
    public int compareTo(TermInfo obj) {
        this.analyze();
        obj.analyze();
        if (this.startChar < obj.startChar) {
            return -1;
        }
        if (this.startChar > obj.startChar) {
            return 1;
        }
        if (this.depth < obj.depth) {
            return 1;
        }
        if (this.depth > obj.depth) {
            return -1;
        }
        return 0;
    }
}

