/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.cmdline.entitylinker;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import opennlp.tools.cmdline.BasicCmdLineTool;
import opennlp.tools.cmdline.CmdLineUtil;
import opennlp.tools.cmdline.PerformanceMonitor;
import opennlp.tools.cmdline.SystemInputStreamFactory;
import opennlp.tools.cmdline.TerminateToolException;
import opennlp.tools.entitylinker.EntityLinker;
import opennlp.tools.entitylinker.EntityLinkerFactory;
import opennlp.tools.entitylinker.EntityLinkerProperties;
import opennlp.tools.namefind.NameSample;
import opennlp.tools.util.InputStreamFactory;
import opennlp.tools.util.PlainTextByLineStream;
import opennlp.tools.util.Span;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EntityLinkerTool
extends BasicCmdLineTool {
    private static final Logger logger = LoggerFactory.getLogger(EntityLinkerTool.class);

    @Override
    public String getShortDescription() {
        return "Links an entity to an external data set";
    }

    @Override
    public void run(String[] args) {
        if (0 == args.length) {
            logger.info(this.getHelp());
        } else {
            EntityLinker<?> entityLinker;
            EntityLinkerProperties properties;
            String entityType = "location";
            try {
                properties = new EntityLinkerProperties(new File(args[0]));
            }
            catch (IOException e) {
                throw new TerminateToolException(-1, "Failed to load the properties file!");
            }
            try {
                entityLinker = EntityLinkerFactory.getLinker(entityType, properties);
            }
            catch (Exception e) {
                throw new TerminateToolException(-1, "Failed to instantiate the Entity Linker: " + e.getMessage());
            }
            PerformanceMonitor perfMon = new PerformanceMonitor("sent");
            perfMon.start();
            try (PlainTextByLineStream untokenizedLineStream = new PlainTextByLineStream((InputStreamFactory)new SystemInputStreamFactory(), SystemInputStreamFactory.encoding());){
                String line;
                ArrayList<NameSample> document = new ArrayList<NameSample>();
                while ((line = (String)untokenizedLineStream.read()) != null) {
                    if (line.trim().isEmpty()) {
                        StringBuilder text = new StringBuilder();
                        Span[] sentences = new Span[document.size()];
                        Span[][] tokensBySentence = new Span[document.size()][];
                        Span[][] namesBySentence = new Span[document.size()][];
                        for (int i = 0; i < document.size(); ++i) {
                            NameSample sample2 = (NameSample)document.get(i);
                            namesBySentence[i] = sample2.getNames();
                            int sentenceBegin = text.length();
                            Span[] tokens = new Span[sample2.getSentence().length];
                            for (int ti = 0; ti < sample2.getSentence().length; ++ti) {
                                int tokenBegin = text.length();
                                text.append(sample2.getSentence()[ti]);
                                text.append(" ");
                                tokens[ti] = new Span(tokenBegin, text.length());
                            }
                            tokensBySentence[i] = tokens;
                            sentences[i] = new Span(sentenceBegin, text.length());
                            text.append("\n");
                        }
                        List<?> linkedSpans = entityLinker.find(text.toString(), sentences, tokensBySentence, namesBySentence);
                        for (Span linkedSpan : linkedSpans) {
                            logger.info(linkedSpan.toString());
                        }
                        perfMon.incrementCounter(document.size());
                        document.clear();
                        continue;
                    }
                    document.add(NameSample.parse(line, false));
                }
            }
            catch (IOException e) {
                CmdLineUtil.handleStdinIoError(e);
            }
            perfMon.stopAndPrintFinalResult();
        }
    }

    @Override
    public String getHelp() {
        return "Usage: opennlp " + this.getName() + " model < sentences";
    }
}

