/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.OutputterEvent;
import net.sf.saxon.event.OutputterEventBuffer;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.ReceiverOption;
import net.sf.saxon.event.SignificantItemDetector;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ConditionalBlock;
import net.sf.saxon.expr.instruct.OnEmptyExpr;
import net.sf.saxon.expr.instruct.OnNonEmptyExpr;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.StringConstants;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.StringValue;

public class ConditionalBlockAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = ConditionalBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        this.consumingArg = ConditionalBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return new ConditionalBlockFeed((ConditionalBlock)this.getExpression(), this.consumingArg, out, context);
    }

    public static class ConditionalBlockFeed
    extends ItemFeed {
        private final int consumingArg;
        private boolean empty = true;
        private int level = 0;
        private boolean watchForDocumentChildren;
        private final boolean consumingArgIsOnEmpty;
        private final List<OnNonEmptyExpr> nonEmptyPendingList = new ArrayList<OnNonEmptyExpr>();
        private final List<OutputterEvent> tentativeContent = new ArrayList<OutputterEvent>();

        ConditionalBlockFeed(ConditionalBlock exp, int arg, ItemFeed result, XPathContext context) {
            super(exp, result, context);
            this.consumingArg = arg;
            this.consumingArgIsOnEmpty = exp.getChildExpression(arg) instanceof OnEmptyExpr;
        }

        public List<OutputterEvent> getTentativeContent() {
            return this.tentativeContent;
        }

        public void flushIfNonEmpty() throws XPathException {
            if (!this.empty && !this.tentativeContent.isEmpty()) {
                Outputter out = this.getNextOutputter();
                for (OutputterEvent event : this.tentativeContent) {
                    event.replay(out);
                }
                this.tentativeContent.clear();
            }
        }

        private void action() throws XPathException {
            if (this.level == 0 || this.level == 1 && this.watchForDocumentChildren) {
                this.empty = false;
            }
            this.flushIfNonEmpty();
        }

        public boolean isEmpty() {
            return this.empty;
        }

        private boolean isSignificant(Item item) {
            return SignificantItemDetector.isSignificant(item);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            ConditionalBlock block = (ConditionalBlock)this.getExpression();
            Outputter result = this.getNextOutputter();
            for (int i = 0; i < this.consumingArg; ++i) {
                Expression child = block.getChildExpression(i);
                if (child instanceof OnEmptyExpr) continue;
                if (child instanceof OnNonEmptyExpr) {
                    if (this.empty) {
                        OutputterEventBuffer temp = new OutputterEventBuffer();
                        temp.setBuffer(this.tentativeContent);
                        SequenceIterator iter = child.iterate(this.getContext());
                        ConditionalBlockFeed.processItems(iter, temp);
                        continue;
                    }
                    SequenceIterator iter = child.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(iter, result);
                    continue;
                }
                SequenceTool.supply(child.iterate(this.getContext()), item -> {
                    if (this.empty && this.isSignificant(item)) {
                        this.empty = false;
                        this.flushIfNonEmpty();
                    }
                    result.append(item);
                });
            }
        }

        @Override
        public void close() throws XPathException {
            if (this.consumingArgIsOnEmpty) {
                this.empty = true;
            }
            ConditionalBlock block = (ConditionalBlock)this.getExpression();
            Outputter result = this.getNextOutputter();
            for (int i = this.consumingArg + 1; i < block.size(); ++i) {
                Expression child = block.getChildExpression(i);
                if (child instanceof OnEmptyExpr) {
                    if (!this.empty) continue;
                    SequenceIterator si = child.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(si, result);
                    continue;
                }
                if (child instanceof OnNonEmptyExpr) {
                    if (this.empty) {
                        if (i == block.size() - 1) continue;
                        OutputterEventBuffer temp = new OutputterEventBuffer();
                        temp.setBuffer(this.tentativeContent);
                        SequenceIterator iter = child.iterate(this.getContext());
                        ConditionalBlockFeed.processItems(iter, temp);
                        continue;
                    }
                    ConditionalBlockFeed.processItems(child.iterate(this.getContext()), result);
                    continue;
                }
                SequenceTool.supply(child.iterate(this.getContext()), item -> {
                    if (this.isSignificant(item)) {
                        this.empty = false;
                        this.flushIfNonEmpty();
                    }
                    result.append(item);
                });
            }
            result.close();
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            if (this.empty) {
                this.empty = false;
                for (OnNonEmptyExpr e : this.nonEmptyPendingList) {
                    SequenceIterator si = e.iterate(this.getContext());
                    ConditionalBlockFeed.processItems(si, this.getNextOutputter());
                }
            }
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }

        @Override
        public void endSelectedParentNode(Location locationId) throws XPathException {
            this.getResultFeed().endSelectedParentNode(locationId);
        }

        @Override
        public void startDocument(int properties) throws XPathException {
            if (this.level == 0) {
                this.watchForDocumentChildren = true;
            }
            ++this.level;
            this.getNextOutputter().startDocument(properties);
        }

        @Override
        public void endDocument() throws XPathException {
            --this.level;
            this.watchForDocumentChildren = false;
            this.getNextOutputter().endDocument();
        }

        @Override
        public void startElement(NodeName elemName, SchemaType typeCode, Location location, int properties) throws XPathException {
            this.action();
            ++this.level;
            this.getNextOutputter().startElement(elemName, typeCode, location, properties);
        }

        @Override
        public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
            this.action();
            ++this.level;
            this.getNextOutputter().startElement(elemName, type, attributes, namespaces, location, properties);
        }

        @Override
        public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
            this.action();
            this.getNextOutputter().namespace(prefix, namespaceUri, properties);
        }

        @Override
        public void endElement() throws XPathException {
            --this.level;
            this.getNextOutputter().endElement();
        }

        @Override
        public void characters(UnicodeString chars, Location location, int properties) throws XPathException {
            if (ReceiverOption.contains(properties, 0x100000) && this.isEmpty() && chars.toString().equals(" ")) {
                this.tentativeContent.add(new OutputterEvent.Text(StringConstants.SINGLE_SPACE, location, properties));
            } else {
                this.action();
                this.getNextOutputter().characters(chars, location, properties);
            }
        }

        @Override
        public void comment(UnicodeString content, Location location, int properties) throws XPathException {
            this.action();
            this.getNextOutputter().comment(content, location, properties);
        }

        @Override
        public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
            this.action();
            this.getNextOutputter().attribute(attName, typeCode, value, location, properties);
        }

        @Override
        public void append(Item item) throws XPathException {
            if (item instanceof StringValue && ((StringValue)item).isEmpty()) {
                if (this.isEmpty()) {
                    this.tentativeContent.add(new OutputterEvent.Append(item, Loc.NONE, 0));
                } else {
                    this.getNextOutputter().append(item);
                }
            } else {
                this.action();
                this.getNextOutputter().append(item);
            }
        }
    }
}

