/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import java.util.Map;
import net.sf.saxon.lib.ValidationStatisticsRecipient;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.s9api.Destination;
import net.sf.saxon.s9api.Processor;
import net.sf.saxon.s9api.SaxonApiException;
import net.sf.saxon.sapling.SaplingDocument;
import net.sf.saxon.sapling.SaplingElement;
import net.sf.saxon.sapling.Saplings;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaType;

public class StatisticsReporter
implements ValidationStatisticsRecipient {
    private Processor processor;
    private Destination destination;

    public void setReceiver(Processor processor, Destination destination) {
        this.processor = processor;
        this.destination = destination;
    }

    @Override
    public void notifyValidationStatistics(Map<SchemaComponent, Integer> statistics) throws SaxonApiException {
        if (this.processor == null) {
            throw new IllegalStateException("No destination has been set");
        }
        SaplingElement coverage = Saplings.elem("schemaCoverage");
        for (Map.Entry<SchemaComponent, Integer> entry : statistics.entrySet()) {
            SchemaComponent component = entry.getKey();
            int count = entry.getValue();
            String kind = null;
            NamespaceUri namespace = NamespaceUri.NULL;
            String localname = null;
            if (component instanceof SchemaType) {
                kind = ((SchemaType)component).isComplexType() ? "complexType" : "simpleType";
                namespace = ((SchemaType)component).getTargetNamespace();
                localname = ((SchemaType)component).getName();
            } else if (component instanceof ElementDecl) {
                kind = "element";
                namespace = ((ElementDecl)component).getTargetNamespace();
                localname = ((ElementDecl)component).getName();
            }
            coverage = coverage.withChild(Saplings.elem("component").withAttr("kind", kind).withAttr("namespace", namespace.toString()).withAttr("name", localname).withAttr("count", count + ""));
        }
        SaplingDocument report = Saplings.doc().withChild(coverage);
        report.send(this.processor, this.destination);
    }
}

