/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.validate;

import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.validate.LaxValidator;
import com.saxonica.ee.validate.SkipValidator;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.parser.ExplicitLocation;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.util.FastStringBuffer;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;

public class AnyTypeValidator
extends LaxValidator {
    String fixedValue = null;
    String defaultValue = null;
    boolean foundChildren = false;
    FastStringBuffer buffer;

    public AnyTypeValidator(Receiver next) {
        super(next);
    }

    public AnyTypeValidator(ElementDecl elementDecl, Receiver next) {
        super(next);
        if (elementDecl != null) {
            AtomicSequence fixed = elementDecl.getFixedValue();
            if (fixed != null) {
                this.fixedValue = ((AtomicValue)fixed).getStringValue();
            }
            this.defaultValue = elementDecl.getDefaultValueLexicalForm();
        }
    }

    @Override
    public void startElement(NodeName nodeName, SchemaType typeCode, Location location, int properties) throws XPathException {
        if (this.locallyInvalid) {
            this.childValidator = new SkipValidator(this.nextReceiver);
            this.nextReceiver.startElement(nodeName, AnyType.getInstance(), location, properties);
            return;
        }
        if (this.fixedValue != null) {
            String message = "Element " + Err.wrap(nodeName.getDisplayName(), 1) + " cannot appear here, because the containing " + this.getContainingElementName() + " element has fixed content";
            ValidationFailure ve = new ValidationFailure(message);
            ve.setConstraintReference(1, "cvc-elt", "5.2.2.1");
            ve.setSchemaType(this.getSchemaType());
            this.reportValidationError(ve, true, location);
        }
        this.foundChildren = true;
        super.startElement(nodeName, typeCode, location, properties);
    }

    @Override
    public void characters(CharSequence chars, Location locationId, int properties) throws XPathException {
        if (this.fixedValue != null || this.defaultValue != null) {
            if (this.buffer == null) {
                this.buffer = new FastStringBuffer(chars.length());
            }
            this.buffer.append(chars);
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void endElement() throws XPathException {
        if (this.fixedValue != null) {
            if (this.buffer == null || this.buffer.isEmpty()) {
                this.characters(this.fixedValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
            } else if (!this.buffer.toString().equals(this.fixedValue)) {
                String message = "The content of " + this.getContainingElementName() + " differs from the fixed value defined in the schema. Fixed value is " + Err.wrap(this.fixedValue, 4) + ", actual value is " + Err.wrap(this.buffer, 4);
                ValidationFailure ve = new ValidationFailure(message);
                ve.setConstraintReference(1, "cvc-elt", "5.2.2.2");
                ve.setSchemaType(this.getSchemaType());
                this.reportValidationError(ve, true, this.getContainingElementLocationId());
            }
        }
        if (this.defaultValue != null && !this.foundChildren && (this.buffer == null || this.buffer.isEmpty())) {
            this.characters(this.defaultValue, ExplicitLocation.UNKNOWN_LOCATION, 0);
        }
        super.endElement();
    }
}

