/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.query.spans;

import de.ids_mannheim.korap.constants.RelationDirection;
import de.ids_mannheim.korap.query.SpanFocusQuery;
import de.ids_mannheim.korap.query.spans.CandidateSpan;
import de.ids_mannheim.korap.query.spans.CandidateSpanComparator;
import de.ids_mannheim.korap.query.spans.RelationSpans;
import de.ids_mannheim.korap.query.spans.SimpleSpans;
import de.ids_mannheim.korap.util.KrillByte;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.search.spans.SpanQuery;
import org.apache.lucene.util.Bits;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FocusSpans
extends SimpleSpans {
    private List<Byte> classNumbers;
    private SpanQuery query;
    private final Logger log = LoggerFactory.getLogger(FocusSpans.class);
    public static final boolean DEBUG = false;
    private boolean isSorted;
    private boolean matchTemporaryClass;
    private boolean removeTemporaryClasses;
    private int windowSize;
    private int currentDoc;
    private int prevStart;
    private int prevDoc;
    private PriorityQueue<CandidateSpan> candidates;
    private CandidateSpanComparator comparator;

    public FocusSpans(SpanFocusQuery query, LeafReaderContext context, Bits acceptDocs, Map<Term, TermContext> termContexts) throws IOException {
        super(query, context, acceptDocs, termContexts);
        if (query.getClassNumbers() == null) {
            throw new IllegalArgumentException("At least one class number must be specified.");
        }
        this.classNumbers = query.getClassNumbers();
        this.windowSize = query.getWindowSize();
        this.isSorted = query.isSorted();
        this.matchTemporaryClass = query.matchTemporaryClass();
        this.removeTemporaryClasses = query.removeTemporaryClasses();
        this.candidates = new PriorityQueue<CandidateSpan>(this.windowSize, this.comparator);
        this.hasMoreSpans = this.firstSpans.next();
        this.currentDoc = this.firstSpans.doc();
        this.query = query;
    }

    @Override
    public boolean next() throws IOException {
        this.matchPayload.clear();
        this.spanId = 0;
        while (this.hasMoreSpans || this.candidates.size() > 0) {
            if (this.isSorted) {
                CandidateSpan cs;
                if (this.firstSpans.isPayloadAvailable() && this.updateSpanPositions(cs = new CandidateSpan(this.firstSpans))) {
                    this.setMatch(cs);
                    this.hasMoreSpans = this.firstSpans.next();
                    return true;
                }
                this.hasMoreSpans = this.firstSpans.next();
                continue;
            }
            if (this.candidates.isEmpty()) {
                this.currentDoc = this.firstSpans.doc();
                this.collectCandidates();
                continue;
            }
            this.setMatch(this.candidates.poll());
            this.collectCandidates();
            return true;
        }
        return false;
    }

    private void collectCandidates() throws IOException {
        CandidateSpan cs = null;
        CandidateSpan head = null;
        while (this.hasMoreSpans && this.firstSpans.doc() == this.currentDoc) {
            if (head == null) {
                head = this.candidates.peek();
            } else if (head.getStart() < this.firstSpans.start()) break;
            if (this.firstSpans.isPayloadAvailable() && this.updateSpanPositions(cs = new CandidateSpan(this.firstSpans)) && (cs.getDoc() != this.prevDoc || cs.getStart() >= this.prevStart)) {
                this.candidates.add(cs);
            }
            this.hasMoreSpans = this.firstSpans.next();
        }
    }

    private void setMatch(CandidateSpan cs) {
        this.prevStart = this.matchStartPosition = cs.getStart();
        this.matchEndPosition = cs.getEnd();
        this.prevDoc = this.matchDocNumber = cs.getDoc();
        this.matchPayload.addAll(cs.getPayloads());
        if (this.firstSpans instanceof RelationSpans && this.classNumbers.size() == 1) {
            RelationSpans relationSpans = (RelationSpans)this.firstSpans;
            RelationDirection direction = relationSpans.getDirection();
            if (this.classNumbers.get(0).byteValue() == relationSpans.getTempSourceNum()) {
                if (direction.equals((Object)RelationDirection.RIGHT)) {
                    this.setSpanId(relationSpans.getLeftId());
                } else {
                    this.setSpanId(relationSpans.getRightId());
                }
            } else if (this.classNumbers.get(0).byteValue() == relationSpans.getTempTargetNum()) {
                if (direction.equals((Object)RelationDirection.RIGHT)) {
                    this.setSpanId(relationSpans.getRightId());
                } else {
                    this.setSpanId(relationSpans.getLeftId());
                }
            }
            if (this.spanId > 0) {
                this.hasSpanId = true;
            }
        } else if (cs.getSpanId() > 0) {
            this.setSpanId(cs.getSpanId());
            this.hasSpanId = true;
        }
    }

    private boolean updateSpanPositions(CandidateSpan candidateSpan) throws IOException {
        int minPos = 0;
        int maxPos = 0;
        boolean isStart = true;
        boolean isClassFound = false;
        candidateSpan.getPayloads().clear();
        for (byte[] payload : this.firstSpans.getPayload()) {
            if (!this.matchTemporaryClass && payload.length == 10 || this.matchTemporaryClass && payload.length == 11) {
                if (payload[0] == 0) {
                    if (this.classNumbers.contains(payload[9])) {
                        isClassFound = true;
                        int classStart = KrillByte.byte2int(payload, 1);
                        int classEnd = KrillByte.byte2int(payload, 5);
                        if (isStart || classStart < minPos) {
                            minPos = classStart;
                            isStart = false;
                        }
                        if (classEnd > maxPos) {
                            maxPos = classEnd;
                        }
                    }
                    if (this.removeTemporaryClasses) {
                        continue;
                    }
                }
            } else if ((payload[0] & 0x40) != 0) continue;
            if (this.removeTemporaryClasses && payload.length == 11) continue;
            candidateSpan.getPayloads().add((byte[])payload.clone());
        }
        if (isClassFound) {
            candidateSpan.start = minPos;
            candidateSpan.end = maxPos;
        }
        return isClassFound;
    }

    @Override
    public boolean skipTo(int target) throws IOException {
        if (this.candidates.size() > 0) {
            CandidateSpan cs;
            while ((cs = this.candidates.poll()) != null) {
                if (cs.getDoc() != target) continue;
                return this.next();
            }
        }
        if (this.firstSpans.doc() == target || this.firstSpans.doc() > target) {
            return this.next();
        }
        if (this.firstSpans.doc() < target && this.firstSpans.skipTo(target)) {
            return this.next();
        }
        return false;
    }

    @Override
    public String toString() {
        return this.getClass().getName() + "(" + this.query.toString() + ")@" + this.doc() + ":" + this.start() + "-" + this.end();
    }

    @Override
    public long cost() {
        return this.firstSpans.cost();
    }
}

