/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import java.util.ArrayList;
import java.util.List;
import java.util.Stack;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Location;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.Sequence;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.StringValue;

public abstract class AbsorptionFeed
extends ItemFeed {
    Stack<PendingItem> valuesUnderConstructionStack = new Stack();
    List<Sequence> valuesReadyToBeOutput = new ArrayList<Sequence>(5);

    public AbsorptionFeed(Feed result, XPathContext context) {
        super(result, context);
    }

    @Override
    public final Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        PendingItem item = this.makePendingItem(this.valuesReadyToBeOutput.size(), node);
        this.valuesUnderConstructionStack.push(item);
        this.valuesReadyToBeOutput.add(StringValue.EMPTY_STRING);
        return item.getGatherer();
    }

    protected abstract PendingItem makePendingItem(int var1, FleetingParentNode var2) throws XPathException;

    @Override
    public final void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            PendingItem item = this.valuesUnderConstructionStack.pop();
            int seq = item.getSequenceNr();
            this.valuesReadyToBeOutput.set(seq, item.deliver());
            if (this.valuesUnderConstructionStack.isEmpty()) {
                for (Sequence val : this.valuesReadyToBeOutput) {
                    AbsorptionFeed.processItems(val.iterate(), this.getResult());
                }
                this.valuesReadyToBeOutput.clear();
            }
        }
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.hasFailed()) {
            Sequence<?> value = this.processGroundedItem(item);
            if (!this.hasFailed()) {
                if (this.valuesUnderConstructionStack.isEmpty()) {
                    AbsorptionFeed.processItems(value.iterate(), this.getResult());
                } else {
                    this.valuesReadyToBeOutput.add(value);
                }
            }
        }
    }

    protected abstract Sequence<?> processGroundedItem(Item var1) throws XPathException;

    @Override
    public void setHasFailed() {
        if (!this.valuesUnderConstructionStack.isEmpty()) {
            PendingItem item = this.valuesUnderConstructionStack.peek();
            item.rollback();
        }
        super.setHasFailed();
    }

    public static abstract class PendingItem {
        int sequenceNr;

        public PendingItem(int sequenceNr) {
            this.sequenceNr = sequenceNr;
        }

        public int getSequenceNr() {
            return this.sequenceNr;
        }

        public abstract Receiver getGatherer() throws XPathException;

        public abstract Sequence<?> deliver() throws XPathException;

        public abstract void rollback();
    }
}

