/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.CodepointCollator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.Whitespace;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public class TokenMatchOperand
extends Characteristic<IntSet> {
    Expression exp;

    public TokenMatchOperand(Expression exp) {
        this.exp = exp;
    }

    @Override
    public IntSet evaluate(XPathContext context) throws XPathException {
        SequenceIterator<?> iter = this.exp.iterate(context);
        IntHashSet keys = new IntHashSet();
        CodepointCollator collator = CodepointCollator.getInstance();
        iter.forEachOrFail(item -> {
            Whitespace.Tokenizer seq = new Whitespace.Tokenizer(item.getStringValueCS());
            seq.forEach(token -> keys.add(collator.getCollationKey(token.getStringValueCS()).hashCode()));
        });
        return keys;
    }

    public int hashCode() {
        return this.exp.hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof TokenMatchOperand && this.exp.isEqual(((TokenMatchOperand)obj).exp);
    }

    public String toString() {
        return this.exp.toString();
    }
}

