/*
 * Decompiled with CFR 0.152.
 */
package chipmunk.segmenter.cmd;

import chipmunk.segmenter.SegmentationDataReader;
import chipmunk.segmenter.Segmenter;
import chipmunk.segmenter.SegmenterOptions;
import chipmunk.segmenter.TwoPhaseSegmenter;
import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import java.io.IOException;
import java.util.Iterator;
import marmot.util.FileUtils;

public class Segment {
    private static final String INPUT_FILE = "input-file";
    private static final String MODEL_FILE = "model-file";
    private static final String OUTPUT_FILE = "output-file";

    public static void main(String[] args2) throws JSAPException, IOException {
        JSAP jsap = new JSAP();
        FlaggedOption opt = new FlaggedOption(INPUT_FILE).setRequired(true).setLongFlag(INPUT_FILE);
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption(OUTPUT_FILE).setRequired(true).setLongFlag(OUTPUT_FILE);
        jsap.registerParameter((Parameter)opt);
        opt = new FlaggedOption(MODEL_FILE).setRequired(true).setLongFlag(MODEL_FILE);
        jsap.registerParameter((Parameter)opt);
        SegmenterOptions options = new SegmenterOptions();
        options.registerOptions(jsap);
        JSAPResult config = jsap.parse(args2);
        if (!config.success()) {
            Iterator errs = config.getErrorMessageIterator();
            while (errs.hasNext()) {
                System.err.println("Error: " + errs.next());
            }
            System.err.println("Usage: ");
            System.err.println(jsap.getUsage());
            System.err.println(jsap.getHelp());
            System.err.println();
            System.exit(1);
        }
        options.setOptions(config);
        Segmenter segmenter = (Segmenter)FileUtils.loadFromFile(config.getString(MODEL_FILE));
        segmenter = new TwoPhaseSegmenter(segmenter);
        SegmentationDataReader reader = new SegmentationDataReader(config.getString(INPUT_FILE), options.getString("lang"), options.getInt("tag-level"));
        segmenter.segmentToFile(config.getString(OUTPUT_FILE), reader);
    }
}

