/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.TransmissionAdjunct;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchMaker;
import com.saxonica.ee.stream.watch.WatchManager;
import java.util.ArrayList;
import java.util.List;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.arrays.SquareArrayConstructor;
import net.sf.saxon.om.GroundedValue;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.SequenceExtent;

public class ArrayBlockAdjunct
extends TransmissionAdjunct
implements FeedMaker {
    private int consumingArg = -1;

    @Override
    public WatchMaker getWatchMaker(boolean forGrouping) throws XPathException {
        this.consumingArg = ArrayBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return super.getWatchMaker(forGrouping);
    }

    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        this.consumingArg = ArrayBlockAdjunct.findConsumingArg(this.getExpression(), this.consumingArg);
        return new SquareArrayFeed((SquareArrayConstructor)this.getExpression(), this.consumingArg, out, context);
    }

    private static class SquareArrayFeed
    extends ItemFeed {
        int consumingArg;
        List<GroundedValue> members;
        List<Item> consumingMember = new ArrayList<Item>();

        public SquareArrayFeed(SquareArrayConstructor exp, int arg, ItemFeed result, XPathContext context) {
            super(exp, result, context);
            this.consumingArg = arg;
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            SquareArrayConstructor block = (SquareArrayConstructor)this.getExpression();
            this.members = new ArrayList<GroundedValue>();
            for (int i = 0; i < this.consumingArg; ++i) {
                Expression child = block.getOperanda().getOperand(i).getChildExpression();
                SequenceExtent.Of<Item> member = SequenceExtent.from(child.iterate(this.getContext()));
                this.members.add(member);
            }
        }

        @Override
        public void append(Item item) throws XPathException {
            this.consumingMember.add(item);
        }

        @Override
        public void close() throws XPathException {
            this.members.add(SequenceExtent.makeSequenceExtent(this.consumingMember));
            SquareArrayConstructor block = (SquareArrayConstructor)this.getExpression();
            Outputter result = this.getNextOutputter();
            for (int i = this.consumingArg + 1; i < block.getOperanda().getNumberOfOperands(); ++i) {
                Expression child = block.getOperanda().getOperand(i).getChildExpression();
                SequenceExtent.Of<Item> member = SequenceExtent.from(child.iterate(this.getContext()));
                this.members.add(member);
            }
            SimpleArrayItem resultArray = new SimpleArrayItem(this.members);
            result.append(resultArray);
            result.close();
        }
    }
}

