/*
 * Decompiled with CFR 0.152.
 */
package opennlp.tools.doccat;

import java.io.IOException;
import opennlp.tools.doccat.DoccatEvaluationMonitor;
import opennlp.tools.doccat.DoccatFactory;
import opennlp.tools.doccat.DoccatModel;
import opennlp.tools.doccat.DocumentCategorizerEvaluator;
import opennlp.tools.doccat.DocumentCategorizerME;
import opennlp.tools.doccat.DocumentSample;
import opennlp.tools.util.ObjectStream;
import opennlp.tools.util.TrainingParameters;
import opennlp.tools.util.eval.CrossValidationPartitioner;
import opennlp.tools.util.eval.Mean;

public class DoccatCrossValidator {
    private final String languageCode;
    private final TrainingParameters params;
    private final Mean documentAccuracy = new Mean();
    private final DoccatEvaluationMonitor[] listeners;
    private final DoccatFactory factory;

    public DoccatCrossValidator(String languageCode, TrainingParameters mlParams, DoccatFactory factory, DoccatEvaluationMonitor ... listeners) {
        this.languageCode = languageCode;
        this.params = mlParams;
        this.listeners = listeners;
        this.factory = factory;
    }

    public void evaluate(ObjectStream<DocumentSample> samples, int nFolds) throws IOException {
        CrossValidationPartitioner<DocumentSample> partitioner = new CrossValidationPartitioner<DocumentSample>(samples, nFolds);
        while (partitioner.hasNext()) {
            CrossValidationPartitioner.TrainingSampleStream<DocumentSample> trainingSampleStream = partitioner.next();
            DoccatModel model = DocumentCategorizerME.train(this.languageCode, trainingSampleStream, this.params, this.factory);
            DocumentCategorizerEvaluator evaluator = new DocumentCategorizerEvaluator(new DocumentCategorizerME(model), this.listeners);
            evaluator.evaluate(trainingSampleStream.getTestSampleStream());
            this.documentAccuracy.add(evaluator.getAccuracy(), evaluator.getDocumentCount());
        }
    }

    public double getDocumentAccuracy() {
        return this.documentAccuracy.mean();
    }

    public long getDocumentCount() {
        return this.documentAccuracy.count();
    }
}

