/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.StreamingAdjunct;
import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.Configuration;
import net.sf.saxon.Controller;
import net.sf.saxon.event.ComplexContentOutputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.Copy;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NameOfNode;
import net.sf.saxon.om.NamespaceBinding;
import net.sf.saxon.om.NoElementsSpaceStrippingRule;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;
import net.sf.saxon.type.ValidationException;

public class CopyAdjunct
extends StreamingAdjunct
implements FeedMaker {
    @Override
    public ItemFeed makeItemFeed(WatchManager watchManager, ItemFeed out, XPathContext context) throws XPathException {
        return new CopyFeed((Copy)this.getExpression(), out, context);
    }

    private static class CopyFeed
    extends ComplexNodeEventFeed {
        XPathContext context;
        int nodeKind;

        public CopyFeed(Copy expression, ItemFeed result, XPathContext context) {
            super(expression, result, context);
        }

        @Override
        protected void processLeft(XPathContext context) throws XPathException {
            Item item = context.getContextItem();
            Copy expression = (Copy)this.getExpression();
            if (item instanceof FleetingParentNode) {
                FleetingParentNode node = (FleetingParentNode)item;
                this.nodeKind = node.getNodeKind();
                switch (this.nodeKind) {
                    case 9: {
                        if (!expression.isPreservingTypes()) {
                            Controller controller = context.getController();
                            Configuration config = controller.getConfiguration();
                            ParseOptions options = expression.getValidationOptions().withSpaceStrippingRule(NoElementsSpaceStrippingRule.getInstance());
                            Receiver val = config.getDocumentValidator(this.next, node.getBaseURI(), options, expression.getLocation());
                            this.next = new ComplexContentOutputter(val);
                        }
                        this.next.startDocument(0);
                        break;
                    }
                    case 1: {
                        int properties;
                        NodeName elemName = NameOfNode.makeName(node);
                        Enum typeCode = expression.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
                        int n = properties = expression.isBequeathNamespacesToChildren() ? 0 : 128;
                        if (!expression.isPreservingTypes()) {
                            Controller controller = context.getController();
                            assert (controller != null);
                            ParseOptions options = expression.getValidationOptions().withTopLevelElement(elemName.getStructuredQName());
                            try {
                                Receiver val = context.getConfiguration().getElementValidator(this.next, options, expression.getLocation());
                                this.next = new ComplexContentOutputter(val);
                            }
                            catch (ValidationException e) {
                                this.dynamicError(e);
                            }
                        }
                        if (this.next.getSystemId() == null) {
                            this.next.setSystemId(node.getBaseURI());
                        }
                        this.next.startElement(elemName, (SchemaType)((Object)typeCode), expression.getLocation(), properties);
                        if (expression.isCopyNamespaces()) {
                            this.next.namespaces(node.getAllNamespaces(), 64);
                            break;
                        }
                        NamespaceBinding ns = elemName.getNamespaceBinding();
                        if (ns.isDefaultUndeclaration()) break;
                        this.next.namespace(ns.getPrefix(), ns.getNamespaceUri(), 0);
                        break;
                    }
                    default: {
                        throw new UnsupportedOperationException();
                    }
                }
            }
        }

        @Override
        protected void processRight(XPathContext context) throws XPathException {
            try {
                if (this.nodeKind == 9) {
                    this.next.endDocument();
                } else if (this.nodeKind == 1) {
                    this.next.endElement();
                }
            }
            catch (XPathException e) {
                this.dynamicError(e);
            }
        }

        @Override
        public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
            return null;
        }
    }
}

