/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.xsltextn.style;

import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.om.AttributeCollection;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.style.Compilation;
import net.sf.saxon.style.ComponentDeclaration;
import net.sf.saxon.style.ExpressionContext;
import net.sf.saxon.style.PrincipalStylesheetModule;
import net.sf.saxon.style.StyleElement;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.type.ItemType;
import net.sf.saxon.value.SequenceType;

public class SaxonTypeAlias
extends StyleElement {
    private StructuredQName typeAlias;
    private boolean resolved = false;

    @Override
    public void prepareAttributes() throws XPathException {
        if (this.typeAlias != null) {
            return;
        }
        String typeAtt = null;
        AttributeCollection atts = this.getAttributeList();
        block8: for (int a = 0; a < atts.getLength(); ++a) {
            String f;
            switch (f = atts.getQName(a)) {
                case "name": {
                    this.typeAlias = this.makeQName(atts.getValue(a));
                    continue block8;
                }
                case "type": {
                    typeAtt = atts.getValue(a);
                    continue block8;
                }
                default: {
                    this.checkUnknownAttribute(atts.getNodeName(a));
                }
            }
        }
        if (this.typeAlias == null) {
            this.reportAbsence("name");
        }
        if (typeAtt == null) {
            this.reportAbsence("type");
        }
    }

    @Override
    public StructuredQName getObjectName() {
        if (this.typeAlias == null) {
            try {
                this.prepareAttributes();
            }
            catch (XPathException e) {
                return new StructuredQName("saxon", "http://saxon.sf.net/", "error-name");
            }
        }
        return this.typeAlias;
    }

    public void indexTypeAlias(ComponentDeclaration decl, PrincipalStylesheetModule top) throws XPathException {
        this.prepareAttributes();
        top.getTypeAliasManager().processDeclaration(decl);
    }

    @Override
    public void validate(ComponentDeclaration decl) throws XPathException {
        this.checkEmpty();
        this.checkTopLevel("XTSE0010", false);
        this.getConfiguration().checkLicensedFeature(8, "saxon:type-alias", this.getPackageData().getLocalLicenseId());
    }

    public ItemType tryToResolve() throws XPathException {
        TypeAliasContext env = new TypeAliasContext();
        this.resolved = true;
        ItemType type = this.makeItemType(env);
        return this.resolved ? type : null;
    }

    private void markUnresolved() {
        this.resolved = false;
    }

    private ItemType makeItemType(StaticContext env) throws XPathException {
        try {
            SequenceType st;
            XPathParser parser = this.getConfiguration().newExpressionParser("XP", false, 31);
            parser.setLanguage(0, 31);
            QNameParser qp = new QNameParser(env.getNamespaceResolver());
            qp.setAcceptEQName(true);
            qp.setDefaultNamespace("");
            qp.setErrorOnBadSyntax("XPST0003");
            qp.setErrorOnUnresolvedPrefix("XPST0081");
            parser.setQNameParser(qp);
            String typeAtt = this.getAttributeValue("type");
            if (typeAtt == null) {
                this.reportAbsence("type");
                typeAtt = "item()";
            }
            if ((st = parser.parseExtendedSequenceType(typeAtt, env)).getCardinality() != 16384) {
                this.compileError("Item type must not include an occurrence indicator");
            }
            return st.getPrimaryType();
        }
        catch (XPathException err) {
            this.compileError(err);
            return AnyItemType.getInstance();
        }
    }

    @Override
    public Expression compile(Compilation exec, ComponentDeclaration decl) throws XPathException {
        return null;
    }

    private class TypeAliasContext
    extends ExpressionContext {
        public TypeAliasContext() {
            super(SaxonTypeAlias.this, new StructuredQName("", "", "type"));
        }

        @Override
        public ItemType resolveTypeAlias(StructuredQName typeName) {
            ItemType resolved = super.resolveTypeAlias(typeName);
            if (resolved == null) {
                SaxonTypeAlias.this.markUnresolved();
                return AnyItemType.getInstance();
            }
            return resolved;
        }
    }
}

