/*
 * Decompiled with CFR 0.152.
 */
package marmot.thirdparty.aramorph;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Pattern;
import marmot.thirdparty.aramorph.DictionaryEntry;
import marmot.thirdparty.aramorph.DictionaryHandler;
import marmot.thirdparty.aramorph.Solution;

public class AraMorph {
    private static DictionaryHandler dict = null;
    private static final Pattern arabic_word_pattern_ = Pattern.compile("([\u067e\u0686\u0698\u06af\u0621-\u063a\u0641-\u0652])+");

    public AraMorph() {
        dict = new DictionaryHandler();
    }

    public char romanizeChar(char c) {
        return switch (c) {
            case '\u0621' -> '\'';
            case '\u0622' -> '|';
            case '\u0623' -> '>';
            case '\u0624' -> '&';
            case '\u0625' -> '<';
            case '\u0626' -> '}';
            case '\u0627' -> 'A';
            case '\u0628' -> 'b';
            case '\u0629' -> 'p';
            case '\u062a' -> 't';
            case '\u062b' -> 'v';
            case '\u062c' -> 'j';
            case '\u062d' -> 'H';
            case '\u062e' -> 'x';
            case '\u062f' -> 'd';
            case '\u0630' -> '*';
            case '\u0631' -> 'r';
            case '\u0632' -> 'z';
            case '\u0633' -> 's';
            case '\u0634' -> '$';
            case '\u0635' -> 'S';
            case '\u0636' -> 'D';
            case '\u0637' -> 'T';
            case '\u0638' -> 'Z';
            case '\u0639' -> 'E';
            case '\u063a' -> 'g';
            case '\u0640' -> '_';
            case '\u0641' -> 'f';
            case '\u0642' -> 'q';
            case '\u0643' -> 'k';
            case '\u0644' -> 'l';
            case '\u0645' -> 'm';
            case '\u0646' -> 'n';
            case '\u0647' -> 'h';
            case '\u0648' -> 'w';
            case '\u0649' -> 'Y';
            case '\u064a' -> 'y';
            case '\u064b' -> 'F';
            case '\u064c' -> 'N';
            case '\u064d' -> 'K';
            case '\u064e' -> 'a';
            case '\u064f' -> 'u';
            case '\u0650' -> 'i';
            case '\u0651' -> '~';
            case '\u0652' -> 'o';
            case '\u0670' -> '`';
            case '\u0671' -> '{';
            case '\u067e' -> 'P';
            case '\u0686' -> 'J';
            case '\u06a4' -> 'V';
            case '\u06af' -> 'G';
            case '\u0698' -> 'R';
            case '\u060c' -> ',';
            case '\u061b' -> ';';
            case '\u061f' -> '?';
            default -> c;
        };
    }

    public String romanizeWord(String word) {
        StringBuilder sb = new StringBuilder(word.length());
        block3: for (int index = 0; index < word.length(); ++index) {
            char new_c;
            char c = word.charAt(index);
            if (c == (new_c = this.romanizeChar(c))) {
                System.err.println(word);
                continue;
            }
            switch (new_c) {
                case 'F': 
                case 'K': 
                case 'N': 
                case '\\': 
                case '_': 
                case '`': 
                case 'a': 
                case 'i': 
                case 'o': 
                case 'u': 
                case '{': 
                case '~': {
                    continue block3;
                }
                default: {
                    sb.append(new_c);
                }
            }
        }
        return sb.toString();
    }

    public Set<Solution> analyzeToken(String token2) {
        if (!arabic_word_pattern_.matcher(token2).matches()) {
            return null;
        }
        String translitered = this.romanizeWord(token2);
        Set<Solution> solutions = null;
        solutions = this.feedWordSolutions(translitered);
        if (solutions != null) {
            return solutions;
        }
        return solutions;
    }

    private Set<SegmentedWord> segmentWord(String translitered) {
        HashSet<SegmentedWord> segmented = new HashSet<SegmentedWord>();
        int suffix_len = 0;
        for (int prefix_len = 0; prefix_len <= 4 && prefix_len <= translitered.length(); ++prefix_len) {
            String prefix = translitered.substring(0, prefix_len);
            int stem_len = translitered.length() - prefix_len;
            for (suffix_len = 0; stem_len >= 1 && suffix_len <= 6; --stem_len, ++suffix_len) {
                String stem = translitered.substring(prefix_len, prefix_len + stem_len);
                String suffix = translitered.substring(prefix_len + stem_len, prefix_len + stem_len + suffix_len);
                segmented.add(new SegmentedWord(prefix, stem, suffix));
            }
        }
        return segmented;
    }

    private Set<Solution> feedWordSolutions(String translitered) {
        HashSet<Solution> wordSolutions = new HashSet<Solution>();
        Set<SegmentedWord> segments = this.segmentWord(translitered);
        for (SegmentedWord segmentedWord : segments) {
            Collection<DictionaryEntry> suffixes;
            Collection<DictionaryEntry> stems;
            Collection<DictionaryEntry> prefixes = dict.getPrefixIterator(segmentedWord.getPrefix());
            if (prefixes == null || (stems = dict.getStemIterator(segmentedWord.getStem())) == null || (suffixes = dict.getSuffixIterator(segmentedWord.getSuffix())) == null) continue;
            for (DictionaryEntry prefix : prefixes) {
                for (DictionaryEntry stem : stems) {
                    if (!dict.hasAB(prefix.getMorphology(), stem.getMorphology())) continue;
                    for (DictionaryEntry suffix : suffixes) {
                        if (!dict.hasAC(prefix.getMorphology(), suffix.getMorphology()) || !dict.hasBC(stem.getMorphology(), suffix.getMorphology())) continue;
                        wordSolutions.add(new Solution(prefix, stem, suffix));
                    }
                }
            }
        }
        return wordSolutions;
    }

    private class SegmentedWord {
        private String prefix;
        private String stem;
        private String suffix;

        protected SegmentedWord(String prefix, String stem, String suffix) {
            this.prefix = prefix;
            this.stem = stem;
            this.suffix = suffix;
        }

        protected String getPrefix() {
            return this.prefix;
        }

        protected String getStem() {
            return this.stem;
        }

        protected String getSuffix() {
            return this.suffix;
        }
    }
}

