/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph.io;

import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.NoSuchElementException;
import marmot.core.Sequence;
import marmot.morph.Sentence;
import marmot.morph.Word;
import marmot.morph.io.FileOptions;
import marmot.util.ConllLineIterator;
import marmot.util.Converter;
import marmot.util.LineIterator;

public class SentenceReader
implements Iterable<Sequence> {
    private FileOptions options_;

    public SentenceReader(String option_string) {
        this(new FileOptions(option_string));
    }

    public SentenceReader(FileOptions options) {
        this.options_ = options;
    }

    @Override
    public Iterator<Sequence> iterator() {
        return new Iterator<Sequence>(){
            int number_ = 0;
            LineIterator line_iterator_;
            {
                this.line_iterator_ = new ConllLineIterator(SentenceReader.this.options_.getInputStream());
            }

            @Override
            public Sequence next() {
                Object row;
                int form_index = SentenceReader.this.options_.getFormIndex();
                int lemma_index = SentenceReader.this.options_.getLemmaIndex();
                int tag_index = SentenceReader.this.options_.getTagIndex();
                int morph_index = SentenceReader.this.options_.getMorphIndex();
                List<Integer> token_feature_indexes = SentenceReader.this.options_.getTokenFeatureIndex();
                if (!this.hasNext()) {
                    throw new NoSuchElementException();
                }
                LinkedList<Word> tokens = new LinkedList<Word>();
                LinkedList<String> comments = new LinkedList<String>();
                Hashtable<Integer, String> segments = new Hashtable<Integer, String>();
                Hashtable<Integer, String> empty_nodes = new Hashtable<Integer, String>();
                while (this.line_iterator_.hasNext() && !(row = this.line_iterator_.next()).isEmpty()) {
                    String[] splittok;
                    String segline;
                    if (((String)row.get(0)).charAt(0) == '#') {
                        comments.add((String)row.get(0));
                        continue;
                    }
                    if (((String)row.get(0)).charAt(0) == '|') {
                        segline = (String)row.get(0);
                        splittok = segline.split("\\|\\$\\|");
                        segments.put(Integer.parseInt(splittok[1]), splittok[2]);
                        continue;
                    }
                    if (((String)row.get(0)).charAt(0) == '$') {
                        segline = (String)row.get(0);
                        splittok = segline.split("\\$\\|\\$");
                        empty_nodes.put(Integer.parseInt(splittok[1]), splittok[2]);
                        continue;
                    }
                    String word = this.check_index(form_index, "form_index", (List<String>)row, true);
                    String lemma = this.check_index(lemma_index, "lemma_index", (List<String>)row, false);
                    String tag = this.check_index(tag_index, "tag_index", (List<String>)row, false);
                    String morph = this.check_index(morph_index, "morph_index", (List<String>)row, false);
                    LinkedList<String> token_feature_list = null;
                    LinkedList<String> weighted_token_feature_list = null;
                    LinkedList<Double> weighted_token_feature_weight_list = null;
                    for (int token_feature_index : token_feature_indexes) {
                        String[] token_features;
                        if (token_feature_index < 0 || token_feature_index >= row.size()) continue;
                        for (String token_feature : token_features = ((String)row.get(token_feature_index)).split("#")) {
                            int colon_index = token_feature.indexOf(58);
                            Double weight = null;
                            if (colon_index > 0) {
                                try {
                                    weight = Double.parseDouble(token_feature.substring(colon_index + 1));
                                    token_feature = token_feature.substring(0, colon_index);
                                }
                                catch (NumberFormatException e) {
                                    throw new RuntimeException("Cannot parse double. If this wasn't meant to be a float feature then replace the colon: " + token_feature);
                                }
                            }
                            if (weight != null) {
                                if (weighted_token_feature_list == null) {
                                    weighted_token_feature_list = new LinkedList<String>();
                                    weighted_token_feature_weight_list = new LinkedList<Double>();
                                }
                                weighted_token_feature_list.add(token_feature);
                                weighted_token_feature_weight_list.add(weight);
                                continue;
                            }
                            if (token_feature_list == null) {
                                token_feature_list = new LinkedList<String>();
                            }
                            token_feature_list.add(token_feature);
                        }
                    }
                    tokens.add(new Word(word, lemma, tag, morph, Converter.toStringArray(token_feature_list), Converter.toStringArray(weighted_token_feature_list), Converter.toDoubleArray(weighted_token_feature_weight_list)));
                }
                if (tokens.isEmpty()) {
                    System.err.println("Warning: Found empty sentence!");
                }
                this.number_ += tokens.size();
                Sentence sentence = new Sentence(tokens);
                sentence.setComments(comments);
                sentence.setSegments(segments);
                sentence.setEmptyNodes(empty_nodes);
                return sentence;
            }

            private String check_index(int index, String string, List<String> row, boolean check_zero) {
                if (index < 0 && check_zero || index >= row.size()) {
                    RuntimeException e = new RuntimeException(String.format("%s out of range: %d : %s\n", string, index, row));
                    throw e;
                }
                if (index < 0) {
                    return null;
                }
                return row.get(index);
            }

            @Override
            public boolean hasNext() {
                int limit = SentenceReader.this.options_.getLimit();
                if (limit >= 0 && this.number_ > limit) {
                    return false;
                }
                return this.line_iterator_.hasNext();
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }
        };
    }

    public FileOptions getFileOptions() {
        return this.options_;
    }
}

