/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import net.sf.saxon.Configuration;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SingletonIntersectExpression;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.tree.iter.SingletonIterator;
import net.sf.saxon.type.TypeHierarchy;
import net.sf.saxon.value.Cardinality;

public class SingletonIntersectExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        Configuration config = compiler.getConfiguration();
        TypeHierarchy th = config.getTypeHierarchy();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SingletonIntersectExpressionCompiler.visitLineNumber(compiler, ga, expression);
        SingletonIntersectExpression sie = (SingletonIntersectExpression)expression;
        SingletonIntersectExpressionCompiler.visitAnnotation(compiler, "SingletonIntersectionCompiler-Itr");
        SingletonIntersectExpressionCompiler.visitLineNumber(compiler, ga, expression);
        compiler.compileToItem(sie.getLhsExpression());
        LabelInfo end = methodInfo.newLabel("SIEend");
        if (Cardinality.allowsZero(sie.getLhsExpression().getCardinality())) {
            LabelInfo notNull = methodInfo.newLabel("SIEnotNull");
            ga.dup();
            ga.ifNonNull(notNull.label());
            ga.pop();
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
            ga.goTo(end);
            methodInfo.placeLabel(notNull);
        }
        int mVar = methodInfo.allocateLocal(NodeInfo.class);
        ga.checkClass(NodeInfo.class);
        ga.storeLocal(mVar);
        compiler.compileToIterator(sie.getRhsExpression());
        int iterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(iterVar);
        LabelInfo loop = methodInfo.placeNewLabel("SIEloop");
        ga.loadLocal(iterVar);
        ga.invokeInstanceMethod(SequenceIterator.class, "next", new Class[0]);
        ga.dup();
        LabelInfo notNull2 = methodInfo.newLabel("SIEnotNull2");
        ga.ifNonNull(notNull2.label());
        ga.pop();
        ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
        ga.goTo(end);
        methodInfo.placeLabel(notNull2);
        ga.loadLocal(mVar);
        ga.invokeInstanceMethod(NodeInfo.class, "isSameNodeInfo", NodeInfo.class);
        ga.ifFalse(loop);
        ga.loadLocal(mVar);
        ga.invokeStaticMethod(SingletonIterator.class, "makeIterator", Item.class);
        methodInfo.placeLabel(end);
        methodInfo.releaseLocal(mVar);
        methodInfo.releaseLocal(iterVar);
    }
}

