/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode.simtype;

import com.saxonica.ee.bytecode.ExpressionCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.EnumerationFacetSet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.LengthFacet;
import com.saxonica.ee.schema.LengthRangeFacet;
import com.saxonica.ee.schema.MaxLengthFacet;
import com.saxonica.ee.schema.MinLengthFacet;
import com.saxonica.ee.schema.PatternFacet;
import com.saxonica.ee.schema.UserAtomicType;
import com.saxonica.ee.schema.UserSimpleType;
import com.saxonica.ee.schema.WhitespaceFacet;
import java.util.Arrays;
import java.util.List;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.om.AtomicSequence;
import net.sf.saxon.regex.RegularExpression;
import net.sf.saxon.regex.UnicodeString;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.type.StringConverter;
import net.sf.saxon.type.ValidationFailure;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.StringValue;
import net.sf.saxon.value.Whitespace;

public class AtomicTypeValidatorCompiler {
    private UserAtomicType type;

    public AtomicTypeValidatorCompiler(UserAtomicType type) {
        this.type = type;
        assert (type.isCompilable());
    }

    public void compileAtomicValidator(CompilerService compiler, ConversionRules rules) throws CannotCompileException {
        BuiltInAtomicType base = (BuiltInAtomicType)this.type.getBuiltInBaseType();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo mi = compiler.getCurrentMethod();
        if (base.getFingerprint() == 513) {
            int action = this.type.getWhitespaceAction();
            this.compileWhitespaceProcessing(ga, action);
            boolean needUnicode = false;
            boolean needLength = false;
            for (Facet f : this.type.getExtendedFacetList()) {
                if (f instanceof LengthRangeFacet) {
                    needLength = true;
                    continue;
                }
                if (!(f instanceof PatternFacet)) continue;
                needUnicode = true;
            }
            int unicodeLoc = -1;
            int lengthLoc = -1;
            if (needUnicode) {
                unicodeLoc = ga.newLocal(UnicodeString.class);
                ga.loadArg(0);
                ga.invokeStaticMethod(UnicodeString.class, "makeUnicodeString", CharSequence.class);
                ga.storeLocal(unicodeLoc);
            }
            if (needLength) {
                lengthLoc = ga.newLocal(Integer.TYPE);
                if (needUnicode) {
                    ga.loadLocal(unicodeLoc);
                    ga.invokeInstanceMethod(UnicodeString.class, "uLength", new Class[0]);
                    ga.storeLocal(lengthLoc);
                } else {
                    ga.loadArg(0);
                    ga.invokeStaticMethod(StringValue.class, "getStringLength", CharSequence.class);
                    ga.storeLocal(lengthLoc);
                }
            }
            LabelInfo failLabel = mi.newLabel("fail");
            for (Facet f : this.type.getExtendedFacetList()) {
                LabelInfo ok;
                if (f instanceof LengthFacet) {
                    int required = (int)((LengthFacet)f).toLong();
                    ga.loadLocal(lengthLoc);
                    ga.push(required);
                    ok = mi.newLabel("lengthOK");
                    ga.ifICmp(153, ok.label());
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok);
                    continue;
                }
                if (f instanceof MinLengthFacet) {
                    int required = (int)((MinLengthFacet)f).toLong();
                    ga.loadLocal(lengthLoc);
                    ga.push(required);
                    ok = mi.newLabel("minLengthOK");
                    ga.ifICmp(156, ok.label());
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok);
                    continue;
                }
                if (f instanceof MaxLengthFacet) {
                    int required = (int)((MaxLengthFacet)f).toLong();
                    ga.loadLocal(lengthLoc);
                    ga.push(required);
                    ok = mi.newLabel("maxLengthOK");
                    ga.ifICmp(158, ok.label());
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok);
                    continue;
                }
                if (f instanceof PatternFacet) {
                    RegularExpression regex = ((PatternFacet)f).getRegularExpression();
                    ExpressionCompiler.allocateStatic(compiler, regex);
                    ga.loadLocal(unicodeLoc);
                    ga.invokeInstanceMethod(RegularExpression.class, "matches", CharSequence.class);
                    ok = mi.newLabel("patternOK");
                    ga.ifTrue(ok);
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok);
                    continue;
                }
                if (f instanceof EnumerationFacetSet) {
                    List<String> values = ((EnumerationFacetSet)f).getStringValues();
                    Object[] valueArray = values.toArray(new String[0]);
                    Arrays.sort(valueArray);
                    ExpressionCompiler.allocateStatic(compiler, valueArray);
                    ga.loadArg(0);
                    ga.invokeInstanceMethod(CharSequence.class, "toString", new Class[0]);
                    ga.invokeStaticMethod(Arrays.class, "binarySearch", Object[].class, Object.class);
                    LabelInfo ok2 = mi.newLabel("enumOK");
                    ga.ifZCmp(156, ok2.label());
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok2);
                    continue;
                }
                if (f instanceof AssertionFacet) {
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.loadArg(0);
                    ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
                    ExpressionCompiler.allocateStatic(compiler, rules);
                    ga.invokeInstanceMethod(AssertionFacet.class, "testAtomicValue", AtomicValue.class, ConversionRules.class);
                    LabelInfo ok3 = mi.newLabel("assertOK");
                    ga.ifTrue(ok3);
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok3);
                    continue;
                }
                if (f instanceof WhitespaceFacet) continue;
                throw new CannotCompileException(f.getName(), false);
            }
            LabelInfo exit = mi.newLabel("exit");
            ga.pushNull();
            ga.goTo(exit);
            mi.placeLabel(failLabel);
            ga.loadArg(0);
            ga.invokeStaticMethod(StringValue.class, "makeStringValue", CharSequence.class);
            ga.swap();
            ExpressionCompiler.allocateStatic(compiler, this.type);
            ga.swap();
            ga.invokeStaticMethod(UserSimpleType.class, "makeValidationFailure", AtomicSequence.class, SimpleType.class, Facet.class);
            mi.placeLabel(exit);
        } else {
            LabelInfo failLabel = mi.newLabel("fail");
            int action = this.type.getWhitespaceAction();
            this.compileWhitespaceProcessing(ga, action);
            int atomicLoc = ga.newLocal(AtomicValue.class);
            BuiltInAtomicType builtInBase = (BuiltInAtomicType)this.type.getBuiltInBaseType();
            StringConverter converter = (StringConverter)rules.getConverter(BuiltInAtomicType.STRING, builtInBase);
            ExpressionCompiler.allocateStatic(compiler, converter);
            ga.loadArg(0);
            ga.invokeInstanceMethod(StringConverter.class, "convertString", CharSequence.class);
            ga.dup();
            LabelInfo failBasic = mi.newLabel("failBasic");
            ga.ifInstance(ValidationFailure.class, failBasic);
            ga.checkClass(AtomicValue.class);
            ga.storeLocal(atomicLoc);
            for (Facet f : this.type.getExtendedFacetList()) {
                LabelInfo ok;
                if (f instanceof WhitespaceFacet) continue;
                if (f instanceof PatternFacet) {
                    RegularExpression regex = ((PatternFacet)f).getRegularExpression();
                    ExpressionCompiler.allocateStatic(compiler, regex);
                    ga.loadArg(0);
                    ga.invokeInstanceMethod(RegularExpression.class, "matches", CharSequence.class);
                    LabelInfo ok4 = mi.newLabel("patternOK");
                    ga.ifTrue(ok4);
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok4);
                    continue;
                }
                if (f instanceof AssertionFacet) {
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.loadLocal(atomicLoc);
                    ExpressionCompiler.allocateStatic(compiler, rules);
                    ga.invokeInstanceMethod(AssertionFacet.class, "testAtomicValue", AtomicValue.class, ConversionRules.class);
                    ok = mi.newLabel("valueOK");
                    ga.ifTrue(ok);
                    ExpressionCompiler.allocateStatic(compiler, f);
                    ga.goTo(failLabel);
                    mi.placeLabel(ok);
                    continue;
                }
                ExpressionCompiler.allocateStatic(compiler, f);
                ga.loadLocal(atomicLoc);
                ga.invokeInstanceMethod(Facet.class, "testAtomicValue", AtomicValue.class);
                ok = mi.newLabel("valueOK");
                ga.ifTrue(ok);
                ExpressionCompiler.allocateStatic(compiler, f);
                ga.goTo(failLabel);
                mi.placeLabel(ok);
            }
            LabelInfo exit = mi.newLabel("exit");
            ga.pushNull();
            ga.goTo(exit);
            mi.placeLabel(failBasic);
            ga.checkClass(ValidationFailure.class);
            ga.goTo(exit);
            mi.placeLabel(failLabel);
            ga.loadLocal(atomicLoc);
            ga.swap();
            ExpressionCompiler.allocateStatic(compiler, this.type);
            ga.swap();
            ga.invokeStaticMethod(UserSimpleType.class, "makeValidationFailure", AtomicSequence.class, SimpleType.class, Facet.class);
            mi.placeLabel(exit);
        }
    }

    private void compileWhitespaceProcessing(Generator ga, int action) {
        if (action == 2) {
            ga.loadArg(0);
            ga.invokeStaticMethod(Whitespace.class, "collapseWhitespace", CharSequence.class);
            ga.storeArg(0);
        } else if (action == 3) {
            ga.loadArg(0);
            ga.invokeStaticMethod(Whitespace.class, "trim", CharSequence.class);
            ga.storeArg(0);
        } else if (action == 1) {
            ga.loadArg(0);
            ga.invokeStaticMethod(Whitespace.class, "normalizeWhitespace", CharSequence.class);
            ga.storeArg(0);
        }
    }
}

