/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.adjunct;

import com.saxonica.ee.stream.adjunct.InspectionAdjunct;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedMaker;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.ExpressionTool;
import net.sf.saxon.om.Item;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;

public class NotFnStreamer
extends InspectionAdjunct
implements FeedMaker {
    @Override
    public Feed makeItemFeed(WatchManager watchManager, Feed out, XPathContext context) throws XPathException {
        return new NotFnFeed(this.getExpression(), out, context);
    }

    private static class NotFnFeed
    extends ItemFeed {
        int count;
        boolean foundAtomic;
        boolean truth;

        public NotFnFeed(Expression exp, Feed result, XPathContext context) {
            super(exp, result, context);
        }

        @Override
        public void open(Terminator terminator) throws XPathException {
            super.open(terminator);
            this.count = 0;
            this.truth = false;
        }

        @Override
        public void processItem(Item<?> item) throws XPathException {
            if (!this.hasFailed()) {
                try {
                    if (++this.count == 1) {
                        this.truth = ExpressionTool.effectiveBooleanValue(item);
                        this.foundAtomic = item instanceof AtomicValue;
                    } else if (this.foundAtomic) {
                        ExpressionTool.ebvError("a sequence of two or more items starting with an atomic value", this.getExpression());
                    }
                }
                catch (XPathException e) {
                    this.dynamicError(e);
                }
            }
        }

        @Override
        public void close() throws XPathException {
            if (!this.hasFailed()) {
                this.getResult().processItem(BooleanValue.get(!this.truth));
                super.close();
            }
        }
    }
}

