/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToItemCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import net.sf.saxon.expr.AttributeGetter;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.FingerprintedQName;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.tree.tiny.TinyElementImpl;
import net.sf.saxon.value.UntypedAtomicValue;

public class AttributeGetterCompiler
extends ToItemCompiler {
    @Override
    public void compileToPrimitive(CompilerService compiler, Expression expression, Class requiredClass, OnEmpty onEmpty) throws CannotCompileException {
        FingerprintedQName attributeName = ((AttributeGetter)expression).getAttributeName();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AttributeGetterCompiler.visitLineNumber(compiler, ga, expression);
        AttributeGetterCompiler.visitAnnotation(compiler, "AttGetterCompiler - primitive");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
        LabelInfo end = methodInfo.newLabel("endAttGet");
        int requiredChecks = ((AttributeGetter)expression).getRequiredChecks();
        LabelInfo notTiny = methodInfo.newLabel("notTiny");
        ga.dup();
        ga.ifNotInstance(TinyElementImpl.class, notTiny);
        ga.checkClass(TinyElementImpl.class);
        ga.push(attributeName.getFingerprint());
        ga.invokeInstanceMethod(TinyElementImpl.class, "getAttributeValue", Integer.TYPE);
        ga.goTo(end);
        methodInfo.placeLabel(notTiny);
        if ((requiredChecks & 2) != 0) {
            ga.dup();
            LabelInfo isNode = methodInfo.newLabel("isNode");
            ga.ifInstance(NodeInfo.class, isNode);
            compiler.generateDynamicError("The context item for @" + attributeName.getDisplayName() + " is not a node", "XPDY0002", expression.getLocation(), false);
            ga.pop();
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(isNode);
        }
        ga.dup();
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getNodeKind", new Class[0]);
        LabelInfo isElement = methodInfo.newLabel("isElement");
        ga.push(1);
        ga.ifICmp(153, isElement.label());
        ga.pop();
        ga.pushNull();
        ga.goTo(end);
        methodInfo.placeLabel(isElement);
        ga.push(attributeName.getURI());
        ga.push(attributeName.getLocalPart());
        ga.invokeInstanceMethod(NodeInfo.class, "getAttributeValue", String.class, String.class);
        methodInfo.placeLabel(end);
        ga.dup();
        LabelInfo exists = methodInfo.newLabel("exists");
        ga.ifNonNull(exists.label());
        ga.pop();
        onEmpty.generate(ga);
        methodInfo.placeLabel(exists);
    }

    @Override
    public void compileToItem(CompilerService compiler, Expression expression) throws CannotCompileException {
        FingerprintedQName attributeName = ((AttributeGetter)expression).getAttributeName();
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        AttributeGetterCompiler.visitLineNumber(compiler, ga, expression);
        AttributeGetterCompiler.visitAnnotation(compiler, "AttGetterCompiler - item");
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "getContextItem", new Class[0]);
        LabelInfo end = methodInfo.newLabel("endAttGet");
        int requiredChecks = ((AttributeGetter)expression).getRequiredChecks();
        LabelInfo notTiny = methodInfo.newLabel("notTiny");
        ga.dup();
        ga.ifNotInstance(TinyElementImpl.class, notTiny);
        ga.checkClass(TinyElementImpl.class);
        ga.push(attributeName.getFingerprint());
        ga.invokeInstanceMethod(TinyElementImpl.class, "getAttributeValue", Integer.TYPE);
        ga.dup();
        ga.ifNull(end.label());
        ga.newInstance(UntypedAtomicValue.class);
        ga.dupX1();
        ga.swap();
        ga.invokeConstructor(UntypedAtomicValue.class, CharSequence.class);
        ga.goTo(end);
        methodInfo.placeLabel(notTiny);
        if ((requiredChecks & 2) != 0) {
            ga.dup();
            LabelInfo isNode = methodInfo.newLabel("isNode");
            ga.ifInstance(NodeInfo.class, isNode);
            compiler.generateDynamicError("The context item for @" + attributeName.getDisplayName() + " is not a node", "XPDY0002", expression.getLocation(), false);
            ga.pop();
            ga.pushNull();
            ga.goTo(end);
            methodInfo.placeLabel(isNode);
        }
        ga.dup();
        ga.checkClass(NodeInfo.class);
        ga.invokeInstanceMethod(NodeInfo.class, "getNodeKind", new Class[0]);
        LabelInfo isElement = methodInfo.newLabel("isElement");
        ga.push(1);
        ga.ifICmp(153, isElement.label());
        ga.pop();
        ga.pushNull();
        ga.goTo(end);
        methodInfo.placeLabel(isElement);
        ga.push(attributeName.getURI());
        ga.push(attributeName.getLocalPart());
        ga.invokeInstanceMethod(NodeInfo.class, "getAttributeValue", String.class, String.class);
        ga.dup();
        ga.ifNull(end.label());
        ga.newInstance(UntypedAtomicValue.class);
        ga.dupX1();
        ga.swap();
        ga.invokeConstructor(UntypedAtomicValue.class, CharSequence.class);
        ga.goTo(end);
        methodInfo.placeLabel(end);
    }
}

