/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.AtomicComparer;
import net.sf.saxon.expr.sort.SortExpression;
import net.sf.saxon.expr.sort.SortKeyDefinition;
import net.sf.saxon.expr.sort.SortKeyDefinitionList;
import net.sf.saxon.expr.sort.SortKeyEvaluator;
import net.sf.saxon.expr.sort.SortedIterator;
import net.sf.saxon.om.SequenceIterator;

public class SortExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        SortExpression sorter = (SortExpression)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        SortExpressionCompiler.visitAnnotation(compiler, "SortExpressionCompiler");
        SortExpressionCompiler.visitLineNumber(compiler, ga, expression);
        Expression baseExpr = sorter.getBaseExpression();
        compiler.compileToIterator(baseExpr);
        int baseIterVar = methodInfo.allocateLocal(SequenceIterator.class);
        ga.storeLocal(baseIterVar);
        AtomicComparer[] comparators = sorter.getComparators();
        int compsVar = -1;
        if (comparators == null) {
            SortKeyDefinitionList definitions = sorter.getSortKeyDefinitionList();
            compsVar = SortExpressionCompiler.compileSortKeyDefinitions(compiler, definitions);
        }
        compiler.generateGetContext();
        ga.invokeInstanceMethod(XPathContext.class, "newMinorContext", new Class[0]);
        int context2Var = methodInfo.allocateLocal(XPathContext.class);
        ga.storeLocal(context2Var);
        ga.newInstance(Type.getType(SortedIterator.class));
        ga.dup();
        ga.loadLocal(context2Var);
        ga.loadLocal(baseIterVar);
        SortExpressionCompiler.allocateStatic(compiler, sorter);
        if (compsVar == -1) {
            SortExpressionCompiler.allocateStatic(compiler, comparators);
        } else {
            ga.loadLocal(compsVar);
        }
        ga.push(sorter.getSortKeyDefinition(0).isSetContextForSortKey());
        ga.invokeConstructor(SortedIterator.class, XPathContext.class, SequenceIterator.class, SortKeyEvaluator.class, AtomicComparer[].class, Boolean.TYPE);
        methodInfo.releaseLocal(baseIterVar);
        methodInfo.releaseLocal(context2Var);
        methodInfo.releaseLocal(compsVar);
    }

    public static int compileSortKeyDefinitions(CompilerService compiler, SortKeyDefinitionList definitions) {
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        ga.push(definitions.size());
        ga.newArray(Type.getType(AtomicComparer.class));
        int compsVar = methodInfo.allocateLocal(AtomicComparer[].class);
        ga.storeLocal(compsVar);
        for (int s = 0; s < definitions.size(); ++s) {
            ga.loadLocal(compsVar);
            ga.push(s);
            SortKeyDefinition skd = definitions.getSortKeyDefinition(s);
            SortExpressionCompiler.allocateStatic(compiler, skd);
            ga.invokeInstanceMethod(SortKeyDefinition.class, "getFinalComparator", new Class[0]);
            ga.dup();
            LabelInfo nonNullComparator = methodInfo.newLabel("nonNullComparator");
            ga.ifNonNull(nonNullComparator.label());
            ga.pop();
            SortExpressionCompiler.allocateStatic(compiler, skd);
            compiler.generateGetContext();
            ga.invokeInstanceMethod(SortKeyDefinition.class, "makeComparator", XPathContext.class);
            methodInfo.placeLabel(nonNullComparator);
            ga.arrayStore(Type.getType(AtomicComparer.class));
        }
        return compsVar;
    }
}

