/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ComplexNodeEventFeed;
import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.FeedToReceiver;
import net.sf.saxon.Controller;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.event.SequenceReceiver;
import net.sf.saxon.event.TreeReceiver;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.instruct.ElementCreator;
import net.sf.saxon.lib.ParseOptions;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.Untyped;

public class ElementCreatorFeed
extends ComplexNodeEventFeed {
    public ElementCreatorFeed(Expression exp, Feed parentExpressionFeed, XPathContext context) {
        super(exp, new FeedToReceiver(parentExpressionFeed, context), context);
    }

    @Override
    protected void processLeft(XPathContext context) throws XPathException {
        ElementCreatorFeed.generateElementStart(this, context);
    }

    @Override
    protected void processRight(XPathContext context) throws XPathException {
        ElementCreatorFeed.generateElementEnd(this, context);
    }

    protected static void generateElementStart(ComplexNodeEventFeed feed, XPathContext context) throws XPathException {
        ElementCreator instr = (ElementCreator)feed.getExpression();
        try {
            int properties;
            Receiver out;
            NodeName elemName = instr.getElementName(context, null);
            Enum typeCode = instr.getValidationAction() == 3 ? AnyType.getInstance() : Untyped.getInstance();
            Receiver elemOut = out = feed.getReceiver();
            if (!instr.isPreservingTypes()) {
                Controller controller = context.getController();
                assert (controller != null);
                ParseOptions options = new ParseOptions(instr.getValidationOptions());
                options.setTopLevelElement(elemName.getStructuredQName());
                Receiver validator = context.getConfiguration().getElementValidator(out, options, instr.getLocation());
                if (validator != out) {
                    out = new TreeReceiver(validator);
                    context.setReceiver(out);
                }
                elemOut = out;
            }
            if (elemOut.getSystemId() == null) {
                elemOut.setSystemId(instr.getNewBaseURI(context, null));
            }
            int n = properties = instr.isInheritNamespacesToChildren() ? 0 : 128;
            if (elemOut instanceof SequenceReceiver) {
                feed.setReceiver((SequenceReceiver)elemOut);
            } else {
                feed.setReceiver(new TreeReceiver(elemOut));
            }
            elemOut.startElement(elemName, (SchemaType)((Object)typeCode), instr.getLocation(), properties);
            instr.outputNamespaceNodes(context, elemOut, elemName, null);
        }
        catch (XPathException e) {
            e.maybeSetLocation(instr.getLocation());
            e.maybeSetContext(context);
            throw e;
        }
    }

    protected static void generateElementEnd(ComplexNodeEventFeed feed, XPathContext context) throws XPathException {
        try {
            feed.getReceiver().endElement();
        }
        catch (XPathException e) {
            feed.dynamicError(e);
        }
    }

    public String toString() {
        return this.getExpression().toShortString();
    }
}

