/*
 * Decompiled with CFR 0.152.
 */
package experimental.analyzer.simple;

import experimental.analyzer.AnalyzerInstance;
import experimental.analyzer.AnalyzerReading;
import experimental.analyzer.AnalyzerTag;
import experimental.analyzer.simple.FloatDict;
import experimental.analyzer.simple.SimpleAnalyzerInstance;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.logging.Logger;
import marmot.util.Converter;
import marmot.util.Encoder;
import marmot.util.FeatUtil;
import marmot.util.FeatureTable;
import marmot.util.SymbolTable;

public class SimpleAnalyzerModel
implements Serializable {
    private static final long serialVersionUID = 1L;
    private SymbolTable<AnalyzerTag> tag_table_;
    private SymbolTable<String> pos_table_;
    private SymbolTable<String> morph_table_;
    private SymbolTable<Character> char_table_;
    private Set<String> vocab_;
    private List<List<Integer>> tag_to_sub_;
    private static final int feature_bits_ = Encoder.bitsNeeded(Features.values().length - 1);
    private int char_bits_;
    private int sig_bits_;
    private Encoder encoder_;
    private FeatureTable feature_table_;
    private transient Context context_;
    private FloatDict dict_;
    private boolean special_signature_ = true;
    private int max_affix_length_ = 10;
    private boolean use_hash_table_ = false;
    private double[] weights_;
    private long feat_length_;
    private int dict_bits_;

    public void init(Collection<SimpleAnalyzerInstance> instances, String dictfile) {
        this.tag_table_ = new SymbolTable(true);
        this.pos_table_ = new SymbolTable();
        this.morph_table_ = new SymbolTable();
        this.tag_to_sub_ = new ArrayList<List<Integer>>();
        this.char_table_ = new SymbolTable();
        this.vocab_ = new HashSet<String>();
        Logger logger = Logger.getLogger(this.getClass().getName());
        if (dictfile != null && !dictfile.isEmpty()) {
            this.dict_ = FloatDict.fromFile(dictfile);
            this.dict_bits_ = Encoder.bitsNeeded(this.dict_.getDimension());
            logger.info(String.format("read dict with dimension %d and %d entries.", this.dict_.getDimension(), this.dict_.numEntries()));
        }
        for (SimpleAnalyzerInstance instance : instances) {
            this.init(instance, true);
        }
        this.sig_bits_ = Encoder.bitsNeeded(FeatUtil.getMaxSignature(this.special_signature_));
        this.char_bits_ = Encoder.bitsNeeded(this.char_table_.size());
        this.encoder_ = new Encoder(6);
        this.feature_table_ = FeatureTable.StaticMethods.create(this.use_hash_table_);
        for (SimpleAnalyzerInstance instance : instances) {
            this.add_features(instance, true);
        }
        this.feat_length_ = this.feature_table_.size();
        this.weights_ = new double[10000000];
    }

    private void add_features(SimpleAnalyzerInstance instance, boolean insert) {
        if (this.context_ == null) {
            this.context_ = new Context();
        }
        this.context_.insert = insert;
        this.context_.list.clear();
        this.addAffixIndexes(instance.getFormChars());
        this.encoder_.append(Features.signature_feature.ordinal(), feature_bits_);
        this.encoder_.append(instance.getSignature(), this.sig_bits_);
        this.addFeature(true);
        instance.setFeatureIndexes(Converter.toIntArray(this.context_.list));
        this.context_.list.clear();
        FloatDict.Vector vector = instance.getVector();
        if (vector != null) {
            for (int index : vector.getIndexes()) {
                this.encoder_.append(Features.dict_feature.ordinal(), feature_bits_);
                this.encoder_.append(index, this.dict_bits_);
                this.addFeature(true);
            }
            instance.setFloatFeatIndexes(Converter.toIntArray(this.context_.list));
        }
    }

    private void init(SimpleAnalyzerInstance instance, boolean insert) {
        LinkedList<Integer> tag_indexes = new LinkedList<Integer>();
        if (insert) {
            this.vocab_.add(instance.getInstance().getForm());
        }
        for (AnalyzerTag tag : instance.getTags()) {
            int tag_index = this.tag_table_.toIndex(tag, -1, insert);
            if (tag_index < 0) continue;
            tag_indexes.add(tag_index);
            if (this.tag_to_sub_.size() > tag_index || !insert) continue;
            assert (insert);
            assert (this.tag_to_sub_.size() == tag_index);
            int pos_index = this.pos_table_.toIndex(tag.getPosTag(), true);
            int morph_index = this.morph_table_.toIndex(tag.getMorphTag(), true);
            this.tag_to_sub_.add(Arrays.asList(pos_index, morph_index));
        }
        instance.setTagIndexes(tag_indexes);
        AnalyzerInstance a_instance = instance.getInstance();
        String form = a_instance.getForm();
        int signature = FeatUtil.getSignature(form, this.special_signature_);
        instance.setSignature(signature);
        String lower_form = form.toLowerCase();
        short[] form_chars = FeatUtil.getCharIndexes(lower_form, this.char_table_, insert);
        instance.setFormChars(form_chars);
        if (this.dict_ != null) {
            instance.setVector(this.dict_.getVector(form));
        }
    }

    private void addPrefixFeatures(short[] chars) {
        this.encoder_.append(false);
        for (int i = 0; i < Math.min(chars.length, this.max_affix_length_); ++i) {
            short c = chars[i];
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.char_bits_);
            this.addFeature(false);
        }
    }

    private void addSuffixFeatures(short[] chars) {
        this.encoder_.append(true);
        for (int i = chars.length - 1; i >= Math.max(0, chars.length - this.max_affix_length_); --i) {
            short c = chars[i];
            if (c < 0) {
                return;
            }
            this.encoder_.append(c, this.char_bits_);
            this.addFeature(false);
        }
    }

    private void addAffixIndexes(short[] lemma_chars) {
        this.encoder_.append(Features.affix_feature.ordinal(), feature_bits_);
        this.addPrefixFeatures(lemma_chars);
        this.encoder_.reset();
        this.encoder_.append(Features.affix_feature.ordinal(), feature_bits_);
        this.addSuffixFeatures(lemma_chars);
        this.encoder_.reset();
    }

    private void addFeature(boolean reset) {
        int index = this.feature_table_.getFeatureIndex(this.encoder_, this.context_.insert);
        if (index >= 0) {
            this.context_.list.add(index);
        }
        if (reset) {
            this.encoder_.reset();
        }
    }

    public double[] getWeights() {
        return this.weights_;
    }

    public void setWeights(double[] weights) {
        this.weights_ = weights;
    }

    public int getNumTags() {
        return this.tag_table_.size();
    }

    private void updateScore(SimpleAnalyzerInstance instance, double[] scores, double[] updates) {
        for (int tag_index = 0; tag_index < this.getNumTags(); ++tag_index) {
            for (int feat_index : instance.getFeatIndexes()) {
                this.updateScores(feat_index, scores, updates, tag_index, 1.0);
            }
            int[] float_feat_indexes = instance.getFloatFeatIndexes();
            if (float_feat_indexes == null) continue;
            double[] values2 = instance.getFloatValues();
            for (int i = 0; i < float_feat_indexes.length; ++i) {
                double value = values2[i];
                this.updateScores(float_feat_indexes[i], scores, updates, tag_index, value);
            }
        }
    }

    private void updateScores(int feat_index, double[] scores, double[] updates, int tag_index, double value) {
        List<Integer> sub_indexes = this.tag_to_sub_.get(tag_index);
        long pos_index = sub_indexes.get(0).intValue();
        long index = (long)feat_index + this.feat_length_ * pos_index;
        this.updateScore(index, scores, updates, tag_index, value);
        long morph_index = sub_indexes.get(1).intValue();
        index = (long)feat_index + this.feat_length_ * (morph_index + (long)this.pos_table_.size());
        this.updateScore(index, scores, updates, tag_index, value);
        index = (long)feat_index + this.feat_length_ * ((long)tag_index + (long)this.pos_table_.size() + (long)this.morph_table_.size());
        this.updateScore(index, scores, updates, tag_index, value);
    }

    private void updateScore(long index, double[] scores, double[] updates, int tag_index, double value) {
        int int_index = (int)(index % (long)this.weights_.length);
        if (updates != null) {
            int n = int_index;
            this.weights_[n] = this.weights_[n] + updates[tag_index] * value;
        }
        if (scores != null) {
            int n = tag_index;
            scores[n] = scores[n] + this.weights_[int_index] * value;
        }
    }

    public void score(SimpleAnalyzerInstance instance, double[] scores) {
        Arrays.fill(scores, 0.0);
        this.updateScore(instance, scores, null);
    }

    public void update(SimpleAnalyzerInstance instance, double[] updates) {
        this.updateScore(instance, null, updates);
    }

    public SimpleAnalyzerInstance getInstance(AnalyzerInstance instance) {
        Collection<AnalyzerTag> tags = AnalyzerReading.toTags(instance.getReadings());
        SimpleAnalyzerInstance simple_instance = new SimpleAnalyzerInstance(instance, tags);
        this.init(simple_instance, false);
        this.add_features(simple_instance, false);
        return simple_instance;
    }

    public SymbolTable<AnalyzerTag> getTagTable() {
        return this.tag_table_;
    }

    public boolean isUnknown(AnalyzerInstance instance) {
        return !this.vocab_.contains(instance.getForm());
    }

    private static class Context {
        public List<Integer> list = new ArrayList<Integer>();
        public boolean insert;
    }

    private static enum Features {
        affix_feature,
        signature_feature,
        dict_feature;

    }
}

