/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.sdoc;

import com.saxonica.ee.schema.Assertion;
import com.saxonica.ee.schema.AssertionFacet;
import com.saxonica.ee.schema.Facet;
import com.saxonica.ee.schema.PreprocessFacet;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.sdoc.SaxonPreprocess;
import com.saxonica.ee.schema.sdoc.SchemaElement;
import com.saxonica.ee.schema.sdoc.SimpleTypeDefinition;
import com.saxonica.ee.schema.sdoc.XSDAssert;
import com.saxonica.ee.schema.sdoc.XSDFacet;
import com.saxonica.ee.schema.sdoc.XSDSimpleType;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.transpile.CSharp;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.z.IntHashSet;
import net.sf.saxon.z.IntSet;

public class XSDSimpleTypeRestriction
extends SchemaElement {
    private SimpleTypeDefinition typeDefinition = null;
    private boolean foundBase = false;
    private static final int[] state0terms = new int[]{609, 595, 605, 621, 578, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 277, 278, 279, 610, 606};
    private static final int[] state0targets = new int[]{1, 1, 1, 2, 3, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state1terms = new int[]{609, 595, 605, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277, 278, 279};
    private static final int[] state1targets = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state2terms = new int[]{609, 595, 605, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277, 278, 279};
    private static final int[] state2targets = new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[] state3terms = new int[]{609, 595, 605, 621, 614, 592, 604, 608, 601, 626, 603, 607, 622, 623, 583, 610, 606, 277, 278, 279};
    private static final int[] state3targets = new int[]{1, 1, 1, 2, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1};
    private static final int[][] stateTerms = new int[][]{state0terms, state1terms, state2terms, state3terms};
    private static final int[][] stateTargets = new int[][]{state0targets, state1targets, state2targets, state3targets};

    @Override
    protected void prepareAttributes() throws SchemaException {
        this.typeDefinition = this.getContainingSimpleType();
        AttributeMap atts = this.attributes();
        String[] allowed = new String[]{"base", "id"};
        this.allowAttributes(atts, allowed);
        this.processId();
        String base = atts.getValue(NamespaceUri.NULL, "base");
        boolean bl = this.foundBase = base != null;
        if (this.foundBase) {
            int baseFingerprint;
            try {
                baseFingerprint = this.getFingerprint(base, 0);
            }
            catch (SchemaException err) {
                this.error(err.getMessage());
                return;
            }
            this.checkPermittedType(baseFingerprint, base, "a base type");
            TypeReference ref = new TypeReference(baseFingerprint, this.typeDefinition.getConfiguration(), this);
            this.typeDefinition.setBaseTypeReference(ref);
        }
    }

    @Override
    public void validate(SchemaCompiler compiler) throws SchemaException {
        this.checkContentModel(stateTerms, stateTargets, false);
        boolean foundSimpleType = false;
        for (NodeInfo nodeInfo : this.children()) {
            int fp = nodeInfo.getFingerprint();
            if (fp != 621) continue;
            foundSimpleType = true;
            if (!this.foundBase) continue;
            this.mutuallyExclusiveElementAndAttribute("simpleType", "base");
            return;
        }
        if (!this.foundBase && !foundSimpleType) {
            this.error("A restriction element must either have a 'base' attribute or contain a 'simpleType' definition");
        }
    }

    @Override
    protected boolean isFinalState(int state) {
        return state == 0 || state == 1 || state == 2 || state == 3;
    }

    @Override
    public void postValidate(SchemaCompiler compiler) throws SchemaException {
        IntHashSet facetsSeen = new IntHashSet();
        for (NodeInfo nodeInfo : this.children()) {
            if (this.typeDefinition == null) continue;
            int fp = nodeInfo.getFingerprint();
            switch (fp) {
                case 578: {
                    break;
                }
                case 621: {
                    SimpleTypeDefinition type = ((XSDSimpleType)nodeInfo).getSimpleTypeDefinition();
                    TypeReference ref = new TypeReference(type.getFingerprint(), compiler.getConfiguration(), this);
                    this.typeDefinition.setBaseTypeReference(ref);
                    break;
                }
                case 580: 
                case 584: 
                case 585: {
                    break;
                }
                case 583: {
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("To use xs:assertion, you must set xsdversion=1.1");
                    }
                    Assertion assertion = ((XSDAssert)nodeInfo).getAssertion();
                    AssertionFacet af = new AssertionFacet(assertion);
                    af.setMessage(assertion.getMessage());
                    this.typeDefinition.addFacet(af);
                    break;
                }
                case 278: 
                case 279: 
                case 595: 
                case 601: 
                case 603: 
                case 604: 
                case 605: 
                case 606: 
                case 607: 
                case 608: 
                case 609: 
                case 610: 
                case 622: 
                case 623: 
                case 626: {
                    if (((IntSet)facetsSeen).contains(fp)) {
                        this.error("The " + nodeInfo.getDisplayName() + " facet must not appear more than once");
                    }
                    ((IntSet)facetsSeen).add(fp);
                    CSharp.emitCode("goto case Saxon.Hej.om.StandardNames.XS_PATTERN;");
                }
                case 592: 
                case 614: {
                    Facet facet = ((XSDFacet)nodeInfo).getFacet();
                    if (facet == null) break;
                    this.typeDefinition.addFacet(facet);
                    break;
                }
                case 277: {
                    if (compiler.getLanguageVersion() == 10) {
                        this.error("To use saxon:preprocess, you must set xsdversion=1.1");
                    }
                    Assertion action = ((SaxonPreprocess)nodeInfo).getAction();
                    Assertion reverseAction = ((SaxonPreprocess)nodeInfo).getReverseAction();
                    PreprocessFacet af2 = new PreprocessFacet(action, reverseAction);
                    this.typeDefinition.addFacet(af2);
                    break;
                }
            }
        }
    }
}

