/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.om.FleetingParentNode;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.CardinalityChecker;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.SystemFunctionCall;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.RoleDiagnostic;
import net.sf.saxon.functions.TreatFn;
import net.sf.saxon.om.AttributeMap;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NamespaceMap;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.NodeName;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.str.UnicodeString;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.SchemaType;
import net.sf.saxon.type.SimpleType;
import net.sf.saxon.value.Cardinality;

public class CardinalityCheckingFeed
extends ItemFeed {
    private int level = 0;
    private int count = 0;
    private final int requiredCardinality;
    private final RoleDiagnostic role;

    public CardinalityCheckingFeed(Expression checker, ItemFeed result, XPathContext context) {
        super(checker, result, context);
        if (checker instanceof CardinalityChecker) {
            this.requiredCardinality = ((CardinalityChecker)checker).getRequiredCardinality();
            this.role = ((CardinalityChecker)checker).getRoleLocator();
        } else if (checker.isCallOn(TreatFn.class)) {
            TreatFn fn = (TreatFn)((SystemFunctionCall)checker).getTargetFunction();
            this.requiredCardinality = fn.getRequiredCardinality();
            this.role = fn.makeRoleDiagnostic();
        } else {
            throw new IllegalArgumentException();
        }
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.checkCount();
            return this.getResultFeed().startSelectedParentNode(node, locationId);
        }
        return null;
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
        if (!this.hasFailed()) {
            this.getResultFeed().endSelectedParentNode(locationId);
        }
    }

    @Override
    public void append(Item item) throws XPathException {
        if (!this.hasFailed()) {
            this.checkCount();
            this.getNextOutputter().append(item);
        }
    }

    private void checkCount() throws XPathException {
        if (!this.hasFailed() && this.count <= 2) {
            ++this.count;
            if (this.count == 1 && this.requiredCardinality == 8192) {
                this.typeError("The only value allowed for the " + this.role.getMessage() + " is an empty sequence", this.role.getErrorCode());
            } else if (this.count == 2 && !Cardinality.allowsMany(this.requiredCardinality)) {
                this.typeError("A sequence of more than one item is not allowed as the " + this.role.getMessage(), this.role.getErrorCode());
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.hasFailed()) {
            if (this.count == 0 && !Cardinality.allowsZero(this.requiredCardinality)) {
                this.typeError("An empty sequence is not allowed as the " + this.role.getMessage(), this.role.getErrorCode());
                return;
            }
            this.getNextOutputter().close();
        }
    }

    private void typeError(String message, String errorCode) throws XPathException {
        XPathException e = new XPathException(message, errorCode, this.getExpression().getLocation());
        e.setIsTypeError(this.getExpression() instanceof CardinalityChecker);
        this.dynamicError(e);
    }

    @Override
    public void startDocument(int properties) throws XPathException {
        if (this.level++ == 0) {
            this.checkCount();
        }
        super.startDocument(properties);
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            if (this.level++ == 0) {
                this.checkCount();
            }
            super.startElement(elemName, type, location, properties);
        }
    }

    @Override
    public void startElement(NodeName elemName, SchemaType type, AttributeMap attributes, NamespaceMap namespaces, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            if (this.level++ == 0) {
                this.checkCount();
            }
            super.startElement(elemName, type, attributes, namespaces, location, properties);
        }
    }

    @Override
    public void namespace(String prefix, NamespaceUri namespaceUri, int properties) throws XPathException {
        if (!this.hasFailed()) {
            if (this.level++ == 0) {
                this.checkCount();
            }
            super.namespace(prefix, namespaceUri, properties);
        }
    }

    @Override
    public void attribute(NodeName attName, SimpleType typeCode, String value, Location location, int properties) throws XPathException {
        if (!this.hasFailed()) {
            if (this.level++ == 0) {
                this.checkCount();
            }
            super.attribute(attName, typeCode, value, location, properties);
        }
    }

    @Override
    public void endElement() throws XPathException {
        if (!this.hasFailed()) {
            --this.level;
            super.endElement();
        }
    }

    @Override
    public void endDocument() throws XPathException {
        --this.level;
        super.endDocument();
    }

    @Override
    public void characters(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            this.checkCount();
        }
        super.characters(chars, locationId, properties);
    }

    @Override
    public void processingInstruction(String target, UnicodeString data, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            this.checkCount();
        }
        super.processingInstruction(target, data, locationId, properties);
    }

    @Override
    public void comment(UnicodeString chars, Location locationId, int properties) throws XPathException {
        if (this.level == 0) {
            this.checkCount();
        }
        super.comment(chars, locationId, properties);
    }
}

