/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.option.exslt;

import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.DifferenceIterator;
import net.sf.saxon.expr.FilterIterator;
import net.sf.saxon.expr.IdentityComparison;
import net.sf.saxon.expr.IntersectionIterator;
import net.sf.saxon.expr.ItemFilter;
import net.sf.saxon.expr.ItemMappingIterator;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.sort.GlobalOrderComparer;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.ZeroOrOne;
import net.sf.saxon.trans.XPathException;

public abstract class Sets {
    private Sets() {
    }

    public static SequenceIterator intersection(SequenceIterator p1, SequenceIterator p2) throws XPathException {
        return new IntersectionIterator(p1, p2, GlobalOrderComparer.getInstance());
    }

    public static SequenceIterator difference(SequenceIterator p1, SequenceIterator p2) throws XPathException {
        return new DifferenceIterator(p1, p2, GlobalOrderComparer.getInstance());
    }

    public static boolean hasSameNode(SequenceIterator p1, SequenceIterator p2) throws XPathException {
        IntersectionIterator intersection = new IntersectionIterator(p1, p2, GlobalOrderComparer.getInstance());
        return intersection.next() != null;
    }

    public static SequenceIterator leading(XPathContext context, SequenceIterator ns1, SequenceIterator ns2) throws XPathException {
        NodeInfo first;
        block4: {
            first = null;
            GlobalOrderComparer comparer = GlobalOrderComparer.getInstance();
            while (true) {
                Item item;
                if ((item = ns2.next()) == null) {
                    if (first == null) {
                        return ns1;
                    }
                    break block4;
                }
                if (!(item instanceof NodeInfo)) break;
                NodeInfo node = (NodeInfo)item;
                if (first == null) {
                    first = node;
                    continue;
                }
                if (comparer.compare(node, first) >= 0) continue;
                first = node;
            }
            throw new XPathException("Operand of leading() contains an item that is not a node").withXPathContext(context);
        }
        IdentityComparison filter = new IdentityComparison(new ContextItemExpression(), 38, Literal.makeLiteral(new ZeroOrOne<NodeInfo>(first)));
        return new FilterIterator(ns1, filter, context);
    }

    public static SequenceIterator trailing(XPathContext context, SequenceIterator ns1, SequenceIterator ns2) throws XPathException {
        NodeInfo first;
        block4: {
            first = null;
            GlobalOrderComparer comparer = GlobalOrderComparer.getInstance();
            while (true) {
                Item item;
                if ((item = ns2.next()) == null) {
                    if (first == null) {
                        return ns1;
                    }
                    break block4;
                }
                if (!(item instanceof NodeInfo)) break;
                NodeInfo node = (NodeInfo)item;
                if (first == null) {
                    first = node;
                    continue;
                }
                if (comparer.compare(node, first) >= 0) continue;
                first = node;
            }
            throw new XPathException("Operand of trailing() contains an item that is not a node").withXPathContext(context);
        }
        GlobalOrderComparer comp = GlobalOrderComparer.getInstance();
        NodeInfo firstNode = first;
        return new ItemMappingIterator(ns1, ItemFilter.of(it -> comp.compare((NodeInfo)it, firstNode) > 0));
    }
}

