/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema;

import com.saxonica.config.EnterpriseConfiguration;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupParticle;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SerializableSchemaComponent;
import com.saxonica.ee.schema.TypeReference;
import com.saxonica.ee.schema.UserComplexType;
import java.util.ArrayList;
import java.util.Stack;
import javax.xml.transform.SourceLocator;
import net.sf.saxon.expr.Callable;
import net.sf.saxon.expr.CallableDelegate;
import net.sf.saxon.functions.CallableFunction;
import net.sf.saxon.om.FunctionItem;
import net.sf.saxon.om.NamespaceUri;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.trans.Err;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AnyType;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.ComplexVariety;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaComponent;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.SchemaValidationStatus;
import net.sf.saxon.type.SpecificFunctionType;
import net.sf.saxon.value.AnyURIValue;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.ObjectValue;
import net.sf.saxon.value.StringValue;

public class ModelGroupDefinition
extends ModelGroup
implements SerializableSchemaComponent {
    private StructuredQName modelGroupName;
    private ModelGroupDefinition redefinedModelGroupDefinition;

    public ModelGroupDefinition(EnterpriseConfiguration config, SourceLocator locator) {
        this.setLocator(locator);
        this.setConfiguration(config);
    }

    public void setRedefinedModelGroupDefinition(ModelGroupDefinition other) {
        this.redefinedModelGroupDefinition = other;
    }

    public void setModelGroupName(StructuredQName nameCode) {
        this.modelGroupName = nameCode;
    }

    public StructuredQName getModelGroupName() {
        return this.modelGroupName;
    }

    public String getName() {
        return this.modelGroupName.getLocalPart();
    }

    public NamespaceUri getTargetNamespace() {
        return this.modelGroupName.getNamespaceUri();
    }

    @Override
    public boolean isEmptiable() throws MissingComponentException {
        for (Particle p : this.getParticles()) {
            if (p.isEmptiable()) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isPointless(ModelGroup container) {
        return this.contentModel.isEmpty() || this.contentModel.size() == 1;
    }

    @Override
    public void lookForCycles(Stack<SchemaComponent> references, SchemaCompiler compiler) throws SchemaException {
        if (references.contains(this)) {
            String err = "The definition of group " + Err.wrap(this.getModelGroupName().getDisplayName()) + " is circular";
            this.contentModel = new ArrayList(20);
            throw new SchemaException(err, this);
        }
        super.lookForCycles(references, compiler);
    }

    @Override
    public boolean validate(SchemaCompiler compiler) throws SchemaException {
        boolean result = true;
        if (!this.isValidationNeeded()) {
            return true;
        }
        this.setValidationStatus(SchemaValidationStatus.VALIDATING);
        if (this.contentModel == null || this.contentModel.isEmpty()) {
            String err = "The group should contain 'all' or 'sequence' or 'choice'";
            compiler.error(err, this);
            this.setValidationStatus(SchemaValidationStatus.INVALID);
            return false;
        }
        if (this.redefinedModelGroupDefinition != null) {
            TypeReference ref = new TypeReference(572, this.getConfiguration(), this);
            ref.setTarget(AnyType.getInstance());
            UserComplexType r = new UserComplexType(compiler.getConfiguration(), this);
            ModelGroupParticle rp = new ModelGroupParticle(compiler.getConfiguration(), null);
            rp.setTarget(this);
            r.setParticle(rp);
            r.setVariety(ComplexVariety.ELEMENT_ONLY);
            r.setBaseTypeReference(ref);
            r.validate(compiler);
            UserComplexType b = new UserComplexType(compiler.getConfiguration(), this.redefinedModelGroupDefinition);
            ModelGroupParticle bp = new ModelGroupParticle(compiler.getConfiguration(), null);
            bp.setTarget(this.redefinedModelGroupDefinition);
            b.setParticle(bp);
            b.setVariety(ComplexVariety.ELEMENT_ONLY);
            b.setBaseTypeReference(ref);
            b.validate(compiler);
            String problem = r.isSubsumedBy(b, compiler);
            if (problem != null) {
                compiler.error("Group " + this.getName() + " is not a valid restriction of the group that it redefines. " + problem, this);
                result = false;
            }
        }
        this.setValidationStatus((result &= super.validate(compiler)) ? SchemaValidationStatus.VALIDATED : SchemaValidationStatus.INVALID);
        return result;
    }

    public boolean isSameGroup(ModelGroupDefinition other) {
        return this == other || this.getModelGroupName().equals(other.getModelGroupName()) && this.hasSameLocation(other);
    }

    @Override
    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        String id = serializer.getId(this, true);
        serializer.startElement("modelGroupDefinition");
        serializer.emitAttribute("id", id);
        serializer.emitAttribute("name", this.getName());
        if (this.getTargetNamespace() != null && !this.getTargetNamespace().isEmpty()) {
            serializer.emitAttribute("targetNamespace", this.getTargetNamespace().toString());
        }
        for (Particle p : this.getParticles()) {
            p.serializeParticle(serializer);
        }
        serializer.endElement();
    }

    @Override
    public String getCompositorName() {
        return "modelGroupDefinition";
    }

    @Override
    public FunctionItem getComponentAsFunction() {
        ModelGroupDefinition thisDefinition = this;
        FunctionItem modelGroupFunction = super.getComponentAsFunction();
        CallableDelegate callable = new CallableDelegate((context, arguments) -> {
            String key;
            switch (key = arguments[0].head().getStringValue()) {
                case "class": {
                    return StringValue.bmp("Model Group Definition");
                }
                case "implementation": {
                    return new ObjectValue<ModelGroupDefinition>(thisDefinition);
                }
                case "name": {
                    return new StringValue(this.getName(), (AtomicType)BuiltInAtomicType.NCNAME);
                }
                case "target namespace": {
                    return new AnyURIValue(this.getTargetNamespace().toUnicodeString());
                }
                case "model group": {
                    return modelGroupFunction;
                }
            }
            return EmptySequence.getInstance();
        });
        return new CallableFunction(1, (Callable)callable, SpecificFunctionType.COMPONENT_FUNCTION_TYPE);
    }
}

