/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.watch;

import com.saxonica.ee.stream.Inversion;
import com.saxonica.ee.stream.Streamability;
import com.saxonica.ee.stream.Sweep;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.feed.NoOpenOrCloseFeed;
import com.saxonica.ee.stream.om.FleetingNode;
import com.saxonica.ee.stream.om.FleetingParentNode;
import com.saxonica.ee.stream.watch.Terminator;
import com.saxonica.ee.stream.watch.Trigger;
import com.saxonica.ee.stream.watch.WatchManager;
import net.sf.saxon.event.Outputter;
import net.sf.saxon.event.Receiver;
import net.sf.saxon.expr.ContextSwitchingExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.elab.PullEvaluator;
import net.sf.saxon.expr.parser.Loc;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.om.SequenceTool;
import net.sf.saxon.s9api.Location;
import net.sf.saxon.trans.UncheckedXPathException;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.iter.ManualIterator;

public class ForEachAction
extends ItemFeed {
    protected XPathContext bodyContext;
    protected final WatchManager watchManager;
    private final Expression action;
    private Inversion inversion;
    protected PullEvaluator actionPuller;
    private final boolean actionIsConsuming;

    public ForEachAction(WatchManager watchManager, Expression expression, ItemFeed result, XPathContext context) {
        super(expression, result, context);
        this.watchManager = watchManager;
        this.action = ((ContextSwitchingExpression)((Object)expression)).getActionExpression();
        boolean bl = this.actionIsConsuming = Streamability.getSweep(this.action) == Sweep.CONSUMING;
        if (this.actionPuller == null && !this.actionIsConsuming) {
            this.actionPuller = this.action.makeElaborator().elaborateForPull();
        }
    }

    public void setInversion(Inversion inversion) {
        this.inversion = inversion;
    }

    protected Inversion getInversion() {
        return this.inversion;
    }

    protected WatchManager getWatchManager() {
        return this.watchManager;
    }

    protected Expression getAction() {
        return this.action;
    }

    protected boolean isActionConsuming() {
        return this.actionIsConsuming;
    }

    protected XPathContext getBodyContext() {
        return this.bodyContext;
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.makeBodyContext();
    }

    protected void makeBodyContext() {
        this.bodyContext = this.getContext().newMinorContext();
        ManualIterator iter = new ManualIterator();
        this.bodyContext.setCurrentIterator(iter);
    }

    @Override
    public Receiver startSelectedParentNode(FleetingParentNode node, Location locationId) throws XPathException {
        if (this.actionIsConsuming) {
            this.startSelectedNode(node);
            NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResultFeed(), this.bodyContext);
            Trigger watch = this.inversion.getWatch(this.watchManager, thisFeed, this.bodyContext);
            watch.setAnchorNode(node);
            this.watchManager.addWatch(watch, true);
            return null;
        }
        ManualIterator iter = (ManualIterator)this.bodyContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
        SequenceIterator stepIter = this.actionPuller.iterate(this.bodyContext);
        ForEachAction.processItems(stepIter, this.getResultFeed());
        return null;
    }

    private void startSelectedNode(FleetingNode node) throws XPathException {
        ManualIterator iter = (ManualIterator)this.bodyContext.getCurrentIterator();
        iter.setContextItem(node);
        iter.incrementPosition();
    }

    @Override
    public void append(Item it) throws XPathException {
        if (this.actionIsConsuming && it instanceof FleetingParentNode) {
            XPathContext cxt = this.bodyContext;
            NoOpenOrCloseFeed thisFeed = new NoOpenOrCloseFeed(this.getResultFeed(), cxt);
            Trigger watch = this.inversion.getWatch(this.watchManager, thisFeed, cxt);
            if (watch.matchesNode((FleetingParentNode)it, cxt)) {
                this.startSelectedNode((FleetingNode)it);
                watch.open(Terminator.getInstance());
                watch.processItem(it);
                watch.close();
                this.endSelectedParentNode(Loc.NONE);
            } else {
                watch.open(Terminator.getInstance());
                this.getWatchManager().addWatch(watch, true);
            }
        } else {
            if (this.actionPuller == null) {
                this.actionPuller = this.action.makeElaborator().elaborateForPull();
            }
            XPathContext context = this.bodyContext;
            ManualIterator iterator = (ManualIterator)context.getCurrentIterator();
            iterator.setContextItem(it);
            iterator.incrementPosition();
            Outputter out = this.getNextOutputter();
            try {
                SequenceTool.supply(this.actionPuller.iterate(context), out::append);
            }
            catch (UncheckedXPathException e) {
                throw e.getXPathException();
            }
        }
    }

    @Override
    public void endSelectedParentNode(Location locationId) throws XPathException {
    }

    @Override
    public void close() throws XPathException {
        super.close();
    }
}

