/*
 * Decompiled with CFR 0.152.
 */
package de.ids_mannheim.korap.response.collector;

import com.fasterxml.jackson.annotation.JsonIgnore;
import de.ids_mannheim.korap.response.MatchCollector;
import de.ids_mannheim.korap.server.Node;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import javax.sql.DataSource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MatchCollectorDB
extends MatchCollector {
    private static final Logger log = LoggerFactory.getLogger(Node.class);
    private String databaseType;
    private final List matchCollector;
    private final int bufferSize;
    private int docCollect;
    private final String resultID;
    private DataSource pool;
    private Connection connection;
    private PreparedStatement prepared;

    public MatchCollectorDB(int bufferSize, String resultID) {
        this.bufferSize = bufferSize;
        this.resultID = resultID;
        this.matchCollector = new ArrayList(bufferSize + 2);
    }

    @Override
    public void add(int UID, int matchCount) {
        if (this.docCollect == this.bufferSize) {
            this.commit();
        }
        this.incrTotalResultDocs(1);
        this.incrTotalResults(matchCount);
        this.matchCollector.add(new int[]{UID, matchCount});
        ++this.docCollect;
    }

    @JsonIgnore
    public void setDatabaseType(String type) {
        this.databaseType = type;
    }

    @JsonIgnore
    public String getDatabaseType() {
        return this.databaseType;
    }

    @JsonIgnore
    public void setDBPool(String type, DataSource ds, Connection conn) throws SQLException {
        this.setDatabaseType(type);
        this.connection = conn;
        this.pool = ds;
    }

    @JsonIgnore
    public void setDBPool(String type, DataSource ds) throws SQLException {
        this.setDatabaseType(type);
        this.pool = ds;
    }

    @Override
    public void commit() {
        if (this.pool == null) {
            return;
        }
        try {
            if (this.connection.isClosed()) {
                this.connection = this.pool.getConnection();
            }
            StringBuilder sb = new StringBuilder();
            sb.append("INSERT INTO ").append(this.resultID).append(" (text_id, match_count) ");
            if (this.getDatabaseType().equals("sqlite")) {
                for (i = 1; i < this.docCollect; ++i) {
                    sb.append("SELECT ?, ? UNION ");
                }
                if (this.docCollect == 1) {
                    sb.append("VALUES (?, ?)");
                } else {
                    sb.append("SELECT ?, ?");
                }
            } else if (this.getDatabaseType().equals("mysql")) {
                sb.append(" VALUES ");
                for (i = 1; i < this.docCollect; ++i) {
                    sb.append("(?,?),");
                }
                sb.append("(?,?)");
            } else {
                log.error("Unsupported Database type");
                return;
            }
            PreparedStatement prep = this.connection.prepareStatement(sb.toString());
            int i = 1;
            ListIterator li = this.matchCollector.listIterator();
            while (li.hasNext()) {
                int[] v = (int[])li.next();
                prep.setInt(i++, v[0]);
                prep.setInt(i++, v[1]);
            }
            prep.addBatch();
            prep.executeBatch();
            this.connection.commit();
        }
        catch (SQLException e) {
            log.error(e.getLocalizedMessage());
        }
        this.matchCollector.clear();
        this.docCollect = 0;
    }

    @Override
    public void close() {
        this.commit();
        try {
            this.connection.close();
        }
        catch (SQLException e) {
            log.warn(e.getLocalizedMessage());
        }
    }

    public void close(boolean close) {
        if (close) {
            this.close();
        }
        this.commit();
    }
}

