/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.bytecode;

import com.saxonica.ee.bytecode.ToIteratorCompiler;
import com.saxonica.ee.bytecode.util.CannotCompileException;
import com.saxonica.ee.bytecode.util.CompilerService;
import com.saxonica.ee.bytecode.util.GeneratedMethodInfo;
import com.saxonica.ee.bytecode.util.Generator;
import com.saxonica.ee.bytecode.util.LabelInfo;
import com.saxonica.ee.bytecode.util.OnEmpty;
import com.saxonica.objectweb.asm.Type;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.RangeExpression;
import net.sf.saxon.expr.RangeIterator;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.tree.iter.EmptyIterator;
import net.sf.saxon.value.IntegerValue;

public class RangeExpressionCompiler
extends ToIteratorCompiler {
    @Override
    public void compileToIterator(CompilerService compiler, Expression expression) throws CannotCompileException {
        RangeExpression range = (RangeExpression)expression;
        Generator ga = compiler.getCurrentGenerator();
        GeneratedMethodInfo methodInfo = compiler.getCurrentMethod();
        RangeExpressionCompiler.visitAnnotation(compiler, "RangeExpressionCompiler-Itr");
        Expression start = range.getLhsExpression();
        Expression end = range.getRhsExpression();
        boolean allLong = true;
        if (!RangeExpressionCompiler.is64bit(start.getIntegerBounds()) || !RangeExpressionCompiler.is64bit(end.getIntegerBounds())) {
            allLong = false;
        }
        if (!allLong && (RangeExpressionCompiler.is32bit(start.getIntegerBounds()) || RangeExpressionCompiler.is32bit(end.getIntegerBounds()))) {
            allLong = true;
        }
        if (allLong) {
            LabelInfo rangeReturn = methodInfo.newLabel("rangeReturn");
            int startVar = ga.newLocal(Type.LONG_TYPE);
            LabelInfo returnEmpty = methodInfo.newLabel("rangeReturnEmpty");
            compiler.compileToPrimitive(start, Long.TYPE, new OnEmpty.UnwindAndJump(returnEmpty));
            ga.storeLocal(startVar);
            int endVar = ga.newLocal(Type.LONG_TYPE);
            compiler.compileToPrimitive(end, Long.TYPE, new OnEmpty.UnwindAndJump(returnEmpty));
            ga.storeLocal(endVar);
            ga.loadLocal(startVar);
            ga.loadLocal(endVar);
            LabelInfo startBeforeEnd = methodInfo.newLabel("startBeforeEnd");
            ga.ifCmp(Type.LONG_TYPE, 158, startBeforeEnd.label());
            ga.invokeStaticMethod(EmptyIterator.class, "getInstance", new Class[0]);
            ga.checkClass(SequenceIterator.class);
            ga.goTo(rangeReturn);
            methodInfo.placeLabel(returnEmpty);
            RangeExpressionCompiler.allocateStatic(compiler, EmptyIterator.getInstance());
            ga.goTo(rangeReturn);
            methodInfo.placeLabel(startBeforeEnd);
            ga.newInstance(Type.getType(RangeIterator.class));
            ga.dup();
            ga.showLongVariable(compiler, "RangeExpression.start", startVar);
            ga.showLongVariable(compiler, "RangeExpression.end", endVar);
            ga.loadLocal(startVar);
            ga.loadLocal(endVar);
            ga.invokeConstructor(RangeIterator.class, Long.TYPE, Long.TYPE);
            methodInfo.placeLabel(rangeReturn);
        } else {
            compiler.compileToItem(start);
            ga.checkClass(IntegerValue.class);
            compiler.compileToItem(end);
            ga.checkClass(IntegerValue.class);
            ga.invokeStaticMethod(RangeIterator.class, "makeRangeIterator", IntegerValue.class, IntegerValue.class);
        }
    }

    private static boolean is32bit(IntegerValue[] bounds) {
        return bounds != null && bounds[0].abs().compareTo(Integer.MAX_VALUE) <= 0 && bounds[1].abs().compareTo(Integer.MAX_VALUE) <= 0;
    }

    private static boolean is64bit(IntegerValue[] bounds) {
        return bounds != null && bounds[0].abs().compareTo(Long.MAX_VALUE) <= 0 && bounds[0].abs().compareTo(Long.MAX_VALUE) <= 0;
    }
}

