/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.optim;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.sf.saxon.expr.ArithmeticExpression;
import net.sf.saxon.expr.AxisExpression;
import net.sf.saxon.expr.ContextItemExpression;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.FilterExpression;
import net.sf.saxon.expr.FirstItemExpression;
import net.sf.saxon.expr.GeneralComparison20;
import net.sf.saxon.expr.Literal;
import net.sf.saxon.expr.LookupExpression;
import net.sf.saxon.expr.RootExpression;
import net.sf.saxon.expr.SlashExpression;
import net.sf.saxon.expr.StaticContext;
import net.sf.saxon.expr.StringLiteral;
import net.sf.saxon.expr.VennExpression;
import net.sf.saxon.expr.parser.Tokenizer;
import net.sf.saxon.expr.parser.XPathParser;
import net.sf.saxon.ma.arrays.SimpleArrayItem;
import net.sf.saxon.ma.map.HashTrieMap;
import net.sf.saxon.om.AxisInfo;
import net.sf.saxon.om.NameChecker;
import net.sf.saxon.om.QNameParser;
import net.sf.saxon.om.StructuredQName;
import net.sf.saxon.pattern.AnyNodeTest;
import net.sf.saxon.pattern.NameTest;
import net.sf.saxon.pattern.NodeKindTest;
import net.sf.saxon.pattern.NodeTest;
import net.sf.saxon.trans.SymbolicName;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.value.EmptySequence;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.StringValue;

public class QuickXPathParser
implements XPathParser.Accelerator {
    private static Map<Long, ExpressionMaker> patterns = new HashMap<Long, ExpressionMaker>();

    @Override
    public Expression parse(Tokenizer t, StaticContext env, String expression, int start, int terminator) {
        if (expression.length() - start > 30 && terminator != 215) {
            return null;
        }
        try {
            t.tokenize(expression, start, -1);
            ArrayList<Integer> tokenTypes = new ArrayList<Integer>();
            ArrayList<String> tokenValues = new ArrayList<String>();
            while (t.currentToken != 0 && t.currentToken != terminator) {
                if (tokenTypes.size() > 6) {
                    return null;
                }
                tokenTypes.add(t.currentToken);
                tokenValues.add(t.currentTokenValue);
                t.next();
                if (t.currentToken != 215) continue;
                t.lookAhead();
            }
            if (t.currentToken != terminator) {
                return null;
            }
            long key = QuickXPathParser.key(tokenTypes);
            ExpressionMaker maker = patterns.get(key);
            if (maker == null) {
                return null;
            }
            Expression result = maker.make(tokenValues, env);
            if (result != null) {
                result.setLocation(env.getContainingLocation());
            }
            return result;
        }
        catch (XPathException e) {
            return null;
        }
    }

    private static long key(List<Integer> tokens) {
        long key = 0L;
        for (int token : tokens) {
            key = (key << 8) + (long)token;
        }
        return key;
    }

    private static long key(Integer ... tokens) {
        long key = 0L;
        Integer[] integerArray = tokens;
        int n = integerArray.length;
        for (int i = 0; i < n; ++i) {
            int token = integerArray[i];
            key = (key << 8) + (long)token;
        }
        return key;
    }

    static StructuredQName verifyQName(String name, StaticContext env) throws XPathException {
        return new QNameParser(env.getNamespaceResolver()).parse(name);
    }

    static StructuredQName verifyElementQName(String name, StaticContext env) throws XPathException {
        QNameParser qNameParser = new QNameParser(env.getNamespaceResolver());
        qNameParser.setDefaultNamespace(env.getDefaultElementNamespace());
        return qNameParser.parse(name);
    }

    static StructuredQName verifyFunctionQName(String name, StaticContext env) throws XPathException {
        QNameParser qNameParser = new QNameParser(env.getNamespaceResolver());
        qNameParser.setDefaultNamespace(env.getDefaultFunctionNamespace());
        return qNameParser.parse(name);
    }

    private static Expression toNumericLiteral(String value) {
        NumericValue number = NumericValue.parseNumber(value);
        if (number.isNaN()) {
            return null;
        }
        return Literal.makeLiteral(number);
    }

    static {
        patterns.put(QuickXPathParser.key(5, 204), (values, env) -> Literal.makeLiteral(EmptySequence.getInstance()));
        patterns.put(QuickXPathParser.key(4, 203), (values, env) -> Literal.makeLiteral(SimpleArrayItem.EMPTY_ARRAY));
        patterns.put(QuickXPathParser.key(205), (values, env) -> new ContextItemExpression());
        patterns.put(QuickXPathParser.key(206), (values, env) -> new AxisExpression(9, AnyNodeTest.getInstance()));
        patterns.put(QuickXPathParser.key(207), (values, env) -> new AxisExpression(3, NodeKindTest.ELEMENT));
        patterns.put(QuickXPathParser.key(202), (values, env) -> StringLiteral.makeLiteral(StringValue.makeStringValue((CharSequence)values.get(0))));
        patterns.put(QuickXPathParser.key(209), (values, env) -> QuickXPathParser.toNumericLiteral((String)values.get(0)));
        patterns.put(QuickXPathParser.key(2), (values, env) -> new RootExpression());
        patterns.put(QuickXPathParser.key(69, 204), (values, env) -> {
            String kind = (String)values.get(0);
            NodeTest test = null;
            switch (kind) {
                case "node": {
                    test = AnyNodeTest.getInstance();
                    break;
                }
                case "element": {
                    test = NodeKindTest.ELEMENT;
                    break;
                }
                case "text": {
                    test = NodeKindTest.TEXT;
                    break;
                }
                case "comment": {
                    test = NodeKindTest.COMMENT;
                    break;
                }
                case "processing-instruction": {
                    test = NodeKindTest.PROCESSING_INSTRUCTION;
                    break;
                }
                default: {
                    return null;
                }
            }
            return new AxisExpression(3, test);
        });
        patterns.put(QuickXPathParser.key(21, 201), (values, env) -> {
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            return env.bindVariable(name);
        });
        patterns.put(QuickXPathParser.key(3, 201), (values, env) -> {
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            return new AxisExpression(2, new NameTest(2, name.getURI(), name.getLocalPart(), env.getConfiguration().getNamePool()));
        });
        patterns.put(QuickXPathParser.key(3, 207), (values, env) -> new AxisExpression(2, NodeKindTest.ATTRIBUTE));
        patterns.put(QuickXPathParser.key(201), (values, env) -> {
            StructuredQName name = QuickXPathParser.verifyElementQName((String)values.get(0), env);
            return new AxisExpression(3, new NameTest(1, name.getURI(), name.getLocalPart(), env.getConfiguration().getNamePool()));
        });
        patterns.put(QuickXPathParser.key(60, 215), (values, env) -> {
            String name = (String)values.get(0);
            if (name.equals("map")) {
                return Literal.makeLiteral(new HashTrieMap());
            }
            if (name.equals("array")) {
                return Literal.makeLiteral(SimpleArrayItem.EMPTY_ARRAY);
            }
            return null;
        });
        patterns.put(QuickXPathParser.key(35, 204), (values, env) -> {
            StructuredQName name = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            ArrayList<String> reasons = new ArrayList<String>();
            return env.getFunctionLibrary().bind(new SymbolicName.F(name, 0), new Expression[0], env, reasons);
        });
        patterns.put(QuickXPathParser.key(35, 205, 204), (values, env) -> {
            StructuredQName name = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            ArrayList<String> reasons = new ArrayList<String>();
            ContextItemExpression cie = new ContextItemExpression();
            cie.setLocation(env.getContainingLocation());
            return env.getFunctionLibrary().bind(new SymbolicName.F(name, 1), new Expression[]{cie}, env, reasons);
        });
        patterns.put(QuickXPathParser.key(35, 201, 204), (values, env) -> {
            StructuredQName fnName = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            StructuredQName elName = QuickXPathParser.verifyElementQName((String)values.get(1), env);
            ArrayList<String> reasons = new ArrayList<String>();
            AxisExpression child = new AxisExpression(3, new NameTest(1, elName.getURI(), elName.getLocalPart(), env.getConfiguration().getNamePool()));
            child.setLocation(env.getContainingLocation());
            return env.getFunctionLibrary().bind(new SymbolicName.F(fnName, 1), new Expression[]{child}, env, reasons);
        });
        patterns.put(QuickXPathParser.key(35, 21, 201, 204), (values, env) -> {
            StructuredQName varName = QuickXPathParser.verifyQName((String)values.get(2), env);
            Expression varRef = env.bindVariable(varName);
            varRef.setLocation(env.getContainingLocation());
            StructuredQName name = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            ArrayList<String> reasons = new ArrayList<String>();
            return env.getFunctionLibrary().bind(new SymbolicName.F(name, 1), new Expression[]{varRef}, env, reasons);
        });
        patterns.put(QuickXPathParser.key(35, 3, 201, 204), (values, env) -> {
            StructuredQName attName = QuickXPathParser.verifyQName((String)values.get(2), env);
            AxisExpression arg = new AxisExpression(2, new NameTest(2, attName.getURI(), attName.getLocalPart(), env.getConfiguration().getNamePool()));
            arg.setLocation(env.getContainingLocation());
            StructuredQName name = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            ArrayList<String> reasons = new ArrayList<String>();
            return env.getFunctionLibrary().bind(new SymbolicName.F(name, 1), new Expression[]{arg}, env, reasons);
        });
        patterns.put(QuickXPathParser.key(35, 202, 204), (values, env) -> {
            Literal arg = StringLiteral.makeLiteral(StringValue.makeStringValue((CharSequence)values.get(1)));
            arg.setLocation(env.getContainingLocation());
            StructuredQName name = QuickXPathParser.verifyFunctionQName((String)values.get(0), env);
            ArrayList<String> reasons = new ArrayList<String>();
            return env.getFunctionLibrary().bind(new SymbolicName.F(name, 1), new Expression[]{arg}, env, reasons);
        });
        patterns.put(QuickXPathParser.key(201, 2, 201), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyElementQName((String)values.get(0), env);
            AxisExpression start = new AxisExpression(3, new NameTest(1, first.getURI(), first.getLocalPart(), env.getConfiguration().getNamePool()));
            start.setLocation(env.getContainingLocation());
            StructuredQName second = QuickXPathParser.verifyElementQName((String)values.get(2), env);
            AxisExpression step = new AxisExpression(3, new NameTest(1, second.getURI(), second.getLocalPart(), env.getConfiguration().getNamePool()));
            step.setLocation(env.getContainingLocation());
            return new SlashExpression(start, step);
        });
        patterns.put(QuickXPathParser.key(201, 1, 201), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyElementQName((String)values.get(0), env);
            AxisExpression one = new AxisExpression(3, new NameTest(1, first.getURI(), first.getLocalPart(), env.getConfiguration().getNamePool()));
            one.setLocation(env.getContainingLocation());
            StructuredQName second = QuickXPathParser.verifyElementQName((String)values.get(2), env);
            AxisExpression two = new AxisExpression(3, new NameTest(1, second.getURI(), second.getLocalPart(), env.getConfiguration().getNamePool()));
            two.setLocation(env.getContainingLocation());
            return new VennExpression(one, 1, two);
        });
        patterns.put(QuickXPathParser.key(201, 2, 3, 201), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyElementQName((String)values.get(0), env);
            AxisExpression start = new AxisExpression(3, new NameTest(1, first.getURI(), first.getLocalPart(), env.getConfiguration().getNamePool()));
            start.setLocation(env.getContainingLocation());
            StructuredQName second = QuickXPathParser.verifyQName((String)values.get(3), env);
            AxisExpression step = new AxisExpression(2, new NameTest(2, second.getURI(), second.getLocalPart(), env.getConfiguration().getNamePool()));
            step.setLocation(env.getContainingLocation());
            return new SlashExpression(start, step);
        });
        patterns.put(QuickXPathParser.key(21, 201, 2, 3, 201), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(first);
            varRef.setLocation(env.getContainingLocation());
            StructuredQName second = QuickXPathParser.verifyQName((String)values.get(4), env);
            AxisExpression step = new AxisExpression(2, new NameTest(2, second.getURI(), second.getLocalPart(), env.getConfiguration().getNamePool()));
            step.setLocation(env.getContainingLocation());
            return new SlashExpression(varRef, step);
        });
        patterns.put(QuickXPathParser.key(21, 201, 4, 209, 203), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(first);
            varRef.setLocation(env.getContainingLocation());
            if (((String)values.get(3)).equals("1")) {
                return FirstItemExpression.makeFirstItemExpression(varRef);
            }
            Expression subscript = QuickXPathParser.toNumericLiteral((String)values.get(3));
            subscript.setLocation(env.getContainingLocation());
            return new FilterExpression(varRef, subscript);
        });
        patterns.put(QuickXPathParser.key(21, 201, 213, 201), (values, env) -> {
            StructuredQName first = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(first);
            varRef.setLocation(env.getContainingLocation());
            if (!NameChecker.isValidNCName((CharSequence)values.get(3))) {
                return null;
            }
            return new LookupExpression(varRef, new StringLiteral((CharSequence)values.get(3)));
        });
        patterns.put(QuickXPathParser.key(21, 201, 6, 202), (values, env) -> {
            if (env.isInBackwardsCompatibleMode()) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(name);
            varRef.setLocation(env.getContainingLocation());
            StringLiteral comparand = new StringLiteral((CharSequence)values.get(3));
            comparand.setLocation(env.getContainingLocation());
            return new GeneralComparison20(varRef, 6, comparand);
        });
        patterns.put(QuickXPathParser.key(21, 201, 22, 202), (values, env) -> {
            if (env.isInBackwardsCompatibleMode()) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(name);
            varRef.setLocation(env.getContainingLocation());
            StringLiteral comparand = new StringLiteral((CharSequence)values.get(3));
            comparand.setLocation(env.getContainingLocation());
            return new GeneralComparison20(varRef, 22, comparand);
        });
        patterns.put(QuickXPathParser.key(21, 201, 6, 209), (values, env) -> {
            if (env.isInBackwardsCompatibleMode()) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(name);
            varRef.setLocation(env.getContainingLocation());
            Expression comparand = QuickXPathParser.toNumericLiteral((String)values.get(3));
            comparand.setLocation(env.getContainingLocation());
            return new GeneralComparison20(varRef, 6, comparand);
        });
        patterns.put(QuickXPathParser.key(21, 201, 22, 209), (values, env) -> {
            if (env.isInBackwardsCompatibleMode()) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(name);
            varRef.setLocation(env.getContainingLocation());
            Expression comparand = QuickXPathParser.toNumericLiteral((String)values.get(3));
            comparand.setLocation(env.getContainingLocation());
            return new GeneralComparison20(varRef, 22, comparand);
        });
        patterns.put(QuickXPathParser.key(21, 201, 15, 209), (values, env) -> {
            if (env.isInBackwardsCompatibleMode()) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyQName((String)values.get(1), env);
            Expression varRef = env.bindVariable(name);
            varRef.setLocation(env.getContainingLocation());
            Expression addend = QuickXPathParser.toNumericLiteral((String)values.get(3));
            addend.setLocation(env.getContainingLocation());
            return new ArithmeticExpression(varRef, 15, addend);
        });
        patterns.put(QuickXPathParser.key(36, 201), (values, env) -> {
            boolean reverse;
            byte axis = AxisInfo.getAxisNumber((String)values.get(0));
            boolean bl = reverse = !AxisInfo.isForwards[axis];
            if (reverse || axis == 2 || axis == 8) {
                return null;
            }
            StructuredQName name = QuickXPathParser.verifyElementQName((String)values.get(1), env);
            return new AxisExpression(axis, new NameTest(1, name.getURI(), name.getLocalPart(), env.getConfiguration().getNamePool()));
        });
    }

    @FunctionalInterface
    private static interface ExpressionMaker {
        public Expression make(List<String> var1, StaticContext var2) throws XPathException;
    }
}

