/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.schema.fsa;

import com.saxonica.ee.schema.AllModelGroup;
import com.saxonica.ee.schema.ChoiceModelGroup;
import com.saxonica.ee.schema.ElementDecl;
import com.saxonica.ee.schema.ModelGroup;
import com.saxonica.ee.schema.ModelGroupDefinition;
import com.saxonica.ee.schema.Particle;
import com.saxonica.ee.schema.SchemaCompiler;
import com.saxonica.ee.schema.SchemaModelSerializer;
import com.saxonica.ee.schema.SequenceModelGroup;
import com.saxonica.ee.schema.Term;
import com.saxonica.ee.schema.UserComplexType;
import com.saxonica.ee.schema.Wildcard;
import com.saxonica.ee.schema.fsa.AutomatonState;
import com.saxonica.ee.schema.fsa.DeterminizedState;
import com.saxonica.ee.schema.fsa.Edge;
import com.saxonica.ee.schema.fsa.NonDeterminizedState;
import com.saxonica.ee.schema.fsa.State;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Stack;
import net.sf.saxon.lib.Logger;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.tree.jiter.MonoIterator;
import net.sf.saxon.type.MissingComponentException;
import net.sf.saxon.type.SchemaException;
import net.sf.saxon.type.ValidationException;
import net.sf.saxon.z.IntIterator;
import net.sf.saxon.z.IntRangeSet;
import net.sf.saxon.z.IntSet;

public class FiniteStateMachine {
    private int statesUsed = 0;
    private AutomatonState initialState;
    private AutomatonState[] states = new AutomatonState[20];
    private Set<TermParticlePair> alphabet = new HashSet<TermParticlePair>(20);
    private Wildcard openContentWildcard = null;
    private boolean openContentInterleaved = false;
    private UserComplexType complexType;

    public FiniteStateMachine(UserComplexType type, boolean determinized) {
        this.complexType = type;
        this.initialState = determinized ? new DeterminizedState(this) : new NonDeterminizedState(this);
    }

    public void allocateStateNumber(AutomatonState state) {
        if (this.statesUsed > this.states.length - 1) {
            this.states = Arrays.copyOf(this.states, this.statesUsed * 2);
        }
        this.states[this.statesUsed] = state;
        state.stateNumber = this.statesUsed++;
    }

    public int getNumberOfStates() {
        return this.statesUsed;
    }

    public AutomatonState getInitialState() {
        return this.initialState;
    }

    public void setInitialState(AutomatonState initialState) {
        this.initialState = initialState;
    }

    public AutomatonState getState(int number) {
        return this.states[number];
    }

    public void setOpenContentWildcard(Wildcard wildcard, boolean interleaved) {
        this.openContentWildcard = wildcard;
        this.openContentInterleaved = interleaved;
    }

    public static NonDeterminizedState compileParticle(SchemaCompiler compiler, Particle particle, NonDeterminizedState endState, UserComplexType subjectType, FiniteStateMachine machine) throws SchemaException, MissingComponentException {
        NonDeterminizedState n = endState;
        int max = particle.getMaxOccurs();
        int min = particle.getMinOccurs();
        if (!(!(particle.getTerm() instanceof ElementDecl) && !(particle.getTerm() instanceof Wildcard) || min <= 1 && max <= 1 || min != max && particle.isVulnerable())) {
            NonDeterminizedState t = new NonDeterminizedState(machine);
            FiniteStateMachine.compileCountingTerm(particle, t, min, max, subjectType, compiler, machine);
            if (min == max) {
                Edge leavingEdge = new Edge();
                leavingEdge.setTerm(Edge.MaxOccursTerm.getInstance());
                leavingEdge.setTargetState(n);
                t.setMaxTransition(leavingEdge);
                t.setFinalState(n.isFinalState());
                machine.alphabet.add(new TermParticlePair(Edge.MaxOccursTerm.getInstance(), Edge.MAX_OCCURS_PARTICLE));
            } else {
                t.addLambdaTransition(n);
            }
            NonDeterminizedState start = FiniteStateMachine.compileTerm(compiler, particle, t, subjectType, machine);
            if (min == 0) {
                start.addLambdaTransition(n);
            }
            return start;
        }
        int[] limits = compiler.getOccurrenceLimits();
        if (max > limits[1]) {
            compiler.warning("maxOccurs value of " + max + " treated as unbounded", subjectType);
            max = -1;
        }
        if (min > limits[0]) {
            compiler.warning("minOccurs value of " + min + " treated as " + limits[0], subjectType);
            min = limits[0];
        }
        if (max == -1) {
            NonDeterminizedState t = new NonDeterminizedState(machine);
            NonDeterminizedState b = FiniteStateMachine.compileTerm(compiler, particle, t, subjectType, machine);
            b.addLambdaTransition(n);
            t.addLambdaTransition(b);
            n = b;
        } else if (!(particle.getTerm() instanceof AllModelGroup)) {
            int count = max - min;
            for (int i = 0; i < count; ++i) {
                NonDeterminizedState b = FiniteStateMachine.compileTerm(compiler, particle, n, subjectType, machine);
                b.addLambdaTransition(endState);
                n = b;
            }
        }
        int count = min;
        for (int i = 0; i < count; ++i) {
            n = FiniteStateMachine.compileTerm(compiler, particle, n, subjectType, machine);
        }
        return n;
    }

    private static NonDeterminizedState compileTerm(SchemaCompiler compiler, Particle particle, NonDeterminizedState endState, UserComplexType subjectType, FiniteStateMachine machine) throws SchemaException, MissingComponentException {
        Term term = particle.getTerm();
        if (term instanceof Wildcard) {
            machine.alphabet.add(new TermParticlePair(term, particle));
            NonDeterminizedState b = new NonDeterminizedState(machine);
            Edge edge = new Edge();
            edge.setTerm(term);
            edge.setParticle(particle);
            edge.setTargetState(endState);
            b.addWildcardTransition(compiler, edge);
            return b;
        }
        if (term instanceof ElementDecl) {
            machine.alphabet.add(new TermParticlePair(term, particle));
            NonDeterminizedState b = new NonDeterminizedState(machine);
            Edge edge = new Edge();
            edge.setTerm(term);
            edge.setParticle(particle);
            edge.setTargetState(endState);
            b.addSpecificTransition(edge, compiler);
            int fp = ((ElementDecl)term).getFingerprint();
            for (ElementDecl elem : ((ElementDecl)term).getSubstitutionGroupMembers()) {
                if (elem.getFingerprint() != fp) {
                    edge = new Edge();
                    edge.setTerm(elem);
                    machine.alphabet.add(new TermParticlePair(elem, particle));
                    edge.setParticle(particle);
                    edge.setTargetState(endState);
                    b.addSpecificTransition(edge, compiler);
                }
                elem.registerComplexTypeUsingThisElement(subjectType);
            }
            return b;
        }
        if (term instanceof ChoiceModelGroup || term instanceof AllModelGroup) {
            NonDeterminizedState b = new NonDeterminizedState(machine);
            for (Particle p : ((ModelGroup)term).getParticles()) {
                NonDeterminizedState c = FiniteStateMachine.compileParticle(compiler, p, endState, subjectType, machine);
                b.addLambdaTransition(c);
            }
            return b;
        }
        if (term instanceof SequenceModelGroup || term instanceof ModelGroupDefinition) {
            NonDeterminizedState n = endState;
            ArrayList<Particle> reversedParticles = new ArrayList<Particle>(10);
            for (Particle p : ((ModelGroup)term).getParticles()) {
                reversedParticles.add(0, p);
            }
            for (Particle p : reversedParticles) {
                n = FiniteStateMachine.compileParticle(compiler, p, n, subjectType, machine);
            }
            return n;
        }
        throw new IllegalStateException("Unknown type of term " + term.getClass());
    }

    private static void compileCountingTerm(Particle particle, NonDeterminizedState countingState, int min, int max, UserComplexType subjectType, SchemaCompiler compiler, FiniteStateMachine machine) throws SchemaException, MissingComponentException {
        Term term = particle.getTerm();
        machine.alphabet.add(new TermParticlePair(term, particle));
        Edge edge = new Edge();
        edge.setTerm(term);
        edge.setParticle(particle);
        edge.setTargetState(countingState);
        countingState.setLimits(min, max);
        if (term instanceof ElementDecl) {
            countingState.addSpecificTransition(edge, compiler);
            int fp = ((ElementDecl)term).getFingerprint();
            for (ElementDecl elem : ((ElementDecl)term).getSubstitutionGroupMembers()) {
                if (elem.getFingerprint() != fp) {
                    machine.alphabet.add(new TermParticlePair(elem, particle));
                    edge = new Edge();
                    edge.setParticle(particle);
                    edge.setTerm(elem);
                    edge.setTargetState(countingState);
                    countingState.addSpecificTransition(edge, compiler);
                }
                elem.registerComplexTypeUsingThisElement(subjectType);
            }
        } else {
            countingState.addWildcardTransition(compiler, edge);
        }
    }

    public void display(Logger err) {
        err.info("Initial state: " + this.initialState.stateNumber);
        for (int i = this.statesUsed - 1; i >= 0; --i) {
            this.states[i].displayState(err);
        }
    }

    public static String subsumesMachine(FiniteStateMachine base, FiniteStateMachine sub, SchemaCompiler compiler) {
        ArrayList<State[]> unprocessed = new ArrayList<State[]>(30);
        ArrayList<State[]> processed = new ArrayList<State[]>(30);
        HashSet<State> finalDerivedStates = new HashSet<State>(30);
        if (sub.initialState.isFinalState() && sub.initialState.getMinOccurs() <= 0) {
            finalDerivedStates.add(sub.initialState);
            if (!base.initialState.isFinalState() || sub.initialState.getMinOccurs() > 0) {
                return "The derived type permits empty content, but the base type does not";
            }
        }
        State[] initialPair = new State[]{base.getInitialState(), sub.getInitialState()};
        unprocessed.add(initialPair);
        while (!unprocessed.isEmpty()) {
            State[] p = (State[])unprocessed.get(0);
            State baseState = p[0];
            State derivedState = p[1];
            Iterator<Edge> derivedEdges = derivedState.getEdges();
            while (derivedEdges.hasNext()) {
                State[] end;
                State newDerivedState;
                Edge derivedEdge = derivedEdges.next();
                try {
                    newDerivedState = derivedEdge.makeTransition(derivedState);
                }
                catch (ValidationException e) {
                    throw new AssertionError((Object)"Invalid derived transition");
                }
                if (newDerivedState.isFinalState()) {
                    finalDerivedStates.add(newDerivedState);
                }
                Edge baseEdge = null;
                if (derivedEdge.getTerm() instanceof ElementDecl) {
                    baseEdge = baseState.getTransition(((ElementDecl)derivedEdge.getTerm()).getFingerprint(), base.complexType);
                    String s = "No match";
                    if (baseEdge != null) {
                        try {
                            s = baseEdge.matches(derivedEdge, compiler);
                        }
                        catch (MissingComponentException e) {
                            return "Cannot prove the restriction is valid, because there are missing schema components. " + e.getMessage();
                        }
                    }
                    if (s != null) {
                        switch (s) {
                            case "No match": {
                                return "The restricted type allows element " + ((ElementDecl)derivedEdge.getTerm()).getDisplayName() + " where the base type does not";
                            }
                            case "Not final": {
                                return "The restricted type allows the content to finish after element " + ((ElementDecl)derivedEdge.getTerm()).getDisplayName() + " where the base type does not";
                            }
                        }
                        return "The definition of element " + ((ElementDecl)derivedEdge.getTerm()).getDisplayName() + " differs between the restricted type and the base type. " + s;
                    }
                } else {
                    Edge[] baseEdges = baseState.getWildcardEdges();
                    boolean foundWildcard = false;
                    String s = null;
                    Edge[] edgeArray = baseEdges;
                    int n = edgeArray.length;
                    for (int i = 0; i < n; ++i) {
                        Edge baseEdge1;
                        baseEdge = baseEdge1 = edgeArray[i];
                        try {
                            s = baseEdge.matches(derivedEdge, compiler);
                        }
                        catch (MissingComponentException e) {
                            return "Cannot prove the restriction is valid, because there are missing schema components. " + e.getMessage();
                        }
                        if (s != null) continue;
                        foundWildcard = true;
                        break;
                    }
                    if (!foundWildcard) {
                        return "The restricted type allows xs:any content that is not allowed by the base type. " + s;
                    }
                }
                boolean foundExistingPair = false;
                try {
                    end = new State[]{baseEdge.makeTransition(baseState), newDerivedState};
                }
                catch (ValidationException e) {
                    return "Occurrence limits on the restricted type exceed those on base type";
                }
                for (State[] anUnprocessed : unprocessed) {
                    if (!anUnprocessed[0].equals(end[0]) || !anUnprocessed[1].equals(end[1])) continue;
                    foundExistingPair = true;
                    break;
                }
                for (State[] aProcessed : processed) {
                    if (!aProcessed[0].equals(end[0]) || !aProcessed[1].equals(end[1])) continue;
                    foundExistingPair = true;
                    break;
                }
                if (foundExistingPair) continue;
                unprocessed.add(end);
            }
            unprocessed.remove(0);
            processed.add(p);
        }
        for (State e : finalDerivedStates) {
            Iterator processedPairIterator = processed.iterator();
            boolean unfound = false;
            while (processedPairIterator.hasNext()) {
                State[] pair = (State[])processedPairIterator.next();
                if (!pair[1].equals(e) || pair[0].isFinalState()) continue;
                unfound = true;
                break;
            }
            if (!unfound) continue;
            return "The restricted type allows a final state that is not allowed by the base type";
        }
        return null;
    }

    public static FiniteStateMachine determinize(SchemaCompiler compiler, FiniteStateMachine nfsa) throws SchemaException {
        FiniteStateMachine dfsa = new FiniteStateMachine(nfsa.complexType, true);
        dfsa.setOpenContentWildcard(nfsa.openContentWildcard, nfsa.openContentInterleaved);
        HashSet<DeterminizedState> unmarkedStatesOfD = new HashSet<DeterminizedState>(20);
        HashMap<IntSet, DeterminizedState> statesOfD = new HashMap<IntSet, DeterminizedState>(20);
        DeterminizedState initialD = (DeterminizedState)dfsa.getInitialState();
        initialD.setProvenance(FiniteStateMachine.lambdaClosure(new MonoIterator<AutomatonState>(nfsa.getInitialState())));
        initialD.setFinalState(FiniteStateMachine.containsFinalState(nfsa, initialD.getProvenance()));
        initialD.setLimits(nfsa.getInitialState().getMinOccurs(), nfsa.getInitialState().getMaxOccurs());
        unmarkedStatesOfD.add(initialD);
        statesOfD.put(initialD.getProvenance(), initialD);
        while (!unmarkedStatesOfD.isEmpty()) {
            DeterminizedState x = (DeterminizedState)unmarkedStatesOfD.iterator().next();
            unmarkedStatesOfD.remove(x);
            for (TermParticlePair pair : nfsa.alphabet) {
                Particle particle = pair.particle;
                Term a = pair.term;
                Set<AutomatonState> T = x.reachableStates(pair, nfsa);
                if (T.isEmpty()) continue;
                IntSet key = FiniteStateMachine.lambdaClosure(T.iterator());
                DeterminizedState dy = (DeterminizedState)statesOfD.get(key);
                if (dy == null) {
                    dy = new DeterminizedState(dfsa);
                    dy.setProvenance(key);
                    dy.setFinalState(FiniteStateMachine.containsFinalState(nfsa, key));
                    int[] limits = FiniteStateMachine.getOccurrenceLimits(nfsa, key);
                    dy.setLimits(limits[0], limits[1]);
                    unmarkedStatesOfD.add(dy);
                    statesOfD.put(key, dy);
                }
                x.addEdge(compiler, a, particle, dy);
            }
        }
        for (int i = dfsa.getNumberOfStates() - 1; i >= 0; --i) {
            ((DeterminizedState)dfsa.getState(i)).setProvenance(null);
        }
        return dfsa;
    }

    private static boolean containsFinalState(FiniteStateMachine machine, IntSet states) {
        IntIterator i = states.iterator();
        while (i.hasNext()) {
            int state = i.next();
            if (!machine.getState(state).isConditionallyFinalState()) continue;
            return true;
        }
        return false;
    }

    private static int[] getOccurrenceLimits(FiniteStateMachine machine, IntSet states) {
        IntIterator i = states.iterator();
        while (i.hasNext()) {
            int state = i.next();
            AutomatonState aState = machine.getState(state);
            if (aState.getMinOccurs() == -1) continue;
            return new int[]{aState.getMinOccurs(), aState.getMaxOccurs()};
        }
        return new int[]{-1, -1};
    }

    public Wildcard getOpenContentWildcard() {
        return this.openContentWildcard;
    }

    public boolean isOpenContentInterleaved() {
        return this.openContentInterleaved;
    }

    private static IntSet lambdaClosure(Iterator<AutomatonState> T_iter) {
        Stack<AutomatonState> stack = new Stack<AutomatonState>();
        IntRangeSet result = new IntRangeSet();
        while (T_iter.hasNext()) {
            NonDeterminizedState state = (NonDeterminizedState)T_iter.next();
            result.add(state.stateNumber);
            stack.push(state);
        }
        while (!stack.isEmpty()) {
            NonDeterminizedState s = (NonDeterminizedState)stack.pop();
            List<AutomatonState> transitions = s.getLambdaTransitions();
            if (transitions == null) continue;
            for (AutomatonState t : transitions) {
                if (!result.add(t.stateNumber)) continue;
                stack.push(t);
            }
        }
        return result;
    }

    public void serialize(SchemaModelSerializer serializer) throws XPathException {
        serializer.startElement("finiteStateMachine");
        serializer.emitAttribute("initialState", this.initialState.getStateNumber() + "");
        for (int s = 0; s < this.statesUsed; ++s) {
            this.states[s].serialize(serializer);
        }
        serializer.endElement();
    }

    protected static class TermParticlePair {
        public Term term;
        public Particle particle;

        public TermParticlePair(Term t, Particle p) {
            this.term = t;
            this.particle = p;
        }

        public boolean equals(Object obj) {
            return obj instanceof TermParticlePair && this.term == ((TermParticlePair)obj).term && this.particle == ((TermParticlePair)obj).particle;
        }

        public int hashCode() {
            return this.term.hashCode() ^ this.particle.hashCode();
        }
    }
}

