/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.stream.feed;

import com.saxonica.ee.stream.feed.Feed;
import com.saxonica.ee.stream.feed.ItemFeed;
import com.saxonica.ee.stream.watch.Terminator;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.sf.saxon.expr.Expression;
import net.sf.saxon.expr.GeneralComparison;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.expr.parser.Token;
import net.sf.saxon.expr.sort.AtomicMatchKey;
import net.sf.saxon.lib.ConversionRules;
import net.sf.saxon.lib.StringCollator;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.SequenceIterator;
import net.sf.saxon.trans.XPathException;
import net.sf.saxon.type.AtomicType;
import net.sf.saxon.type.BuiltInAtomicType;
import net.sf.saxon.type.BuiltInType;
import net.sf.saxon.type.Converter;
import net.sf.saxon.type.Type;
import net.sf.saxon.value.AtomicValue;
import net.sf.saxon.value.BooleanValue;
import net.sf.saxon.value.NumericValue;
import net.sf.saxon.value.UntypedAtomicValue;
import net.sf.saxon.z.IntHashMap;
import net.sf.saxon.z.IntIterator;

public class GeneralComparisonFeed
extends ItemFeed {
    private StringCollator collator;
    private IntHashMap<Set<AtomicMatchKey>> lookupTable;
    private List<UntypedAtomicValue> untypedValues;
    private int operator;
    private boolean done = false;
    private Expression pullOperand;
    private int implicitTimezone;

    public GeneralComparisonFeed(Expression expr, int pushedArg, Feed result, XPathContext context) {
        super(expr, result, context);
        GeneralComparison gc = (GeneralComparison)this.getExpression();
        this.collator = gc.getAtomicComparer().getCollator();
        this.operator = gc.getSingletonOperator();
        if (pushedArg == 1) {
            this.operator = Token.inverse(this.operator);
        }
        this.pullOperand = pushedArg == 0 ? gc.getRhsExpression() : gc.getLhsExpression();
        this.implicitTimezone = context.getImplicitTimezone();
    }

    @Override
    public void open(Terminator terminator) throws XPathException {
        super.open(terminator);
        this.done = false;
        this.lookupTable = null;
    }

    @Override
    public void processItem(Item<?> item) throws XPathException {
        if (!this.done) {
            IntIterator types;
            XPathContext context = this.getContext();
            ConversionRules rules = context.getConfiguration().getConversionRules();
            boolean ordered = this.operator != 50 && this.operator != 51;
            AtomicValue next = (AtomicValue)item;
            AtomicMatchKey k1 = next.getXPathComparable(ordered, this.collator, this.implicitTimezone);
            BuiltInAtomicType matchType = next instanceof NumericValue ? BuiltInAtomicType.DOUBLE : ((AtomicValue)item).getPrimitiveType();
            if (this.lookupTable == null) {
                AtomicValue val;
                this.lookupTable = new IntHashMap(4);
                this.untypedValues = new ArrayList<UntypedAtomicValue>(4);
                HashSet<AtomicMatchKey> strings = new HashSet<AtomicMatchKey>(10);
                this.lookupTable.put(631, strings);
                Object typed = null;
                if (!(next instanceof UntypedAtomicValue)) {
                    typed = new HashSet(10);
                    this.lookupTable.put(matchType.getFingerprint(), (Set<AtomicMatchKey>)typed);
                }
                SequenceIterator<?> comparand = this.pullOperand.iterate(context);
                while ((val = (AtomicValue)comparand.next()) != null) {
                    if (val instanceof UntypedAtomicValue) {
                        this.untypedValues.add((UntypedAtomicValue)val);
                        strings.add(((UntypedAtomicValue)val).getXPathComparable(ordered, this.collator, this.implicitTimezone));
                        if (typed == null) continue;
                        AtomicValue cval = Converter.convert(val, matchType, rules);
                        typed.add(cval.getXPathComparable(ordered, this.collator, this.implicitTimezone));
                        if (matchType == BuiltInAtomicType.UNTYPED_ATOMIC) continue;
                        strings.add(val.getXPathComparable(ordered, this.collator, this.implicitTimezone));
                        continue;
                    }
                    BuiltInAtomicType prim = val instanceof NumericValue ? BuiltInAtomicType.DOUBLE : val.getPrimitiveType();
                    Set<AtomicMatchKey> keys = this.lookupTable.get(prim.getFingerprint());
                    if (keys == null) {
                        keys = new HashSet<AtomicMatchKey>(10);
                        this.lookupTable.put(prim.getFingerprint(), keys);
                    }
                    keys.add(val.getXPathComparable(ordered, this.collator, this.implicitTimezone));
                }
                for (UntypedAtomicValue untypedVal : this.untypedValues) {
                    IntIterator types2 = this.lookupTable.keyIterator();
                    while (types2.hasNext()) {
                        int type = types2.next();
                        Set<AtomicMatchKey> keys = this.lookupTable.get(type);
                        BuiltInAtomicType atomicType = (BuiltInAtomicType)BuiltInType.getSchemaType(type);
                        keys.add(Converter.convert(untypedVal, atomicType, rules).getXPathComparable(ordered, this.collator, this.implicitTimezone));
                    }
                }
            } else {
                Set<AtomicMatchKey> typed = this.lookupTable.get(matchType.getFingerprint());
                if (typed == null) {
                    typed = new HashSet<AtomicMatchKey>(10);
                    this.lookupTable.put(matchType.getFingerprint(), typed);
                    for (UntypedAtomicValue val : this.untypedValues) {
                        AtomicValue cval = Converter.convert(val, matchType, rules);
                        typed.add(cval.getXPathComparable(ordered, this.collator, this.implicitTimezone));
                    }
                }
            }
            Set<AtomicMatchKey> lookup = this.lookupTable.get(matchType.getFingerprint());
            if (next instanceof UntypedAtomicValue) {
                types = this.lookupTable.keyIterator();
                while (types.hasNext() && !this.done) {
                    int t = types.next();
                    AtomicValue converted = Converter.convert(next, (AtomicType)BuiltInType.getSchemaType(t), rules);
                    lookup = this.lookupTable.get(t);
                    if (lookup == null) continue;
                    this.testValue(lookup, converted.getXPathComparable(ordered, this.collator, this.implicitTimezone));
                }
            } else {
                types = this.lookupTable.keyIterator();
                while (types.hasNext() && !this.done) {
                    BuiltInAtomicType u;
                    int t = types.next();
                    if (t == 631 || matchType == (u = (BuiltInAtomicType)BuiltInType.getSchemaType(t)) || Type.isGuaranteedComparable(matchType, u, ordered)) continue;
                    throw new XPathException("Comparison between " + matchType.getDisplayName() + " and " + u.getDisplayName() + " is not allowed", "XPTY0004", this.getExpression().getLocation());
                }
                this.testValue(lookup, k1);
            }
        }
    }

    private void testValue(Set<AtomicMatchKey> lookup, AtomicMatchKey k) throws XPathException {
        block8: {
            block9: {
                block7: {
                    if (this.operator != 50) break block7;
                    if (!lookup.contains(k)) break block8;
                    this.done = true;
                    this.getResult().processItem(BooleanValue.TRUE);
                    this.getResult().close();
                    this.lookupTable = null;
                    this.getTerminator().terminate();
                    break block8;
                }
                if (this.operator != 51) break block9;
                if (lookup.size() <= 1 && lookup.contains(k)) break block8;
                this.done = true;
                this.getResult().processItem(BooleanValue.TRUE);
                this.getResult().close();
                this.lookupTable = null;
                this.getTerminator().terminate();
                break block8;
            }
            for (AtomicMatchKey k2 : lookup) {
                boolean result;
                int c = ((Comparable)((Object)k)).compareTo(k2);
                switch (this.operator) {
                    case 55: {
                        result = c <= 0;
                        break;
                    }
                    case 53: {
                        result = c < 0;
                        break;
                    }
                    case 54: {
                        result = c >= 0;
                        break;
                    }
                    case 52: {
                        result = c > 0;
                        break;
                    }
                    default: {
                        result = false;
                    }
                }
                if (!result) continue;
                this.done = true;
                this.getResult().processItem(BooleanValue.TRUE);
                this.getResult().close();
                this.lookupTable = null;
                this.getTerminator().terminate();
                break;
            }
        }
    }

    @Override
    public void close() throws XPathException {
        if (!this.done) {
            this.getResult().processItem(BooleanValue.FALSE);
            super.close();
            this.lookupTable = null;
        }
    }
}

