/*
 * Decompiled with CFR 0.152.
 */
package com.saxonica.ee.trans;

import com.saxonica.ee.trans.Characteristic;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.om.Item;
import net.sf.saxon.om.NodeInfo;
import net.sf.saxon.pattern.Pattern;
import net.sf.saxon.trans.XPathException;

public class AncestorCharacteristic
extends Characteristic<Boolean> {
    private Pattern pattern;
    private boolean isParent;

    public AncestorCharacteristic(Pattern pattern, boolean isParent) {
        this.pattern = pattern;
        this.isParent = isParent;
    }

    @Override
    public Boolean evaluate(XPathContext context) throws XPathException {
        Item<?> item = context.getContextItem();
        if (!(item instanceof NodeInfo)) {
            return false;
        }
        if (this.isParent) {
            return this.pattern.matches(((NodeInfo)item).getParent(), context);
        }
        for (NodeInfo a = (NodeInfo)item; a != null; a = a.getParent()) {
            if (!this.pattern.matches(a, context)) continue;
            return true;
        }
        return false;
    }

    public int hashCode() {
        return this.pattern.hashCode() ^ (this.isParent ? 8484 : 7373);
    }

    public boolean equals(Object obj) {
        return obj instanceof AncestorCharacteristic && this.pattern.isEqual(((AncestorCharacteristic)obj).pattern) && this.isParent == ((AncestorCharacteristic)obj).isParent;
    }

    public String toString() {
        return this.pattern + (this.isParent ? "/" : "//");
    }
}

