/*
 * Decompiled with CFR 0.152.
 */
package marmot.morph;

import java.util.ArrayList;
import java.util.List;
import lemming.lemma.LemmaInstance;
import lemming.lemma.Lemmatizer;
import lemming.lemma.ranker.RankerCandidate;
import marmot.core.Model;
import marmot.core.Sequence;
import marmot.core.SimpleTagger;
import marmot.core.State;
import marmot.core.Token;
import marmot.core.WeightVector;
import marmot.morph.MorphModel;
import marmot.morph.Word;

public class MorphTagger
extends SimpleTagger {
    private static final long serialVersionUID = 1L;
    private transient Lemmatizer lemmatizer_;

    public MorphTagger(Model model, int order, WeightVector weight_vector) {
        super(model, order, weight_vector);
    }

    public void setPipeLineLemmatizer(Lemmatizer lemmatizer) {
        this.lemmatizer_ = lemmatizer;
    }

    protected void addIndexes(Sequence sequence) {
        MorphModel model = (MorphModel)this.getModel();
        for (Token token2 : sequence) {
            Word word = (Word)token2;
            model.addIndexes(word, false);
        }
    }

    @Override
    public List<List<String>> tag(Sequence sequence) {
        this.addIndexes(sequence);
        return super.tag(sequence);
    }

    public List<List<String>> tagWithLemma(Sequence sequence) {
        this.addIndexes(sequence);
        List<State> states = this.tag_states(sequence);
        ArrayList<List<String>> list = new ArrayList<List<String>>(sequence.size());
        int token_index = 0;
        for (State state : states) {
            ArrayList<String> lemma_tags = new ArrayList<String>();
            List<String> tags = this.indexesToStrings(this.stateToIndexes(state));
            String lemma = null;
            if (state.getLemmaCandidates() != null) {
                RankerCandidate candidate = RankerCandidate.bestCandidate(state.getLemmaCandidates());
                lemma = candidate.getLemma();
            } else if (this.lemmatizer_ != null) {
                Word word = (Word)sequence.get(token_index);
                LemmaInstance instance = LemmaInstance.getInstance(word);
                instance.setPosTag(tags.get(0));
                if (1 < tags.size()) {
                    instance.setMorphTag(tags.get(1));
                }
                lemma = this.lemmatizer_.lemmatize(instance);
            }
            lemma_tags.add(lemma);
            lemma_tags.addAll(tags);
            list.add(lemma_tags);
            ++token_index;
        }
        return list;
    }
}

